/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Coeff;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.LinearInequality;
import org.sosy_lab.cpachecker.util.invariants.balancer.IRMatrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;
import org.sosy_lab.cpachecker.util.invariants.balancer.interfaces.MatrixI;
import org.sosy_lab.cpachecker.util.invariants.interfaces.Constraint;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class TemplateLinearizer {
    public static LinearInequality linearize(TemplateFormula t, VariableManager vmgr) {
        if (t.isTrue()) {
            return TemplateLinearizer.booleanLineq(vmgr, true);
        }
        if (t.isFalse()) {
            return TemplateLinearizer.booleanLineq(vmgr, false);
        }
        LinearInequality lineq = new LinearInequality(vmgr);
        Vector<TemplateConstraint> constraints = t.getConstraints();
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint cons = (Constraint)constraints.get(i);
            List<Coeff> coeffs = cons.getNormalFormCoeffs(vmgr, VariableWriteMode.REDLOG);
            Coeff rhs = cons.getNormalFormConstant(VariableWriteMode.REDLOG);
            InfixReln reln = cons.getInfixReln();
            if (reln != InfixReln.EQUAL) {
                lineq.addIneq(coeffs, reln, rhs);
                continue;
            }
            lineq.addIneq(coeffs, InfixReln.LEQ, rhs);
            coeffs = TemplateLinearizer.negative(coeffs);
            rhs = rhs.negative();
            lineq.addIneq(coeffs, InfixReln.LEQ, rhs);
        }
        return lineq;
    }

    public static IRMatrix buildIRMatrix(TemplateFormula t, VariableManager vmgr, Map<String, Variable> paramVars) {
        if (t.isTrue()) {
            return TemplateLinearizer.booleanIRMatrix(vmgr, true);
        }
        if (t.isFalse()) {
            return TemplateLinearizer.booleanIRMatrix(vmgr, false);
        }
        Vector<TemplateConstraint> constraints = t.getConstraints();
        if (constraints.size() < 1) {
            System.err.println("Tried to build matrix on no constraints.");
            return null;
        }
        Vector<IRMatrix> cols = new Vector<IRMatrix>();
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint cons = (Constraint)constraints.get(i);
            List<Coeff> coeffs = cons.getNormalFormCoeffs(vmgr, VariableWriteMode.REDLOG);
            Coeff rhs = cons.getNormalFormConstant(VariableWriteMode.REDLOG);
            List<RationalFunction> rfs = TemplateLinearizer.makeRationalFunctions(coeffs, paramVars);
            rfs.add(rhs.makeRationalFunction(paramVars));
            InfixReln reln = cons.getInfixReln();
            if (reln != InfixReln.EQUAL) {
                cols.add(new IRMatrix(rfs, reln));
                continue;
            }
            cols.add(new IRMatrix(rfs, InfixReln.LEQ));
            coeffs = TemplateLinearizer.negative(coeffs);
            rhs = rhs.negative();
            rfs = TemplateLinearizer.makeRationalFunctions(coeffs, paramVars);
            rfs.add(rhs.makeRationalFunction(paramVars));
            cols.add(new IRMatrix(rfs, InfixReln.LEQ));
        }
        IRMatrix a = (IRMatrix)cols.get(0);
        for (int i = 1; i < cols.size(); ++i) {
            a = IRMatrix.concat(a, (IRMatrix)cols.get(i));
        }
        return a;
    }

    public static Matrix buildMatrix(TemplateFormula t, VariableManager vmgr, Map<String, Variable> paramVars) {
        if (t.isTrue()) {
            return TemplateLinearizer.booleanMatrix(vmgr, true);
        }
        if (t.isFalse()) {
            return TemplateLinearizer.booleanMatrix(vmgr, false);
        }
        Vector<TemplateConstraint> constraints = t.getConstraints();
        if (constraints.size() < 1) {
            System.err.println("Tried to build matrix on no constraints.");
            return null;
        }
        Vector<Matrix> cols = new Vector<Matrix>();
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint cons = (Constraint)constraints.get(i);
            List<Coeff> coeffs = cons.getNormalFormCoeffs(vmgr, VariableWriteMode.REDLOG);
            Coeff rhs = cons.getNormalFormConstant(VariableWriteMode.REDLOG);
            coeffs.add(rhs.negative());
            List<RationalFunction> rfs = TemplateLinearizer.makeRationalFunctions(coeffs, paramVars);
            cols.add(new Matrix(rfs));
            InfixReln reln = cons.getInfixReln();
            if (reln != InfixReln.EQUAL) continue;
            coeffs = TemplateLinearizer.negative(coeffs);
            rfs = TemplateLinearizer.makeRationalFunctions(coeffs, paramVars);
            cols.add(new Matrix(rfs));
        }
        Matrix a = (Matrix)cols.get(0);
        for (int i = 1; i < cols.size(); ++i) {
            a = a.concat((MatrixI)cols.get(i));
        }
        return a;
    }

    private static List<RationalFunction> makeRationalFunctions(List<Coeff> clist, Map<String, Variable> paramVars) {
        Vector<RationalFunction> rfs = new Vector<RationalFunction>(clist.size());
        for (Coeff c : clist) {
            rfs.add(c.makeRationalFunction(paramVars));
        }
        return rfs;
    }

    private static LinearInequality booleanLineq(VariableManager vmgr, boolean trueStatement) {
        LinearInequality lineq = new LinearInequality(vmgr);
        int n = vmgr.getNumVars();
        List<Coeff> coeffs = Collections.nCopies(n, new Coeff("0"));
        Coeff rhs = new Coeff("0");
        InfixReln reln = trueStatement ? InfixReln.LEQ : InfixReln.LT;
        lineq.addIneq(coeffs, reln, rhs);
        return lineq;
    }

    private static IRMatrix booleanIRMatrix(VariableManager vmgr, boolean trueStatement) {
        int n = vmgr.getNumVars();
        List<RationalFunction> rfs = Collections.nCopies(n + 1, new RationalFunction(0));
        InfixReln reln = trueStatement ? InfixReln.LEQ : InfixReln.LT;
        return new IRMatrix(rfs, reln);
    }

    private static Matrix booleanMatrix(VariableManager vmgr, boolean trueStatement) {
        int n = vmgr.getNumVars();
        List<RationalFunction> rfs = Collections.nCopies(n, new RationalFunction(0));
        RationalFunction constant = trueStatement ? new RationalFunction(-1) : new RationalFunction(1);
        rfs.add(constant);
        return new Matrix(rfs);
    }

    private static List<Coeff> negative(List<Coeff> P) {
        Vector<Coeff> N = new Vector<Coeff>();
        for (int i = 0; i < P.size(); ++i) {
            Coeff C = P.get(i);
            N.add(C.negative());
        }
        return N;
    }
}

