/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateNumber
extends TemplateFormula {
    private Rational rat;

    public TemplateNumber(int n) {
        this.rat = new Rational(n, 1);
    }

    public TemplateNumber(String s) {
        try {
            Integer i = new Integer(s);
            this.rat = new Rational(i, 1);
        }
        catch (Exception e) {
            System.err.println("Attempted to use float " + s + ".\nOnly rational coefficients are allowed.");
            System.exit(1);
        }
    }

    public Rational rationalValue() {
        return this.rat;
    }

    public TemplateNumber(Rational r) {
        this.rat = r;
    }

    @Override
    public TemplateNumber copy() {
        TemplateNumber n = new TemplateNumber(this.rat.copy());
        return n;
    }

    public boolean isZero() {
        return this.rat.isZero();
    }

    @Override
    public void negate() {
        this.rat = this.rat.makeNegative();
    }

    public static TemplateNumber multiply(TemplateNumber n1, TemplateNumber n2) {
        Rational r = n1.rat.times(n2.rat);
        return new TemplateNumber(r);
    }

    public static TemplateNumber add(TemplateNumber n1, TemplateNumber n2) {
        Rational r = n1.rat.plus(n2.rat);
        return new TemplateNumber(r);
    }

    public TemplateNumber divideBy(TemplateNumber n) {
        return new TemplateNumber(this.rat.div(n.rat));
    }

    public TemplateNumber makeReciprocal() {
        return new TemplateNumber(this.rat.makeReciprocal());
    }

    public static TemplateNumber makeUnity() {
        return new TemplateNumber(Rational.makeUnity());
    }

    public static TemplateNumber makeZero() {
        return new TemplateNumber(Rational.makeZero());
    }

    public boolean equals(TemplateNumber n) {
        return this.rat.equals(n.rat);
    }

    @Override
    public Formula translate(FormulaManager fmgr) {
        return fmgr.makeNumber(this.rat.toString());
    }

    @Override
    public String toString() {
        return this.rat.toString();
    }
}

