/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.List;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.PathFormulaManagerImpl;

public class TemplatePathFormulaBuilder {
    private PathFormulaManagerImpl pfmgr;

    public TemplatePathFormulaBuilder() {
        Configuration config = Configuration.defaultConfiguration();
        try {
            LogManager logger = new LogManager(config);
            TemplateFormulaManager fmgr = new TemplateFormulaManager(TemplateFormulaManager.TemplateParseMode.PATHFORMULA);
            ExtendedFormulaManager efmgr = new ExtendedFormulaManager(fmgr, config, logger);
            this.pfmgr = new PathFormulaManagerImpl(efmgr, config, logger);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public TemplatePathFormulaBuilder(Configuration config, LogManager logger) {
        try {
            TemplateFormulaManager fmgr = new TemplateFormulaManager(TemplateFormulaManager.TemplateParseMode.PATHFORMULA);
            ExtendedFormulaManager efmgr = new ExtendedFormulaManager(fmgr, config, logger);
            this.pfmgr = new PathFormulaManagerImpl(efmgr, config, logger);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public PathFormula buildPathFormula(CFAEdge ... E) {
        PathFormula pf = null;
        try {
            pf = this.pfmgr.makeEmptyPathFormula();
            for (int i = 0; i < E.length; ++i) {
                pf = this.pfmgr.makeAnd(pf, E[i]);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return pf;
    }

    public PathFormula buildPathFormula(List<CFAEdge> L) {
        CFAEdge[] A = new CFAEdge[L.size()];
        for (int i = 0; i < L.size(); ++i) {
            A[i] = L.get(i);
        }
        return this.buildPathFormula(A);
    }
}

