/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Coeff;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Term;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;
import org.sosy_lab.cpachecker.util.invariants.interfaces.GeneralVariable;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.MonomialOrder;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.SimpleMonomialOrder;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateNumber;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateUIF;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateSum
extends TemplateFormula {
    private Vector<TemplateTerm> terms;

    public TemplateSum() {
        this.terms = new Vector();
    }

    public TemplateSum(TemplateTerm T) {
        this.terms = new Vector();
        this.terms.add(T);
    }

    public TemplateSum(Vector<TemplateTerm> t) {
        this.terms = t;
    }

    public TemplateSum(Collection<TemplateTerm> s) {
        this.terms = new Vector<TemplateTerm>(s);
    }

    public TemplateSum(TemplateSum s1, TemplateSum s2) {
        this.terms = new Vector();
        this.terms.addAll(s1.getTerms());
        this.terms.addAll(s2.getTerms());
    }

    public static TemplateSum freshParamLinComb(Collection<TemplateTerm> c) {
        Vector<TemplateTerm> v = new Vector<TemplateTerm>(c.size());
        for (TemplateTerm t : c) {
            TemplateVariable param = TemplateTerm.getNextFreshParameter();
            t = t.copy();
            t.setParameter(param);
            v.add(t);
        }
        return new TemplateSum(v);
    }

    public TemplateSum minusOne() {
        return TemplateSum.subtract(this, TemplateSum.makeUnity());
    }

    public static TemplateSum makeUnity() {
        return new TemplateSum(TemplateTerm.makeUnity());
    }

    @Override
    public TemplateSum copy() {
        Vector<TemplateTerm> v = new Vector<TemplateTerm>();
        for (TemplateTerm t : this.terms) {
            v.add(t.copy());
        }
        TemplateSum s = new TemplateSum(v);
        return s;
    }

    public Polynomial makePolynomial(Map<String, Variable> paramVars) {
        Vector<Term> tlist = new Vector<Term>(this.terms.size());
        for (TemplateTerm t : this.terms) {
            Term u = t.makeRationalFunctionTerm(paramVars);
            tlist.add(u);
        }
        return new Polynomial(tlist);
    }

    @Override
    public void alias(AliasingMap amap) {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.alias(amap);
        }
    }

    @Override
    public void unalias() {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.unalias();
        }
    }

    @Override
    public boolean evaluate(Map<String, Rational> map) {
        boolean ans = true;
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            ans &= T.evaluate(map);
        }
        this.dropZeroTerms();
        return ans;
    }

    @Override
    public void unevaluate() {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.unevaluate();
        }
    }

    @Override
    public void postindex(Map<String, Integer> indices) {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.postindex(indices);
        }
    }

    @Override
    public void preindex(Map<String, Integer> indices) {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.preindex(indices);
        }
    }

    @Override
    public void unindex() {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.unindex();
        }
    }

    @Override
    public Purification purify(Purification pur) {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            pur = T.purify(pur);
        }
        this.normalize(new SimpleMonomialOrder());
        return pur;
    }

    @Override
    public void unpurify() {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.unpurify();
        }
    }

    public void generalize() {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.generalize();
        }
    }

    @Override
    public Set<String> getAllVariables(VariableWriteMode vwm) {
        HashSet<String> vars = new HashSet<String>();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            vars.addAll(T.getAllVariables(vwm));
        }
        return vars;
    }

    @Override
    public Set<TemplateVariable> getAllParameters() {
        HashSet<TemplateVariable> params = new HashSet<TemplateVariable>();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            params.addAll(T.getAllParameters());
        }
        return params;
    }

    public Set<TemplateVariable> getTopLevelParameters() {
        HashSet<TemplateVariable> tlp = new HashSet<TemplateVariable>();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            if (!T.hasParameter()) continue;
            tlp.add(T.getParameter());
        }
        return tlp;
    }

    @Override
    public Set<TemplateUIF> getAllTopLevelUIFs() {
        HashSet<TemplateUIF> tlu = new HashSet<TemplateUIF>();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            if (!T.hasUIF()) continue;
            tlu.add(T.getUIF());
        }
        return tlu;
    }

    @Override
    public Set<TemplateVariable> getAllPurificationVariables() {
        HashSet<TemplateVariable> pvs = new HashSet<TemplateVariable>();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            pvs.addAll(T.getAllPurificationVariables());
        }
        return pvs;
    }

    @Override
    public HashMap<String, Integer> getMaxIndices(HashMap<String, Integer> map) {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            map = T.getMaxIndices(map);
        }
        return map;
    }

    @Override
    public TemplateVariableManager getVariableManager() {
        TemplateVariableManager tvm = new TemplateVariableManager();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            TemplateVariableManager Ttvm = T.getVariableManager();
            tvm.merge(Ttvm);
        }
        return tvm;
    }

    public void prefixVariables(String prefix) {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.prefixVariables(prefix);
        }
    }

    @Override
    public Formula translate(FormulaManager fmgr) {
        Formula form = null;
        int N = this.getNumTerms();
        if (N == 0) {
            TemplateTerm Z = TemplateTerm.makeZero();
            form = Z.translate(fmgr);
        } else {
            assert (N >= 1);
            form = this.getTerm(0).translate(fmgr);
            for (int i = 1; i < N; ++i) {
                Formula augend = this.getTerm(i).translate(fmgr);
                form = fmgr.makePlus(form, augend);
            }
        }
        return form;
    }

    private void merge(TemplateSum s) {
        this.terms.addAll(s.getTerms());
    }

    public void sort(MonomialOrder mo) {
        Collections.sort(this.terms, mo);
    }

    public void dropZeroTerms() {
        Vector<TemplateTerm> v = new Vector<TemplateTerm>();
        for (TemplateTerm t : this.terms) {
            if (t.isZero()) continue;
            v.add(t);
        }
        if (v.size() == 0) {
            v.add(TemplateTerm.makeZero());
        }
        this.terms = v;
    }

    public void normalize(MonomialOrder mo) {
        this.sort(mo);
        Vector<TemplateTerm> newTerms = new Vector<TemplateTerm>();
        TemplateTerm U = null;
        TemplateNumber S = new TemplateNumber(0);
        String lastMonomial = "";
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            String monomial = T.getMonomialString(VariableWriteMode.PLAIN);
            TemplateNumber C = T.getCoefficient();
            if (monomial.equals(lastMonomial)) {
                S = TemplateNumber.add(S, C);
            } else {
                if (lastMonomial.length() > 0) {
                    U.setCoefficient(S);
                    newTerms.add(U);
                }
                S = C;
                lastMonomial = monomial;
            }
            U = T;
        }
        if (lastMonomial.length() > 0) {
            U.setCoefficient(S);
            newTerms.add(U);
        }
        this.terms = newTerms;
    }

    private HashMap<String, TemplateSum> collectWRTVars() {
        HashMap<String, TemplateSum> map = new HashMap<String, TemplateSum>();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateSum S;
            TemplateTerm T = this.getTerm(i);
            if (!T.hasAnyVariable()) continue;
            TemplateVariable V = T.getAnyVariable();
            String var = V.toString(VariableWriteMode.PLAIN);
            if (!map.containsKey(var)) {
                S = new TemplateSum(T);
                map.put(var, S);
                continue;
            }
            S = new TemplateSum(T);
            TemplateSum R = map.get(var);
            R.merge(S);
        }
        return map;
    }

    private Coeff getSumOfAllCoeffsWithParams(VariableWriteMode vwm) {
        Vector<TemplateTerm> c = new Vector<TemplateTerm>();
        for (TemplateTerm t : this.getTerms()) {
            TemplateTerm u = t.copy();
            u.setVariable(null);
            u.setUIF(null);
            if (!u.hasCoefficient()) {
                u.setCoefficient(TemplateNumber.makeUnity());
            }
            c.add(u);
        }
        TemplateSum s = new TemplateSum((Collection<TemplateTerm>)c);
        Coeff co = new Coeff(s, vwm);
        return co;
    }

    public Vector<Coeff> getCoeffsWithParams(VariableWriteMode vwm, VariableManager vmgr) {
        HashMap<String, TemplateSum> vmap = this.collectWRTVars();
        Vector<Coeff> coeffs = new Vector<Coeff>();
        Iterator<GeneralVariable> I = vmgr.iterator();
        while (I.hasNext()) {
            GeneralVariable V = I.next();
            String var = V.toString(VariableWriteMode.PLAIN);
            if (!vmap.containsKey(var)) {
                coeffs.add(new Coeff("0"));
                continue;
            }
            TemplateSum S = vmap.get(var);
            Coeff C = S.getSumOfAllCoeffsWithParams(vwm);
            coeffs.add(C);
        }
        return coeffs;
    }

    public TemplateSum getConstantPart() {
        Vector<TemplateTerm> V = new Vector<TemplateTerm>();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            if (!T.isConstant()) continue;
            V.add(T);
        }
        return new TemplateSum(V);
    }

    public TemplateSum getNonConstantPart() {
        Vector<TemplateTerm> V = new Vector<TemplateTerm>();
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            if (T.isConstant()) continue;
            V.add(T);
        }
        return new TemplateSum(V);
    }

    public Vector<TemplateTerm> getTerms() {
        return this.terms;
    }

    public int getNumTerms() {
        return this.terms.size();
    }

    public TemplateTerm getTerm(int i) {
        return this.terms.get(i);
    }

    @Override
    public void negate() {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.negate();
        }
    }

    public boolean isANumber() {
        boolean ans = false;
        if (this.getNumTerms() == 1) {
            TemplateTerm T = this.getTerm(0);
            ans = T.isANumber();
        }
        return ans;
    }

    public Integer getInteger() {
        Integer I = null;
        if (this.isANumber()) {
            TemplateTerm T = this.getTerm(0);
            I = T.getInteger();
        }
        return I;
    }

    public static TemplateSum subtract(TemplateSum s1, TemplateSum s2) {
        s2.negate();
        return new TemplateSum(s1, s2);
    }

    public static TemplateSum multiply(TemplateSum s1, TemplateSum s2) {
        Vector<TemplateTerm> terms1 = s1.getTerms();
        Vector<TemplateTerm> terms2 = s2.getTerms();
        Vector<TemplateTerm> terms3 = new Vector<TemplateTerm>();
        for (int i = 0; i < terms1.size(); ++i) {
            for (int j = 0; j < terms2.size(); ++j) {
                TemplateTerm T1 = terms1.get(i);
                TemplateTerm T2 = terms2.get(j);
                TemplateTerm T3 = TemplateTerm.multiply(T1, T2);
                terms3.add(T3);
            }
        }
        return new TemplateSum(terms3);
    }

    public static TemplateFormula divide(TemplateSum s1, TemplateSum s2) {
        TemplateTerm term;
        TemplateNumber n = null;
        int t = s2.getNumTerms();
        if (t == 1 && (term = s2.getTerm(0)).isANumber()) {
            n = term.getCoefficient();
        }
        if (n == null) {
            System.err.println("Tried to divide by a TemplateSum that was not a single number.");
            System.exit(1);
        }
        Vector<TemplateTerm> c = new Vector<TemplateTerm>(s1.getNumTerms());
        for (TemplateTerm term2 : s1.getTerms()) {
            TemplateTerm q = term2.divideBy(n);
            c.add(q);
        }
        return new TemplateSum((Collection<TemplateTerm>)c);
    }

    void writeAsForm(boolean b) {
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            T.writeAsForm(b);
        }
    }

    @Override
    public String toString() {
        return this.toString(VariableWriteMode.PLAIN);
    }

    @Override
    public String toString(VariableWriteMode vwm) {
        String s = "";
        for (int i = 0; i < this.getNumTerms(); ++i) {
            TemplateTerm T = this.getTerm(i);
            s = s + " + " + T.toString(vwm);
        }
        s = s.length() > 0 ? s.substring(3) : "0";
        return s;
    }
}

