/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormulaList;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSum;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateSumList
extends TemplateFormulaList {
    private TemplateSum[] sums = null;

    public TemplateSumList(TemplateSum[] sums) {
        this.sums = sums;
    }

    public TemplateSumList(TemplateFormulaList TF) throws ClassCastException {
        Formula[] F = TF.getFormulas();
        this.sums = new TemplateSum[F.length];
        for (int i = 0; i < F.length; ++i) {
            this.sums[i] = (TemplateSum)F[i];
        }
    }

    public TemplateSumList copy() {
        TemplateSumList s = null;
        if (this.sums == null) {
            s = new TemplateSumList(new TemplateSum[0]);
        } else {
            TemplateSum[] sa = new TemplateSum[this.sums.length];
            for (int i = 0; i < this.sums.length; ++i) {
                sa[i] = this.sums[i].copy();
            }
            s = new TemplateSumList(sa);
        }
        return s;
    }

    public void alias(AliasingMap amap) {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].alias(amap);
            }
        }
    }

    public void unalias() {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].unalias();
            }
        }
    }

    public boolean evaluate(Map<String, Rational> map) {
        boolean ans = true;
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                ans &= this.sums[i].evaluate(map);
            }
        }
        return ans;
    }

    public void unevaluate() {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].unevaluate();
            }
        }
    }

    public void postindex(Map<String, Integer> indices) {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].postindex(indices);
            }
        }
    }

    public void preindex(Map<String, Integer> indices) {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].preindex(indices);
            }
        }
    }

    public void unindex() {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].unindex();
            }
        }
    }

    public Purification purify(Purification pur) {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                pur = this.sums[i].purify(pur);
            }
        }
        return pur;
    }

    public void unpurify() {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].unpurify();
            }
        }
    }

    public void generalize() {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].generalize();
            }
        }
    }

    public Set<String> getAllVariables(VariableWriteMode vwm) {
        HashSet<String> vars = new HashSet<String>();
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                vars.addAll(this.sums[i].getAllVariables(vwm));
            }
        }
        return vars;
    }

    public Set<TemplateVariable> getAllParameters() {
        HashSet<TemplateVariable> params = new HashSet<TemplateVariable>();
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                params.addAll(this.sums[i].getAllParameters());
            }
        }
        return params;
    }

    public HashMap<String, Integer> getMaxIndices(HashMap<String, Integer> map) {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                map = this.sums[i].getMaxIndices(map);
            }
        }
        return map;
    }

    public TemplateVariableManager getVariableManager() {
        TemplateVariableManager tvm = new TemplateVariableManager();
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                tvm.merge(this.sums[i].getVariableManager());
            }
        }
        return tvm;
    }

    public void prefixVariables(String prefix) {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].prefixVariables(prefix);
            }
        }
    }

    public FormulaList translate(FormulaManager fmgr) {
        Vector<Formula> lf = new Vector<Formula>(this.sums.length);
        for (int i = 0; i < this.sums.length; ++i) {
            lf.add(this.sums[i].translate(fmgr));
        }
        return fmgr.makeList(lf);
    }

    public int size() {
        return this.sums.length;
    }

    public Iterator<TemplateSum> iterator() {
        Vector<TemplateSum> V = new Vector<TemplateSum>();
        for (int i = 0; i < this.sums.length; ++i) {
            V.add(this.sums[i]);
        }
        return V.iterator();
    }

    void writeAsForm(boolean b) {
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                this.sums[i].writeAsForm(b);
            }
        }
    }

    public String toString(String delim) {
        return this.toString(delim, VariableWriteMode.PLAIN);
    }

    public String toString(String delim, VariableWriteMode vwm) {
        String s = "";
        if (this.sums != null) {
            for (int i = 0; i < this.sums.length; ++i) {
                s = s + delim;
                s = s + this.sums[i].toString(vwm);
            }
        }
        if (s.length() > 0) {
            s = s.substring(delim.length());
        }
        return s;
    }
}

