/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.sosy_lab.cpachecker.util.invariants.Coeff;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Monomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Term;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateNumber;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSum;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateUIF;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateTerm
extends TemplateSum {
    private TemplateVariable var = null;
    private TemplateUIF uif = null;
    private TemplateVariable param = null;
    private TemplateNumber coeff = null;
    private static AtomicInteger nextParamIndex = new AtomicInteger(0);
    public static final String paramHead = "p";
    private boolean writingAsForm = false;
    private TemplateVariable oldParam = null;
    private TemplateNumber oldCoeff = null;

    public TemplateTerm() {
    }

    public TemplateTerm(TemplateUIF uif) {
        this.uif = uif;
    }

    public static TemplateTerm makeZero() {
        TemplateTerm T = new TemplateTerm();
        T.setCoefficient(new TemplateNumber(0));
        return T;
    }

    public static TemplateTerm makeUnity() {
        TemplateTerm T = new TemplateTerm();
        T.setCoefficient(new TemplateNumber(1));
        return T;
    }

    @Override
    public void alias(AliasingMap amap) {
        if (this.hasVariable()) {
            TemplateVariable v = this.getVariable();
            v.alias(amap);
        } else if (this.hasUIF()) {
            TemplateUIF u = this.getUIF();
            u.alias(amap);
        }
    }

    @Override
    public void unalias() {
        if (this.hasVariable()) {
            TemplateVariable V = this.getVariable();
            V.unalias();
        } else if (this.hasUIF()) {
            TemplateUIF U = this.getUIF();
            U.unalias();
        }
    }

    @Override
    public boolean evaluate(Map<String, Rational> map) {
        boolean ans = true;
        if (this.hasParameter()) {
            ans = false;
            String a = this.getParameter().toString(VariableWriteMode.REDLOG);
            if (map.containsKey(a)) {
                Rational R = map.get(a);
                this.oldParam = this.param;
                this.param = null;
                this.oldCoeff = this.coeff;
                TemplateNumber P = new TemplateNumber(R);
                if (!this.hasCoefficient()) {
                    this.setCoefficient(P);
                } else {
                    TemplateNumber Q = this.getCoefficient();
                    TemplateNumber M = TemplateNumber.multiply(Q, P);
                    this.setCoefficient(M);
                }
                ans = true;
            }
        }
        if (this.hasUIF()) {
            TemplateUIF U = this.getUIF();
            ans &= U.evaluate(map);
        }
        return ans;
    }

    @Override
    public void unevaluate() {
        this.param = this.oldParam;
        this.coeff = this.oldCoeff;
        if (this.hasUIF()) {
            TemplateUIF U = this.getUIF();
            U.unevaluate();
        }
    }

    @Override
    public void postindex(Map<String, Integer> indices) {
        if (this.hasVariable()) {
            this.var.postindex(indices);
        } else if (this.hasUIF()) {
            TemplateUIF U = this.getUIF();
            U.postindex(indices);
        }
    }

    @Override
    public void preindex(Map<String, Integer> indices) {
        if (this.hasVariable()) {
            this.var.preindex(indices);
        } else if (this.hasUIF()) {
            TemplateUIF U = this.getUIF();
            U.preindex(indices);
        }
    }

    @Override
    public void unindex() {
        if (this.hasVariable()) {
            this.var.unindex();
        } else if (this.hasUIF()) {
            TemplateUIF U = this.getUIF();
            U.unindex();
        }
    }

    @Override
    public Purification purify(Purification pur) {
        if (this.hasUIF()) {
            pur = this.uif.purify(pur);
        }
        return pur;
    }

    @Override
    public void unpurify() {
        if (this.hasUIF()) {
            this.uif.unpurify();
        }
    }

    @Override
    public void generalize() {
        this.coeff = null;
        this.param = TemplateTerm.getNextFreshParameter();
        if (this.hasVariable()) {
            this.var.generalize();
        }
        if (this.hasUIF()) {
            this.uif.generalize();
        }
    }

    public static TemplateVariable getNextFreshParameter() {
        return new TemplateVariable(paramHead, nextParamIndex.incrementAndGet());
    }

    public static void resetParameterIndices() {
        nextParamIndex.set(0);
    }

    @Override
    public Set<String> getAllVariables(VariableWriteMode vwm) {
        HashSet<String> vars = new HashSet<String>();
        if (this.hasVariable()) {
            vars.add(this.var.toString(vwm));
        } else if (this.hasUIF()) {
            vars.addAll(this.uif.getAllVariables(vwm));
        }
        return vars;
    }

    @Override
    public Set<TemplateVariable> getAllParameters() {
        HashSet<TemplateVariable> params = new HashSet<TemplateVariable>();
        if (this.hasParameter()) {
            params.add(this.param);
        }
        if (this.hasUIF()) {
            params.addAll(this.uif.getAllParameters());
        }
        return params;
    }

    @Override
    public Set<TemplateVariable> getAllPurificationVariables() {
        HashSet<TemplateVariable> pvs = new HashSet<TemplateVariable>();
        if (this.uif != null && this.uif.isPurified()) {
            pvs.add(this.uif.getPurifiedName().getVariable());
        }
        return pvs;
    }

    @Override
    public HashMap<String, Integer> getMaxIndices(HashMap<String, Integer> map) {
        if (this.hasVariable()) {
            map = this.var.getMaxIndices(map);
        }
        if (this.hasUIF()) {
            TemplateUIF U = this.getUIF();
            map = U.getMaxIndices(map);
        }
        return map;
    }

    public int getMaxIndex() {
        HashMap<String, Integer> map = this.getMaxIndices(new HashMap<String, Integer>());
        int n = 0;
        for (Integer I : map.values()) {
            if (I <= n) continue;
            n = I;
        }
        return n;
    }

    @Override
    public TemplateVariableManager getVariableManager() {
        HashSet<TemplateVariable> var = new HashSet<TemplateVariable>();
        if (this.hasAnyVariable()) {
            var.add(this.getAnyVariable());
        }
        TemplateVariableManager tvm = new TemplateVariableManager(var);
        return tvm;
    }

    @Override
    public void prefixVariables(String prefix) {
        if (this.hasVariable()) {
            this.var.addPrefix(prefix);
        } else if (this.hasUIF()) {
            this.uif.prefixVariables(prefix);
        }
    }

    public Term makeRationalFunctionTerm(Map<String, Variable> paramVars) {
        Term t = new Term();
        Rational c = Rational.makeUnity();
        if (this.hasCoefficient()) {
            c = this.coeff.rationalValue();
        }
        t.setCoeff(c);
        if (this.hasParameter()) {
            Variable v;
            String s = this.param.toString(VariableWriteMode.REDLOG);
            if (!paramVars.containsKey(s)) {
                System.err.println("Creating parameter not in the TemplateNetwork's parameter map.");
                v = new Variable(s);
            } else {
                v = paramVars.get(s);
            }
            t.setMonomial(new Monomial(v));
        }
        return t;
    }

    @Override
    public Formula translate(FormulaManager fmgr) {
        Formula form = null;
        Vector<Formula> factors = new Vector<Formula>(4);
        if (this.hasCoefficient()) {
            factors.add(this.getCoefficient().translate(fmgr));
        }
        if (this.hasVariable()) {
            factors.add(this.getVariable().translate(fmgr));
        }
        if (this.hasUIF()) {
            factors.add(this.getUIF().translate(fmgr));
        }
        if (factors.size() == 0) {
            form = TemplateTerm.makeUnity().translate(fmgr);
        } else {
            form = (Formula)factors.get(0);
            for (int i = 1; i < factors.size(); ++i) {
                Formula f = (Formula)factors.get(i);
                form = fmgr.makeMultiply(form, f);
            }
        }
        return form;
    }

    @Override
    public TemplateTerm copy() {
        TemplateTerm t = new TemplateTerm();
        if (this.hasCoefficient()) {
            t.coeff = this.coeff.copy();
        }
        if (this.hasParameter()) {
            t.param = this.param.copy();
        }
        if (this.hasVariable()) {
            t.var = this.var.copy();
        }
        if (this.hasUIF()) {
            t.uif = this.uif.copy();
        }
        return t;
    }

    public boolean hasVariable() {
        return this.var != null;
    }

    public boolean hasAnyVariable() {
        return this.var != null || this.uif != null && this.uif.isPurified();
    }

    public boolean hasUIF() {
        return this.uif != null;
    }

    public boolean hasParameter() {
        return this.param != null;
    }

    public boolean hasCoefficient() {
        return this.coeff != null;
    }

    public boolean isConstant() {
        return !this.hasVariable() && !this.hasUIF() && (this.hasCoefficient() || this.hasParameter());
    }

    @Override
    public boolean isANumber() {
        return this.hasCoefficient() && !this.hasVariable() && !this.hasUIF() && !this.hasParameter();
    }

    public boolean isZero() {
        return this.hasCoefficient() && this.coeff.isZero();
    }

    public void setUIF(TemplateUIF u) {
        this.uif = u;
    }

    public void setVariable(TemplateVariable v) {
        this.var = v;
    }

    public void setParameter(TemplateVariable p) {
        this.param = p;
    }

    @Deprecated
    public void setUnknown(TemplateVariable u) {
        String s = u.toString();
        if (s.startsWith("v")) {
            this.var = u;
        } else if (s.startsWith(paramHead)) {
            this.param = u;
        }
    }

    public void setCoefficient(TemplateNumber c) {
        this.coeff = c;
    }

    public TemplateVariable getVariable() {
        return this.var;
    }

    public TemplateVariable getAnyVariable() {
        TemplateVariable V = null;
        if (this.var != null) {
            V = this.var;
        } else if (this.uif != null && this.uif.isPurified()) {
            V = this.uif.getPurifiedName().getVariable();
        }
        return V;
    }

    public Integer getVariableIndex() {
        return this.var.getIndex();
    }

    public TemplateUIF getUIF() {
        return this.uif;
    }

    public TemplateVariable getParameter() {
        return this.param;
    }

    public TemplateNumber getCoefficient() {
        return this.coeff;
    }

    public String getMonomialString(VariableWriteMode vwm) {
        String s = "";
        if (this.hasParameter()) {
            s = s + this.param.toString(vwm);
        }
        if (this.hasVariable()) {
            s = s + "*" + this.var.toString(vwm);
        }
        if (this.hasUIF()) {
            s = s + "*" + this.uif.toString(vwm);
        }
        if (s.length() > 0 && !this.hasParameter()) {
            s = s.substring(1);
        } else if (s.length() == 0) {
            s = "1";
        }
        return s;
    }

    public Coeff getCoeffWithParam(VariableWriteMode vwm) {
        String s = "";
        if (this.hasCoefficient()) {
            s = s + this.coeff.toString();
        }
        if (this.hasParameter()) {
            s = s + "*" + this.param.toString(vwm);
        }
        if (s.length() > 0 && !this.hasCoefficient()) {
            s = s.substring(1);
        } else if (s.length() == 0) {
            s = "1";
        }
        return new Coeff(s);
    }

    @Override
    public Integer getInteger() {
        Integer I = null;
        if (this.hasCoefficient()) {
            I = new Integer(this.coeff.toString());
        }
        return I;
    }

    @Override
    public Vector<TemplateTerm> getTerms() {
        Vector<TemplateTerm> V = new Vector<TemplateTerm>();
        V.add(this);
        return V;
    }

    @Override
    public int getNumTerms() {
        return 1;
    }

    @Override
    public TemplateTerm getTerm(int i) {
        return this;
    }

    public TemplateTerm divideBy(TemplateNumber n) {
        TemplateTerm t = this.copy();
        t.coeff = t.hasCoefficient() ? t.coeff.divideBy(n) : n.makeReciprocal();
        return t;
    }

    public static TemplateTerm multiply(TemplateTerm t1, TemplateTerm t2) {
        TemplateTerm T = new TemplateTerm();
        boolean hv1 = t1.hasVariable();
        boolean hu1 = t1.hasUIF();
        boolean hp1 = t1.hasParameter();
        boolean hc1 = t1.hasCoefficient();
        TemplateVariable v1 = t1.getVariable();
        TemplateUIF u1 = t1.getUIF();
        TemplateVariable p1 = t1.getParameter();
        TemplateNumber c1 = t1.getCoefficient();
        boolean hv2 = t2.hasVariable();
        boolean hu2 = t2.hasUIF();
        boolean hp2 = t2.hasParameter();
        boolean hc2 = t2.hasCoefficient();
        TemplateVariable v2 = t2.getVariable();
        TemplateUIF u2 = t2.getUIF();
        TemplateVariable p2 = t2.getParameter();
        TemplateNumber c2 = t2.getCoefficient();
        if (hv1 && hu2 || hu1 && hv2) {
            System.err.println("Multiplying term with var by term with UIF.");
        }
        if (hv1 && hv2) {
            T.setVariable(v1);
            System.err.println("Multiplying two variables.");
        }
        if (hv1 && !hv2) {
            T.setVariable(v1);
        }
        if (!hv1 && hv2) {
            T.setVariable(v2);
        }
        if (hu1 && hu2) {
            T.setUIF(u1);
            System.err.println("Multiplying two UIFs.");
        }
        if (hu1 && !hu2) {
            T.setUIF(u1);
        }
        if (!hu1 && hu2) {
            T.setUIF(u2);
        }
        if (hp1 && hp2) {
            T.setParameter(p1);
            System.err.println("Multiplying two parameters.");
        }
        if (hp1 && !hp2) {
            T.setParameter(p1);
        }
        if (!hp1 && hp2) {
            T.setParameter(p2);
        }
        if (hc1 && !hc2) {
            T.setCoefficient(c1);
        }
        if (!hc1 && hc2) {
            T.setCoefficient(c2);
        }
        if (hc1 && hc2) {
            TemplateNumber N = TemplateNumber.multiply(c1, c2);
            T.setCoefficient(N);
        }
        return T;
    }

    @Override
    public void negate() {
        if (this.coeff != null) {
            this.coeff.negate();
        } else {
            this.coeff = new TemplateNumber(-1);
        }
    }

    @Override
    void writeAsForm(boolean b) {
        this.writingAsForm = b;
        if (this.hasVariable()) {
            this.var.writeAsForm(b);
        }
        if (this.hasUIF()) {
            this.uif.writeAsForm(b);
        }
    }

    @Override
    public String toString() {
        return this.toString(VariableWriteMode.PLAIN);
    }

    @Override
    public String toString(VariableWriteMode vwm) {
        String s = "";
        if (this.hasCoefficient() && !this.writingAsForm) {
            s = s + this.coeff.toString();
        }
        if (this.hasParameter() && !this.writingAsForm) {
            s = s + "*" + this.param.toString(vwm);
        }
        if (this.hasVariable()) {
            s = s + "*" + this.var.toString(vwm);
        }
        if (this.hasUIF()) {
            s = s + "*" + this.uif.toString(vwm);
        }
        if (s.length() > 0 && (!this.hasCoefficient() || this.writingAsForm)) {
            s = s.substring(1);
        } else if (s.startsWith("1*")) {
            s = s.substring(2);
        } else if (s.startsWith("-1*")) {
            s = "-" + s.substring(3);
        }
        return s;
    }
}

