/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSumList;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateUIF
extends TemplateFormula {
    private String name = null;
    private TemplateSumList args = null;
    private Integer index = null;
    private TemplateTerm purifiedName = null;
    private TemplateTerm oldPurifiedName = null;

    public TemplateUIF(String pName, TemplateSumList pArgs) {
        this.name = pName;
        this.args = pArgs;
    }

    public TemplateUIF(String pName, TemplateSumList pArgs, int pIdx) {
        this.name = pName;
        this.args = pArgs;
        this.index = new Integer(pIdx);
    }

    @Override
    public TemplateUIF copy() {
        TemplateUIF u = new TemplateUIF(new String(this.name), this.args.copy());
        if (this.index != null) {
            u.index = new Integer(this.index);
        }
        if (this.oldPurifiedName != null) {
            u.oldPurifiedName = this.oldPurifiedName.copy();
        }
        if (this.purifiedName != null) {
            u.purifiedName = this.purifiedName.copy();
        }
        return u;
    }

    @Override
    public void alias(AliasingMap amap) {
        if (this.args != null) {
            this.args.alias(amap);
        }
    }

    @Override
    public void unalias() {
        if (this.args != null) {
            this.args.unalias();
        }
    }

    @Override
    public boolean evaluate(Map<String, Rational> map) {
        boolean ans = true;
        if (this.args != null) {
            ans &= this.args.evaluate(map);
        }
        return ans;
    }

    @Override
    public void unevaluate() {
        if (this.args != null) {
            this.args.unevaluate();
        }
    }

    @Override
    public void postindex(Map<String, Integer> indices) {
        if (this.args != null) {
            this.args.postindex(indices);
        }
    }

    @Override
    public void preindex(Map<String, Integer> indices) {
        if (this.args != null) {
            this.args.preindex(indices);
        }
    }

    @Override
    public void unindex() {
        if (this.args != null) {
            this.args.unindex();
        }
    }

    @Override
    public Purification purify(Purification pur) {
        if (this.args != null) {
            pur = this.args.purify(pur);
        }
        pur.purify(this);
        return pur;
    }

    @Override
    public void unpurify() {
        if (this.args != null) {
            this.args.unpurify();
        }
        this.oldPurifiedName = this.purifiedName;
        this.purifiedName = null;
    }

    public void repurify() {
        this.purifiedName = this.oldPurifiedName;
    }

    public void generalize() {
        if (this.args != null) {
            this.args.generalize();
        }
    }

    @Override
    public Set<String> getAllVariables(VariableWriteMode vwm) {
        HashSet<String> vars = new HashSet<String>();
        if (this.args != null) {
            vars.addAll(this.args.getAllVariables(vwm));
        }
        return vars;
    }

    @Override
    public Set<TemplateVariable> getAllParameters() {
        HashSet<TemplateVariable> params = new HashSet<TemplateVariable>();
        if (this.args != null) {
            params.addAll(this.args.getAllParameters());
        }
        return params;
    }

    @Override
    public HashMap<String, Integer> getMaxIndices(HashMap<String, Integer> map) {
        if (this.args != null) {
            map = this.args.getMaxIndices(map);
        }
        return map;
    }

    @Override
    public TemplateVariableManager getVariableManager() {
        TemplateVariableManager tvm = new TemplateVariableManager();
        if (this.args != null) {
            tvm = this.args.getVariableManager();
        }
        return tvm;
    }

    public void prefixVariables(String prefix) {
        if (this.args != null) {
            this.args.prefixVariables(prefix);
        }
    }

    @Override
    public Formula translate(FormulaManager fmgr) {
        Formula form = null;
        FormulaList fl = this.args.translate(fmgr);
        form = this.hasIndex() ? fmgr.makeUIF(this.name, fl, this.index) : fmgr.makeUIF(this.name, fl);
        return form;
    }

    public boolean isPurified() {
        return this.purifiedName != null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasIndex() {
        return this.index != null;
    }

    public Integer getIndex() {
        return this.index;
    }

    void setPurifiedName(TemplateTerm A) {
        this.unpurify();
        this.purifiedName = A;
    }

    public TemplateTerm getPurifiedName() {
        return this.purifiedName;
    }

    public TemplateSumList getArgs() {
        return this.args;
    }

    public int getArity() {
        return this.args.size();
    }

    void writeAsForm(boolean b) {
        if (this.args != null) {
            this.args.writeAsForm(b);
        }
    }

    @Override
    public String toString() {
        return this.toString(VariableWriteMode.PLAIN);
    }

    @Override
    public String toString(VariableWriteMode vwm) {
        String s = null;
        if (this.isPurified()) {
            s = this.purifiedName.toString(vwm);
        } else {
            s = this.name + "(";
            if (this.args != null) {
                s = s + this.args.toString(",");
            }
            s = s + ")";
        }
        return s;
    }
}

