/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.util.invariants.interfaces.GeneralVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateVariable
extends TemplateFormula
implements GeneralVariable {
    private String name = null;
    private Integer index = null;
    private String realName = null;
    private Integer realIndex = null;
    private boolean writingAsForm = false;

    public TemplateVariable(String name, int i) {
        this.index = new Integer(i);
        this.build(name, this.index);
    }

    public TemplateVariable(String name) {
        this.build(name, null);
    }

    public TemplateVariable(String name, Integer index) {
        this.build(name, index);
    }

    private void build(String name, Integer index) {
        this.name = name;
        this.index = index;
    }

    public static TemplateVariable parse(String vn) {
        TemplateVariable V;
        int i = vn.lastIndexOf("@");
        if (i < 0) {
            V = new TemplateVariable(vn);
        } else {
            String s = vn.substring(0, i);
            String ind = vn.substring(i + 1);
            Integer I = new Integer(ind);
            int j = I;
            V = new TemplateVariable(s, j);
        }
        return V;
    }

    @Override
    public void alias(AliasingMap amap) {
        amap.alias(this);
    }

    @Override
    public void unalias() {
        this.name = this.realName;
        this.index = this.realIndex;
    }

    void setAlias(String n, Integer i) {
        this.realName = this.name;
        this.realIndex = this.index;
        this.name = n;
        this.index = i;
    }

    @Override
    public void postindex(Map<String, Integer> indices) {
        this.index = this.name != null && indices.containsKey(this.name) ? indices.get(this.name) : null;
    }

    @Override
    public void preindex(Map<String, Integer> indices) {
        this.index = this.name != null && indices.containsKey(this.name) ? new Integer(1) : null;
    }

    @Override
    public void unindex() {
        this.index = null;
    }

    public void addPrefix(String prefix) {
        this.name = prefix + this.name;
    }

    @Override
    public HashMap<String, Integer> getMaxIndices(HashMap<String, Integer> map) {
        if (this.name != null && this.index != null) {
            if (map.containsKey(this.name)) {
                Integer J = map.get(this.name);
                if (this.index.compareTo(J) > 0) {
                    map.put(this.name, this.index);
                }
            } else {
                map.put(this.name, this.index);
            }
        }
        return map;
    }

    public boolean equals(TemplateVariable v) {
        return this.toString().equals(v.toString());
    }

    public String getName() {
        return this.name;
    }

    public Integer getIndex() {
        return this.index;
    }

    public boolean hasIndex() {
        return this.index != null;
    }

    @Override
    public Formula translate(FormulaManager fmgr) {
        Formula form = null;
        form = this.hasIndex() ? fmgr.makeVariable(this.name, this.index) : fmgr.makeVariable(this.name);
        return form;
    }

    @Override
    public TemplateVariable copy() {
        TemplateVariable v = null;
        v = this.index == null ? new TemplateVariable(new String(this.name)) : new TemplateVariable(new String(this.name), new Integer(this.index));
        return v;
    }

    public void generalize() {
        this.index = null;
    }

    void writeAsForm(boolean b) {
        this.writingAsForm = b;
    }

    @Override
    public String toString() {
        return this.toString(VariableWriteMode.PLAIN);
    }

    @Override
    public String toString(VariableWriteMode vwm) {
        String s = "";
        switch (vwm) {
            case REDLOG: {
                s = this.name;
                if (this.index == null || this.writingAsForm) break;
                s = s + this.index.toString();
                break;
            }
            default: {
                s = this.name;
                if (this.index == null || this.writingAsForm) break;
                s = s + "@" + this.index.toString();
            }
        }
        return s;
    }
}

