/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.interfaces.GeneralVariable;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;

public class TemplateVariableManager
implements VariableManager {
    private List<TemplateVariable> vars;

    public TemplateVariableManager() {
        this.vars = new Vector<TemplateVariable>();
    }

    public TemplateVariableManager(Collection<TemplateVariable> vars) {
        this.vars = new Vector<TemplateVariable>(vars);
    }

    public TemplateVariableManager(int n, int m) {
        this.vars = new Vector<TemplateVariable>();
        for (int i = 1; i <= n; ++i) {
            this.vars.add(new TemplateVariable("v", i));
        }
        for (int j = 1; j <= m; ++j) {
            this.vars.add(new TemplateVariable("u", j));
        }
    }

    public void merge(TemplateVariableManager tvm) {
        this.vars.addAll(tvm.getVars());
    }

    public List<TemplateVariable> getVars() {
        return this.vars;
    }

    @Override
    public Iterator<GeneralVariable> iterator() {
        Vector<GeneralVariable> gvars = new Vector<GeneralVariable>();
        for (int i = 0; i < this.vars.size(); ++i) {
            GeneralVariable GV = this.vars.get(i);
            gvars.add(GV);
        }
        return gvars.iterator();
    }

    @Override
    public int find(GeneralVariable v) {
        return this.vars.indexOf(v);
    }

    @Override
    public int getNumVars() {
        return this.vars.size();
    }

    public String toString() {
        String s = "Variables:";
        for (TemplateVariable V : this.vars) {
            s = s + " " + V.toString();
        }
        return s;
    }
}

