/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.octagon;

import org.sosy_lab.cpachecker.util.octagon.NumArray;
import org.sosy_lab.cpachecker.util.octagon.OctWrapper;
import org.sosy_lab.cpachecker.util.octagon.Octagon;

public class OctagonManager {
    public static boolean init() {
        return OctWrapper.J_init();
    }

    public static NumArray init_num_t(int n) {
        long l = OctWrapper.J_init_n(n);
        return new NumArray(l);
    }

    public static void num_set(NumArray n1, NumArray n2) {
        OctWrapper.J_num_set(n1.getArray(), n2.getArray());
    }

    public static void num_set_int(NumArray n, int pos, int i) {
        OctWrapper.J_num_set_int(n.getArray(), pos, i);
    }

    public static void num_set_float(NumArray n, int pos, double d) {
        OctWrapper.J_num_set_float(n.getArray(), pos, d);
    }

    public static void num_set_inf(NumArray n, int pos) {
        OctWrapper.J_num_set_inf(n.getArray(), pos);
    }

    public static long num_get_int(NumArray n, int pos) {
        return OctWrapper.J_num_get_int(n.getArray(), pos);
    }

    public static double num_get_float(NumArray n, int pos) {
        return OctWrapper.J_num_get_float(n.getArray(), pos);
    }

    public static boolean num_infty(NumArray n, int pos) {
        return OctWrapper.J_num_infty(n.getArray(), pos);
    }

    public static void num_clear_n(NumArray n, int size) {
        OctWrapper.J_num_clear_n(n.getArray(), size);
    }

    public static Octagon empty(int n) {
        long l = OctWrapper.J_empty(n);
        return new Octagon(l);
    }

    public static Octagon universe(int n) {
        long l = OctWrapper.J_universe(n);
        return new Octagon(l);
    }

    public static void free(Octagon oct) {
        OctWrapper.J_free(oct.getOctId());
    }

    public static Octagon copy(Octagon oct) {
        long l = OctWrapper.J_copy(oct.getOctId());
        return new Octagon(l);
    }

    public static Octagon full_copy(Octagon oct) {
        long l = OctWrapper.J_full_copy(oct.getOctId());
        return new Octagon(l);
    }

    public static int dimension(Octagon oct) {
        return OctWrapper.J_dimension(oct.getOctId());
    }

    public static int nbconstraints(Octagon oct) {
        return OctWrapper.J_nbconstraints(oct.getOctId());
    }

    public static boolean isEmpty(Octagon oct) {
        return OctWrapper.J_isEmpty(oct.getOctId());
    }

    public static int isEmptyLazy(Octagon oct) {
        return OctWrapper.J_isEmptyLazy(oct.getOctId());
    }

    public static boolean isUniverse(Octagon oct) {
        return OctWrapper.J_isUniverse(oct.getOctId());
    }

    public static boolean isIncludedIn(Octagon oct1, Octagon oct2) {
        return OctWrapper.J_isIncludedIn(oct1.getOctId(), oct2.getOctId());
    }

    public static int isIncludedInLazy(Octagon oct1, Octagon oct2) {
        return OctWrapper.J_isIncludedInLazy(oct1.getOctId(), oct2.getOctId());
    }

    public static boolean isEqual(Octagon oct1, Octagon oct2) {
        return OctWrapper.J_isEqual(oct1.getOctId(), oct2.getOctId());
    }

    public static int isEqualLazy(Octagon oct1, Octagon oct2) {
        return OctWrapper.J_isEqualLazy(oct1.getOctId(), oct2.getOctId());
    }

    public static boolean isIn(Octagon oct1, NumArray array) {
        return OctWrapper.J_isIn(oct1.getOctId(), array.getArray());
    }

    public static Octagon intersection(Octagon oct1, Octagon oct2) {
        long l = OctWrapper.J_intersection(oct1.getOctId(), oct2.getOctId(), false);
        return new Octagon(l);
    }

    public static Octagon union(Octagon oct1, Octagon oct2) {
        long l = OctWrapper.J_union(oct1.getOctId(), oct2.getOctId(), false);
        return new Octagon(l);
    }

    public Octagon widening(Octagon oct1, Octagon oct2) {
        long l = OctWrapper.J_widening(oct1.getOctId(), oct2.getOctId(), false, 1);
        return new Octagon(l);
    }

    public static Octagon narrowing(Octagon oct1, Octagon oct2) {
        long l = OctWrapper.J_narrowing(oct1.getOctId(), oct2.getOctId(), false);
        return new Octagon(l);
    }

    public static Octagon forget(Octagon oct, int k) {
        long l = OctWrapper.J_forget(oct.getOctId(), k, false);
        return new Octagon(l);
    }

    public static Octagon assingVar(Octagon oct, int k, NumArray array) {
        long l = OctWrapper.J_assingVar(oct.getOctId(), k, array.getArray(), false);
        return new Octagon(l);
    }

    public static Octagon addBinConstraint(Octagon oct, int noOfConstraints, NumArray array) {
        long l = OctWrapper.J_addBinConstraints(oct.getOctId(), noOfConstraints, array.getArray(), false);
        return new Octagon(l);
    }

    public static Octagon substituteVar(Octagon oct, int x, NumArray array) {
        long l = OctWrapper.J_substituteVar(oct.getOctId(), x, array.getArray(), false);
        return new Octagon(l);
    }

    public static Octagon addConstraint(Octagon oct, NumArray array) {
        long l = OctWrapper.J_addConstraint(oct.getOctId(), array.getArray(), false);
        return new Octagon(l);
    }

    public static Octagon intervAssingVar(Octagon oct, int k, NumArray array) {
        long l = OctWrapper.J_intervAssingVar(oct.getOctId(), k, array.getArray(), false);
        return new Octagon(l);
    }

    public static Octagon intervSubstituteVar(Octagon oct, int x, NumArray array) {
        long l = OctWrapper.J_intervSubstituteVar(oct.getOctId(), x, array.getArray(), false);
        return new Octagon(l);
    }

    public static Octagon intervAddConstraint(Octagon oct, NumArray array) {
        long l = OctWrapper.J_intervAddConstraint(oct.getOctId(), array.getArray(), false);
        return new Octagon(l);
    }

    public static Octagon addDimensionAndEmbed(Octagon oct, int k) {
        long l = OctWrapper.J_addDimenensionAndEmbed(oct.getOctId(), k, false);
        return new Octagon(l);
    }

    public static Octagon addDimensionAndProject(Octagon oct, int k) {
        long l = OctWrapper.J_addDimenensionAndProject(oct.getOctId(), k, false);
        return new Octagon(l);
    }

    public static Octagon removeDimension(Octagon oct, int k) {
        long l = OctWrapper.J_removeDimension(oct.getOctId(), k, false);
        return new Octagon(l);
    }

    public static void print(Octagon oct) {
        OctWrapper.J_print(oct.getOctId());
    }
}

