/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Joiner;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

@Options(prefix="cpa.predicate")
public final class AbstractionManager {
    private volatile int numberOfPredicates = 0;
    private final LogManager logger;
    private final RegionManager rmgr;
    private final FormulaManager fmgr;
    private final Map<Region, AbstractionPredicate> absVarToPredicate;
    private final Map<Formula, AbstractionPredicate> symbVarToPredicate;
    @Option(name="abs.useCache", description="use caching of region to formula conversions")
    private boolean useCache = true;
    private final Map<Region, Formula> toConcreteCache;

    public AbstractionManager(RegionManager pRmgr, FormulaManager pFmgr, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this, AbstractionManager.class);
        this.logger = pLogger;
        this.rmgr = pRmgr;
        this.fmgr = pFmgr;
        this.absVarToPredicate = new HashMap<Region, AbstractionPredicate>();
        this.symbVarToPredicate = new HashMap<Formula, AbstractionPredicate>();
        this.toConcreteCache = this.useCache ? new HashMap<Region, Formula>() : null;
        new AbstractionPredicatesMBean();
    }

    public AbstractionPredicate makePredicate(Formula atom) {
        Formula var = this.fmgr.createPredicateVariable(atom);
        AbstractionPredicate result = this.symbVarToPredicate.get(var);
        if (result == null) {
            Region absVar = this.rmgr.createPredicate();
            this.logger.log(Level.FINEST, new Object[]{"Created predicate", absVar, "from variable", var, "and atom", atom});
            ++this.numberOfPredicates;
            result = new AbstractionPredicate(absVar, var, atom);
            this.symbVarToPredicate.put(var, result);
            this.absVarToPredicate.put(absVar, result);
        }
        return result;
    }

    public AbstractionPredicate makeFalsePredicate() {
        return this.makePredicate(this.fmgr.makeFalse());
    }

    private AbstractionPredicate getPredicate(Formula var) {
        AbstractionPredicate result = this.symbVarToPredicate.get(var);
        if (result == null) {
            throw new IllegalArgumentException(var + " seems not to be a formula corresponding to a single predicate variable.");
        }
        return result;
    }

    public Formula toConcrete(Region af) {
        Map<Region, Formula> cache = this.useCache ? this.toConcreteCache : new HashMap<Region, Formula>();
        ArrayDeque<Region> toProcess = new ArrayDeque<Region>();
        cache.put(this.rmgr.makeTrue(), this.fmgr.makeTrue());
        cache.put(this.rmgr.makeFalse(), this.fmgr.makeFalse());
        toProcess.push(af);
        while (!toProcess.isEmpty()) {
            Region n = (Region)toProcess.peek();
            if (cache.containsKey(n)) {
                toProcess.pop();
                continue;
            }
            boolean childrenDone = true;
            Formula m1 = null;
            Formula m2 = null;
            Triple<Region, Region, Region> parts = this.rmgr.getIfThenElse(n);
            Region c1 = (Region)parts.getSecond();
            Region c2 = (Region)parts.getThird();
            if (!cache.containsKey(c1)) {
                toProcess.push(c1);
                childrenDone = false;
            } else {
                m1 = cache.get(c1);
            }
            if (!cache.containsKey(c2)) {
                toProcess.push(c2);
                childrenDone = false;
            } else {
                m2 = cache.get(c2);
            }
            if (!childrenDone) continue;
            assert (m1 != null);
            assert (m2 != null);
            toProcess.pop();
            Region var = (Region)parts.getFirst();
            AbstractionPredicate pred = this.absVarToPredicate.get(var);
            assert (pred != null);
            Formula atom = pred.getSymbolicAtom();
            Formula ite = this.fmgr.makeIfThenElse(atom, m1, m2);
            cache.put(n, ite);
        }
        Formula result = cache.get(af);
        assert (result != null);
        return result;
    }

    public boolean entails(Region f1, Region f2) {
        return this.rmgr.entails(f1, f2);
    }

    public Collection<AbstractionPredicate> extractPredicates(Region af) {
        HashSet<AbstractionPredicate> vars = new HashSet<AbstractionPredicate>();
        ArrayDeque<Region> toProcess = new ArrayDeque<Region>();
        toProcess.push(af);
        while (!toProcess.isEmpty()) {
            Region n = (Region)toProcess.pop();
            if (n.isTrue() || n.isFalse()) {
                vars.add(this.makeFalsePredicate());
                continue;
            }
            AbstractionPredicate pred = this.absVarToPredicate.get(n);
            if (pred == null) {
                Region c2;
                Triple<Region, Region, Region> parts = this.rmgr.getIfThenElse(n);
                Region var = (Region)parts.getFirst();
                pred = this.absVarToPredicate.get(var);
                assert (pred != null);
                Region c1 = (Region)parts.getSecond();
                if (c1 != null) {
                    toProcess.push(c1);
                }
                if ((c2 = (Region)parts.getThird()) != null) {
                    toProcess.push(c2);
                }
            }
            vars.add(pred);
        }
        return vars;
    }

    public RegionCreator getRegionCreator() {
        return new RegionCreator();
    }

    public class RegionCreator {
        public Region makeTrue() {
            return AbstractionManager.this.rmgr.makeTrue();
        }

        public Region makeFalse() {
            return AbstractionManager.this.rmgr.makeFalse();
        }

        public Region makeNot(Region f) {
            return AbstractionManager.this.rmgr.makeNot(f);
        }

        public Region makeAnd(Region f1, Region f2) {
            return AbstractionManager.this.rmgr.makeAnd(f1, f2);
        }

        public Region makeOr(Region f1, Region f2) {
            return AbstractionManager.this.rmgr.makeOr(f1, f2);
        }

        public Region makeExists(Region f1, Region f2) {
            return AbstractionManager.this.rmgr.makeExists(f1, f2);
        }

        public Region getPredicate(Formula var) {
            return AbstractionManager.this.getPredicate(var).getAbstractVariable();
        }
    }

    private class AbstractionPredicatesMBean
    extends AbstractMBean
    implements AbstractionPredicatesMXBean {
        public AbstractionPredicatesMBean() {
            super("org.sosy_lab.cpachecker:type=predicate,name=AbstractionPredicates", AbstractionManager.this.logger);
            this.register();
        }

        @Override
        public int getNumberOfPredicates() {
            return AbstractionManager.this.numberOfPredicates;
        }

        @Override
        public String getPredicates() {
            return Joiner.on((char)'\n').join(AbstractionManager.this.absVarToPredicate.values());
        }
    }

    public static interface AbstractionPredicatesMXBean {
        public int getNumberOfPredicates();

        public String getPredicates();
    }
}

