/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingTheoremProver;

public class CSIsatInterpolatingProver
implements InterpolatingTheoremProver<Integer> {
    private static final Joiner FORMULAS_JOINER = Joiner.on((String)"; ");
    private static final String[] CSISAT_CMDLINE = new String[]{"csisat", "-syntax", "infix", "-round", "-LAsolver", "simplex"};
    private final FormulaManager smgr;
    private final LogManager logger;
    private final List<Formula> formulas = new ArrayList<Formula>();
    private final List<Formula> interpolants = new ArrayList<Formula>();

    public CSIsatInterpolatingProver(FormulaManager pSmgr, LogManager pLogger) {
        Preconditions.checkNotNull((Object)pSmgr);
        Preconditions.checkNotNull((Object)pLogger);
        this.smgr = pSmgr;
        this.logger = pLogger;
    }

    @Override
    public void init() {
        Preconditions.checkState((boolean)this.formulas.isEmpty());
        Preconditions.checkState((boolean)this.interpolants.isEmpty());
    }

    @Override
    public Integer addFormula(Formula pF) {
        Preconditions.checkNotNull((Object)pF);
        Preconditions.checkState((boolean)this.interpolants.isEmpty(), (Object)"Cannot add formulas after calling unsat, call reset!");
        this.formulas.add(pF);
        return this.formulas.size() - 1;
    }

    @Override
    public Formula getInterpolant(List<Integer> pFormulasOfA) {
        Preconditions.checkState((!this.interpolants.isEmpty() ? 1 : 0) != 0, (Object)"isUnsat needs to be called first!");
        int i = 0;
        for (Integer aIdx : pFormulasOfA) {
            Preconditions.checkArgument((boolean)aIdx.equals(i++), (Object)"CSIsatInterpolatingProver only accepts a contigous range at the beginning of the formulas for A");
        }
        Preconditions.checkElementIndex((int)(--i), (int)this.interpolants.size(), (String)"Invalid index for interpolant");
        return this.interpolants.get(i);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        CSIsatExecutor csisat;
        Preconditions.checkState((boolean)this.interpolants.isEmpty(), (Object)"Cannot call isUnsat after it returned true once!");
        try {
            csisat = new CSIsatExecutor();
            csisat.writeFormulas(this.formulas);
            csisat.join();
        }
        catch (IOException e) {
            this.logger.logException(Level.SEVERE, (Throwable)e, "Error during invocation of CSIsat interpolating theorem prover!");
            throw new UnsupportedOperationException(e);
        }
        if (csisat.satisfiable) {
            this.logger.log(Level.FINEST, new Object[]{"CSIsat result: satisfiable"});
            assert (this.interpolants.isEmpty());
            return false;
        }
        if (this.interpolants.size() != this.formulas.size() - 1) {
            this.logger.log(Level.SEVERE, new Object[]{"CSIsat failed to generate interpolants"});
            throw new UnsupportedOperationException();
        }
        this.logger.log(Level.FINEST, new Object[]{"CSIsat result: unsatisfiable,", this.interpolants.size(), " interpolants found."});
        return true;
    }

    @Override
    public void reset() {
        this.formulas.clear();
        this.interpolants.clear();
    }

    @Override
    public Model getModel() {
        return new Model(this.smgr);
    }

    private class CSIsatExecutor
    extends ProcessExecutor<IOException> {
        private boolean satisfiable;

        public CSIsatExecutor() throws IOException {
            super(CSIsatInterpolatingProver.this.logger, IOException.class, CSISAT_CMDLINE);
            this.satisfiable = false;
        }

        public void handleErrorOutput(String line) throws IOException {
            if (line.startsWith("Satisfiable: ")) {
                this.satisfiable = true;
            } else {
                super.handleErrorOutput(line);
            }
        }

        public void handleOutput(String line) throws IOException {
            Formula itp = CSIsatInterpolatingProver.this.smgr.parseInfix(line);
            CSIsatInterpolatingProver.this.interpolants.add(itp);
            this.logger.log(Level.ALL, new Object[]{"Parsed interpolant", line, "as", itp});
        }

        public void writeFormulas(List<Formula> formulas) throws IOException {
            String formulasStr = FORMULAS_JOINER.join(formulas);
            this.logger.log(Level.ALL, new Object[]{"Interpolation problem is", formulasStr});
            this.print(formulasStr);
            this.sendEOF();
        }
    }
}

