/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;

public class CachingPathFormulaManager
implements PathFormulaManager {
    public final Timer pathFormulaComputationTimer = new Timer();
    public int pathFormulaCacheHits = 0;
    private final PathFormulaManager delegate;
    private final Map<Pair<PathFormula, CFAEdge>, PathFormula> pathFormulaCache = new HashMap<Pair<PathFormula, CFAEdge>, PathFormula>();
    private final Map<Pair<PathFormula, PathFormula>, PathFormula> mergeCache = new HashMap<Pair<PathFormula, PathFormula>, PathFormula>();
    private final Map<PathFormula, PathFormula> emptyFormulaCache = new HashMap<PathFormula, PathFormula>();
    private final PathFormula emptyFormula;

    public CachingPathFormulaManager(PathFormulaManager pDelegate) {
        this.delegate = pDelegate;
        this.emptyFormula = this.delegate.makeEmptyPathFormula();
    }

    @Override
    public PathFormula makeAnd(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException {
        Pair formulaCacheKey = Pair.of((Object)pOldFormula, (Object)pEdge);
        PathFormula result = this.pathFormulaCache.get(formulaCacheKey);
        if (result == null) {
            this.pathFormulaComputationTimer.start();
            result = this.delegate.makeAnd(pOldFormula, pEdge);
            this.pathFormulaComputationTimer.stop();
            this.pathFormulaCache.put((Pair<PathFormula, CFAEdge>)formulaCacheKey, result);
        } else {
            ++this.pathFormulaCacheHits;
        }
        return result;
    }

    @Override
    public PathFormula makeOr(PathFormula pF1, PathFormula pF2) {
        Pair formulaCacheKey = Pair.of((Object)pF1, (Object)pF2);
        PathFormula result = this.mergeCache.get(formulaCacheKey);
        if (result == null) {
            result = this.mergeCache.get(Pair.of((Object)pF2, (Object)pF1));
        }
        if (result == null) {
            result = this.delegate.makeOr(pF1, pF2);
            this.mergeCache.put((Pair<PathFormula, PathFormula>)formulaCacheKey, result);
        } else {
            ++this.pathFormulaCacheHits;
        }
        return result;
    }

    @Override
    public PathFormula makeEmptyPathFormula() {
        return this.emptyFormula;
    }

    @Override
    public PathFormula makeEmptyPathFormula(PathFormula pOldFormula) {
        PathFormula result = this.emptyFormulaCache.get(pOldFormula);
        if (result == null) {
            result = this.delegate.makeEmptyPathFormula(pOldFormula);
            this.emptyFormulaCache.put(pOldFormula, result);
        } else {
            ++this.pathFormulaCacheHits;
        }
        return result;
    }

    @Override
    public PathFormula makeAnd(PathFormula pPathFormula, Formula pOtherFormula) {
        return this.delegate.makeAnd(pPathFormula, pOtherFormula);
    }

    @Override
    public PathFormula makeNewPathFormula(PathFormula pOldFormula, SSAMap pM) {
        return this.delegate.makeNewPathFormula(pOldFormula, pM);
    }

    @Override
    public PathFormula makeFormulaForPath(List<CFAEdge> pPath) throws CPATransferException {
        return this.delegate.makeFormulaForPath(pPath);
    }

    @Override
    public Formula buildBranchingFormula(Iterable<ARTElement> pElementsOnPath) throws CPATransferException {
        return this.delegate.buildBranchingFormula(pElementsOnPath);
    }

    @Override
    public Map<Integer, Boolean> getBranchingPredicateValuesFromModel(Model pModel) {
        return this.delegate.getBranchingPredicateValuesFromModel(pModel);
    }
}

