/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.DefaultExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.Defaults;
import org.sosy_lab.cpachecker.cfa.ast.ForwardingExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTEnumerationSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IComplexType;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.ITypedef;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.StatementVisitor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.MachineModel;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;

@Options(prefix="cpa.predicate")
public class CtoFormulaConverter {
    @Option(description="add special information to formulas about non-deterministic functions")
    protected boolean useNondetFlags = false;
    @Option(description="initialize all variables to 0 when they are declared")
    private boolean initAllVars = false;
    @Option(name="mathsat.lvalsAsUIFs", description="use uninterpreted functions for *, & and array access")
    private boolean lvalsAsUif = false;
    @Option(description="list of functions that should be considered as giving a non-deterministic return value\n Only predicate analysis honors this option. If you specify this option, the default values are not added automatically to the list, so you need to specify them explicitly if you need them. Mentioning a function in this list has only an effect, if it is an 'external function', i.e., no source is given in the code for this function.")
    private Set<String> nondetFunctions = ImmutableSet.of((Object)"malloc", (Object)"__kmalloc", (Object)"kzalloc", (Object)"sscanf", (Object)"int_nondet", (Object)"nondet_int", (Object[])new String[]{"random", "__VERIFIER_nondet_int", "__VERIFIER_nondet_pointer", "__VERIFIER_nondet_short", "__VERIFIER_nondet_char", "__VERIFIER_nondet_float"});
    @Option(description="the machine model used for functions sizeof and alignof")
    private MachineModel machineModel = MachineModel.LINUX32;
    @Option(description="handle Pointers")
    private boolean handlePointerAliasing = true;
    @Option(description="list of functions that provide new memory on the heap. This is only used, when handling of pointers is enabled.")
    private Set<String> memoryAllocationFunctions = ImmutableSet.of((Object)"malloc", (Object)"__kmalloc", (Object)"kzalloc");
    private static final Set<String> PURE_EXTERNAL_FUNCTIONS = ImmutableSet.of((Object)"__assert_fail", (Object)"free", (Object)"kfree", (Object)"fprintf", (Object)"printf", (Object)"puts", (Object[])new String[]{"printk", "sprintf", "swprintf", "strcasecmp", "strchr", "strcmp", "strlen", "strncmp", "strrchr", "strstr"});
    private static final Map<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of((Object)"pthread_create", (Object)"threads");
    private static final String VAR_RETURN_NAME = "__retval__";
    private static final String OP_ADDRESSOF_NAME = "__ptrAmp__";
    private static final String OP_STAR_NAME = "__ptrStar__";
    private static final String OP_ARRAY_SUBSCRIPT = "__array__";
    public static final String NONDET_VARIABLE = "__nondet__";
    public static final String NONDET_FLAG_VARIABLE = "__nondet__flag__";
    private static final String POINTER_VARIABLE = "__content_of__";
    private static final Pattern POINTER_VARIABLE_PATTERN = Pattern.compile("\\Q__content_of__\\E.*\\Q__end\\E");
    private static final String MEMORY_ADDRESS_VARIABLE_PREFIX = "__address_of__";
    private static final String MALLOC_VARIABLE_PREFIX = "__address_of__#";
    private static final String MALLOC_COUNTER_VARIABLE_NAME = "#malloc";
    private final Set<String> printedWarnings = new HashSet<String>();
    private final Map<String, Formula> stringLitToFormula = new HashMap<String, Formula>();
    private int nextStringLitIndex = 0;
    protected final ExtendedFormulaManager fmgr;
    protected final LogManager logger;
    private static final int VARIABLE_UNSET = -1;
    private static final int VARIABLE_UNINITIALIZED = 2;

    public CtoFormulaConverter(Configuration config, ExtendedFormulaManager fmgr, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this, CtoFormulaConverter.class);
        this.fmgr = fmgr;
        this.logger = logger;
    }

    private void warnUnsafeVar(IASTExpression exp) {
        this.logDebug("Unhandled expression treated as free variable", exp);
    }

    private void warnUnsafeAssignment() {
        this.log(Level.WARNING, "Program contains array, pointer, or field access; analysis is imprecise in case of aliasing.");
    }

    private String getLogMessage(String msg, IASTNode astNode) {
        return "Line " + astNode.getFileLocation().getStartingLineNumber() + ": " + msg + ": " + astNode.toASTString();
    }

    private String getLogMessage(String msg, CFAEdge edge) {
        return "Line " + edge.getLineNumber() + ": " + msg + ": " + edge.getDescription();
    }

    private void logDebug(String msg, IASTNode astNode) {
        if (this.logger.wouldBeLogged(Level.ALL)) {
            this.logger.log(Level.ALL, new Object[]{this.getLogMessage(msg, astNode)});
        }
    }

    private void logDebug(String msg, CFAEdge edge) {
        if (this.logger.wouldBeLogged(Level.ALL)) {
            this.logger.log(Level.ALL, new Object[]{this.getLogMessage(msg, edge)});
        }
    }

    private void log(Level level, String msg) {
        if (this.logger.wouldBeLogged(level) && this.printedWarnings.add(msg)) {
            this.logger.log(level, new Object[]{msg});
        }
    }

    private String scopedIfNecessary(IASTIdExpression var, String function) {
        IASTSimpleDeclaration decl = var.getDeclaration();
        boolean isGlobal = false;
        if (decl instanceof IASTDeclaration) {
            isGlobal = ((IASTDeclaration)decl).isGlobal();
        }
        if (isGlobal) {
            return var.getName();
        }
        return CtoFormulaConverter.scoped(var.getName(), function);
    }

    private static String scoped(String var, String function) {
        return function + "::" + var;
    }

    private static String exprToVarName(IASTExpression e) {
        return e.toASTString().replaceAll("[ \n\t]", "");
    }

    private String getTypeName(IType tp) {
        if (tp instanceof IASTPointerTypeSpecifier) {
            return this.getTypeName(((IASTPointerTypeSpecifier)tp).getType());
        }
        if (tp instanceof ITypedef) {
            return this.getTypeName(((ITypedef)tp).getType());
        }
        if (tp instanceof IComplexType) {
            return ((IComplexType)tp).getName();
        }
        throw new AssertionError((Object)"wrong type");
    }

    private int makeFreshIndex(String varName, SSAMap.SSAMapBuilder ssa) {
        int idx = ssa.getIndex(varName);
        idx = idx > 0 ? ++idx : 2;
        ssa.setIndex(varName, idx);
        return idx;
    }

    private int getIndex(String var, SSAMap.SSAMapBuilder ssa) {
        int idx = ssa.getIndex(var);
        if (idx <= 0) {
            this.logger.log(Level.ALL, new Object[]{"WARNING: Auto-instantiating variable:", var});
            idx = 1;
            ssa.setIndex(var, idx);
        }
        return idx;
    }

    private int makeLvalIndex(String varName, FormulaList args, SSAMap.SSAMapBuilder ssa) {
        int idx = ssa.getIndex(varName, args);
        idx = idx > 0 ? ++idx : 2;
        ssa.setIndex(varName, args, idx);
        return idx;
    }

    private Formula makeConstant(String var, SSAMap.SSAMapBuilder ssa) {
        int idx = ssa.getIndex(var);
        assert (idx <= 1) : var + " is assumed to be constant there was an assignment to it";
        if (idx != 1) {
            ssa.setIndex(var, 1);
        }
        return this.fmgr.makeVariable(var, 1);
    }

    private Formula makeVariable(String varName, SSAMap.SSAMapBuilder ssa) {
        int idx = this.getIndex(varName, ssa);
        return this.fmgr.makeVariable(varName, idx);
    }

    private Formula makeFreshVariable(String varName, SSAMap.SSAMapBuilder ssa) {
        int idx = this.makeFreshIndex(varName, ssa);
        return this.fmgr.makeVariable(varName, idx);
    }

    private Formula makePointerVariable(IASTIdExpression expr, String function, SSAMap.SSAMapBuilder ssa) {
        String pVarName = this.makePointerVariableName(expr, function, ssa);
        return this.makeVariable(pVarName, ssa);
    }

    private static String makePointerMask(String scopedId, SSAMap.SSAMapBuilder ssa) {
        return POINTER_VARIABLE + scopedId + "__at__" + ssa.getIndex(scopedId) + "__end";
    }

    private static String removePointerMask(String pointerVariable) {
        assert (CtoFormulaConverter.isPointerVariable(pointerVariable));
        return pointerVariable.substring(POINTER_VARIABLE.length(), pointerVariable.indexOf("__at__"));
    }

    private String makePointerVariableName(IASTIdExpression expr, String function, SSAMap.SSAMapBuilder ssa) {
        String scopedId = this.scopedIfNecessary(expr, function);
        return CtoFormulaConverter.makePointerMask(scopedId, ssa);
    }

    private String makeMemoryLocationVariableName(String varName) {
        return MEMORY_ADDRESS_VARIABLE_PREFIX + varName;
    }

    private Formula makeAssignment(String varName, Formula rightHandSide, SSAMap.SSAMapBuilder ssa) {
        Formula lhs = this.makeFreshVariable(varName, ssa);
        return this.fmgr.makeAssignment(lhs, rightHandSide);
    }

    public PathFormula makeAnd(PathFormula oldFormula, CFAEdge edge) throws CPATransferException {
        int lFlagIndex;
        int lNondetIndex;
        Formula edgeFormula;
        if (edge.getEdgeType() == CFAEdgeType.BlankEdge) {
            return oldFormula;
        }
        String function = edge.getPredecessor() != null ? edge.getPredecessor().getFunctionName() : null;
        SSAMap.SSAMapBuilder ssa = oldFormula.getSsa().builder();
        Constraints constraints = new Constraints();
        switch (edge.getEdgeType()) {
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)edge;
                StatementToFormulaVisitor v = this.handlePointerAliasing ? new StatementToFormulaVisitorPointers(function, ssa, constraints, edge) : new StatementToFormulaVisitor(function, ssa, constraints, edge);
                edgeFormula = statementEdge.getStatement().accept(v);
                break;
            }
            case ReturnStatementEdge: {
                ReturnStatementEdge returnEdge = (ReturnStatementEdge)edge;
                edgeFormula = this.makeReturn(returnEdge.getExpression(), returnEdge, function, ssa, constraints);
                break;
            }
            case DeclarationEdge: {
                DeclarationEdge d = (DeclarationEdge)edge;
                edgeFormula = this.makeDeclaration(d, function, ssa, constraints);
                break;
            }
            case AssumeEdge: {
                edgeFormula = this.makeAssume((AssumeEdge)edge, function, ssa, constraints);
                break;
            }
            case BlankEdge: {
                assert (false) : "Handled above";
                edgeFormula = this.fmgr.makeTrue();
                break;
            }
            case FunctionCallEdge: {
                edgeFormula = this.makeFunctionCall((FunctionCallEdge)edge, function, ssa, constraints);
                break;
            }
            case FunctionReturnEdge: {
                CallToReturnEdge ce = ((FunctionReturnEdge)edge).getSummaryEdge();
                edgeFormula = this.makeExitFunction(ce, function, ssa, constraints);
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(edge);
            }
        }
        if (this.useNondetFlags && (lNondetIndex = ssa.getIndex(NONDET_VARIABLE)) != (lFlagIndex = ssa.getIndex(NONDET_FLAG_VARIABLE))) {
            if (lFlagIndex < 0) {
                lFlagIndex = 1;
            }
            for (int lIndex = lFlagIndex + 1; lIndex <= lNondetIndex; ++lIndex) {
                Formula lAssignment = this.fmgr.makeAssignment(this.fmgr.makeVariable(NONDET_FLAG_VARIABLE, lIndex), this.fmgr.makeNumber(1));
                edgeFormula = this.fmgr.makeAnd(edgeFormula, lAssignment);
            }
            ssa.setIndex(NONDET_FLAG_VARIABLE, lNondetIndex);
        }
        edgeFormula = this.fmgr.makeAnd(edgeFormula, constraints.get());
        SSAMap newSsa = ssa.build();
        if (edgeFormula.isTrue() && newSsa == oldFormula.getSsa()) {
            return oldFormula;
        }
        Formula newFormula = this.fmgr.makeAnd(oldFormula.getFormula(), edgeFormula);
        int newLength = oldFormula.getLength() + 1;
        return new PathFormula(newFormula, newSsa, newLength);
    }

    private Formula makeDeclaration(DeclarationEdge edge, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints) throws CPATransferException {
        if (!(edge.getDeclaration() instanceof IASTVariableDeclaration)) {
            this.logDebug("Ignoring declaration", edge);
            return this.fmgr.makeTrue();
        }
        IASTVariableDeclaration decl = (IASTVariableDeclaration)edge.getDeclaration();
        String varNameWithoutFunction = decl.getName();
        String varName = decl.isGlobal() ? varNameWithoutFunction : CtoFormulaConverter.scoped(varNameWithoutFunction, function);
        this.makeFreshIndex(varName, ssa);
        IASTInitializer initializer = decl.getInitializer();
        IASTExpression init = null;
        if (initializer == null) {
            if (this.initAllVars) {
                this.logDebug("AUTO-INITIALIZING VAR: ", edge);
                init = Defaults.forType(decl.getDeclSpecifier(), null);
            }
        } else if (initializer instanceof IASTInitializerExpression) {
            init = ((IASTInitializerExpression)initializer).getExpression();
        } else {
            this.logDebug("Ignoring unsupported initializer", initializer);
        }
        if (init == null) {
            return this.fmgr.makeTrue();
        }
        Formula minit = this.buildTerm(init, edge, function, ssa, constraints);
        Formula assignments = this.makeAssignment(varName, minit, ssa);
        if (this.handlePointerAliasing) {
            Formula pAssign = this.buildDirectSecondLevelAssignment(decl.getDeclSpecifier(), varName, CtoFormulaConverter.removeCast(init), function, constraints, ssa);
            assignments = this.fmgr.makeAnd(pAssign, assignments);
        }
        return assignments;
    }

    private Formula makeExitFunction(CallToReturnEdge ce, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints) throws CPATransferException {
        IASTFunctionCall retExp = ce.getExpression();
        if (retExp instanceof IASTFunctionCallStatement) {
            return this.fmgr.makeTrue();
        }
        if (retExp instanceof IASTFunctionCallAssignmentStatement) {
            IASTExpression left;
            IASTFunctionCallAssignmentStatement exp = (IASTFunctionCallAssignmentStatement)retExp;
            String retVarName = CtoFormulaConverter.scoped(VAR_RETURN_NAME, function);
            Formula retVar = this.makeVariable(retVarName, ssa);
            IASTExpression e = exp.getLeftHandSide();
            function = ce.getSuccessor().getFunctionName();
            Formula outvarFormula = this.buildLvalueTerm(e, ce, function, ssa, constraints);
            Formula assignments = this.fmgr.makeAssignment(outvarFormula, retVar);
            if (this.handlePointerAliasing && (left = CtoFormulaConverter.removeCast(e)) instanceof IASTIdExpression) {
                Formula ptrAssignment = this.buildDirectReturnSecondLevelAssignment((IASTIdExpression)left, retVarName, function, ssa);
                assignments = this.fmgr.makeAnd(assignments, ptrAssignment);
            }
            return assignments;
        }
        throw new UnrecognizedCCodeException("Unknown function exit expression", ce, retExp.asStatement());
    }

    private Formula makeFunctionCall(FunctionCallEdge edge, String callerFunction, SSAMap.SSAMapBuilder ssa, Constraints constraints) throws CPATransferException {
        List<IASTExpression> actualParams = edge.getArguments();
        FunctionDefinitionNode fn = edge.getSuccessor();
        List<IASTParameterDeclaration> formalParams = fn.getFunctionParameters();
        String calledFunction = fn.getFunctionName();
        if (fn.getFunctionDefinition().getDeclSpecifier().takesVarArgs()) {
            if (formalParams.size() > actualParams.size()) {
                throw new UnrecognizedCCodeException("Number of parameters on function call does not match function definition", edge);
            }
            this.logger.log(Level.WARNING, new Object[]{"Ignoring parameters passed as varargs to function", calledFunction, "in line", edge.getLineNumber()});
        } else if (formalParams.size() != actualParams.size()) {
            throw new UnrecognizedCCodeException("Number of parameters on function call does not match function definition", edge);
        }
        int i = 0;
        Formula result = this.fmgr.makeTrue();
        for (IASTParameterDeclaration formalParam : formalParams) {
            String formalParamName = formalParam.getName();
            assert (!formalParamName.isEmpty()) : edge;
            if (formalParam.getDeclSpecifier() instanceof IASTPointerTypeSpecifier) {
                this.warnUnsafeAssignment();
                this.logDebug("Ignoring the semantics of pointer for parameter " + formalParamName, fn.getFunctionDefinition());
            }
            Formula actualParam = this.buildTerm(actualParams.get(i++), edge, callerFunction, ssa, constraints);
            Formula eq = this.makeAssignment(CtoFormulaConverter.scoped(formalParamName, calledFunction), actualParam, ssa);
            result = this.fmgr.makeAnd(result, eq);
        }
        return result;
    }

    private Formula makeReturn(IASTExpression rightExp, ReturnStatementEdge edge, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints) throws CPATransferException {
        if (rightExp == null) {
            return this.fmgr.makeTrue();
        }
        Formula retval = this.buildTerm(rightExp, edge, function, ssa, constraints);
        String retVarName = CtoFormulaConverter.scoped(VAR_RETURN_NAME, function);
        Formula assignments = this.makeAssignment(retVarName, retval, ssa);
        if (this.handlePointerAliasing) {
            Formula rightAssignment = this.buildDirectSecondLevelAssignment(null, retVarName, rightExp, function, constraints, ssa);
            assignments = this.fmgr.makeAnd(assignments, rightAssignment);
        }
        return assignments;
    }

    private Formula makeAssume(AssumeEdge assume, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints) throws CPATransferException {
        return this.makePredicate(assume.getExpression(), assume.getTruthAssumption(), assume, function, ssa, constraints);
    }

    private Formula buildTerm(IASTExpression exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints) throws UnrecognizedCCodeException {
        return this.toNumericFormula(exp.accept(this.getExpressionVisitor(edge, function, ssa, constraints)));
    }

    private Formula buildLvalueTerm(IASTExpression exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints) throws UnrecognizedCCodeException {
        return exp.accept(this.getLvalueVisitor(edge, function, ssa, constraints));
    }

    private Formula buildDirectReturnSecondLevelAssignment(IASTIdExpression leftId, String retVarName, String function, SSAMap.SSAMapBuilder ssa) {
        if (this.maybePointer(leftId, function, ssa) || this.maybePointer((IType)null, retVarName, ssa)) {
            Formula lPVar = this.makePointerVariable(leftId, function, ssa);
            String retPVarName = CtoFormulaConverter.makePointerMask(retVarName, ssa);
            Formula retPVar = this.makeVariable(retPVarName, ssa);
            return this.fmgr.makeAssignment(lPVar, retPVar);
        }
        return this.fmgr.makeTrue();
    }

    private Formula buildDirectSecondLevelAssignment(IType lType, String lVarName, IASTRightHandSide pRight, String function, Constraints constraints, SSAMap.SSAMapBuilder ssa) {
        IASTRightHandSide right = CtoFormulaConverter.removeCast(pRight);
        Formula lVar = this.makeVariable(lVarName, ssa);
        if (CtoFormulaConverter.isVariable(right)) {
            IASTIdExpression rIdExp = (IASTIdExpression)right;
            if (this.maybePointer(lType, lVarName, ssa) || this.maybePointer(rIdExp, function, ssa)) {
                String lPVarName = CtoFormulaConverter.makePointerMask(lVarName, ssa);
                Formula lPVar = this.makeVariable(lPVarName, ssa);
                Formula rPVar = this.makePointerVariable(rIdExp, function, ssa);
                return this.fmgr.makeAssignment(lPVar, rPVar);
            }
            return this.fmgr.makeTrue();
        }
        if (CtoFormulaConverter.isPointerDereferencing(right)) {
            String lPVarName = CtoFormulaConverter.makePointerMask(lVarName, ssa);
            this.makeFreshIndex(lPVarName, ssa);
            CtoFormulaConverter.removeOldPointerVariablesFromSsaMap(lPVarName, ssa);
            Formula lPVar = this.makeVariable(lPVarName, ssa);
            IASTExpression rExpr = CtoFormulaConverter.removeCast(((IASTUnaryExpression)right).getOperand());
            if (!(rExpr instanceof IASTIdExpression)) {
                return this.fmgr.makeTrue();
            }
            IASTIdExpression rIdExpr = (IASTIdExpression)rExpr;
            Formula rPVar = this.makePointerVariable(rIdExpr, function, ssa);
            List<String> pVars = CtoFormulaConverter.getAllPointerVariablesFromSsaMap(ssa);
            for (String pVarName : pVars) {
                String varName = CtoFormulaConverter.removePointerMask(pVarName);
                if (varName.equals(lVarName)) continue;
                Formula var = this.makeVariable(varName, ssa);
                Formula pVar = this.makeVariable(pVarName, ssa);
                Formula p = this.fmgr.makeEqual(rPVar, var);
                Formula dirEq = this.fmgr.makeEqual(lVar, var);
                Formula indirEq = this.fmgr.makeEqual(lPVar, pVar);
                Formula consequence = this.fmgr.makeAnd(dirEq, indirEq);
                Formula constraint = this.fmgr.makeImplication(p, consequence);
                constraints.addConstraint(constraint);
            }
            return this.fmgr.makeTrue();
        }
        if (this.isMemoryLocation(right)) {
            IASTExpression rOperand;
            if (right instanceof IASTUnaryExpression && ((IASTUnaryExpression)right).getOperator() == IASTUnaryExpression.UnaryOperator.AMPER && (rOperand = CtoFormulaConverter.removeCast(((IASTUnaryExpression)right).getOperand())) instanceof IASTIdExpression) {
                String rVarName = this.scopedIfNecessary((IASTIdExpression)rOperand, function);
                Formula rVar = this.makeVariable(rVarName, ssa);
                String lPVarName = CtoFormulaConverter.makePointerMask(lVarName, ssa);
                Formula lPVar = this.makeVariable(lPVarName, ssa);
                return this.fmgr.makeAssignment(lPVar, rVar);
            }
            return this.fmgr.makeTrue();
        }
        return this.fmgr.makeTrue();
    }

    private Formula makePredicate(IASTExpression exp, boolean isTrue, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints) throws UnrecognizedCCodeException {
        Formula result = this.toBooleanFormula(exp.accept(this.getExpressionVisitor(edge, function, ssa, constraints)));
        if (!isTrue) {
            result = this.fmgr.makeNot(result);
        }
        return result;
    }

    public Formula makePredicate(IASTExpression exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa) throws UnrecognizedCCodeException {
        Constraints constraints = new Constraints();
        Formula f = this.makePredicate(exp, true, edge, function, ssa, constraints);
        return this.fmgr.makeAnd(f, constraints.get());
    }

    private ExpressionToFormulaVisitor getExpressionVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo) {
        if (this.lvalsAsUif) {
            return new ExpressionToFormulaVisitorUIF(pEdge, pFunction, pSsa, pCo);
        }
        if (this.handlePointerAliasing) {
            return new ExpressionToFormulaVisitorPointers(pEdge, pFunction, pSsa, pCo);
        }
        return new ExpressionToFormulaVisitor(pEdge, pFunction, pSsa, pCo);
    }

    private LvalueVisitor getLvalueVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo) {
        if (this.lvalsAsUif) {
            return new LvalueVisitorUIF(pEdge, pFunction, pSsa, pCo);
        }
        if (this.handlePointerAliasing) {
            return new LvalueVisitorPointers(pEdge, pFunction, pSsa, pCo);
        }
        return new LvalueVisitor(pEdge, pFunction, pSsa, pCo);
    }

    private Formula toBooleanFormula(Formula f) {
        if (!this.fmgr.isBoolean(f)) {
            Formula z = this.fmgr.makeNumber(0);
            f = this.fmgr.makeNot(this.fmgr.makeEqual(f, z));
        }
        return f;
    }

    private Formula toNumericFormula(Formula f) {
        if (this.fmgr.isBoolean(f)) {
            f = this.fmgr.makeIfThenElse(f, this.fmgr.makeNumber(1), this.fmgr.makeNumber(0));
        }
        return f;
    }

    private static boolean isVariable(IASTNode exp) {
        return exp instanceof IASTIdExpression;
    }

    private static boolean isPointerDereferencing(IASTNode exp) {
        return exp instanceof IASTUnaryExpression && ((IASTUnaryExpression)exp).getOperator() == IASTUnaryExpression.UnaryOperator.STAR;
    }

    private static boolean isStaticallyDeclaredPointer(IType expr) {
        return expr instanceof IASTPointerTypeSpecifier;
    }

    private static boolean isPointerVariable(String variableName) {
        return POINTER_VARIABLE_PATTERN.matcher(variableName).matches();
    }

    private boolean isMemoryLocation(IASTNode exp) {
        String functionName;
        IASTExpression fn;
        return exp instanceof IASTFunctionCall ? (fn = ((IASTFunctionCall)((Object)exp)).getFunctionCallExpression().getFunctionNameExpression()) instanceof IASTIdExpression && this.memoryAllocationFunctions.contains(functionName = ((IASTIdExpression)fn).getName()) : exp instanceof IASTUnaryExpression && ((IASTUnaryExpression)exp).getOperator() == IASTUnaryExpression.UnaryOperator.AMPER;
    }

    private boolean maybePointer(IASTExpression pExp, String function, SSAMap.SSAMapBuilder ssa) {
        IASTExpression exp = CtoFormulaConverter.removeCast(pExp);
        if (exp instanceof IASTIdExpression) {
            IASTIdExpression idExp = (IASTIdExpression)exp;
            IType type = exp.getExpressionType();
            return this.maybePointer(type, this.scopedIfNecessary(idExp, function), ssa);
        }
        return false;
    }

    private boolean maybePointer(IType type, String varName, SSAMap.SSAMapBuilder ssa) {
        if (type != null && CtoFormulaConverter.isStaticallyDeclaredPointer(type)) {
            return true;
        }
        List<String> pVarNames = CtoFormulaConverter.getAllPointerVariablesFromSsaMap(ssa);
        String expPVarName = CtoFormulaConverter.makePointerMask(varName, ssa);
        return pVarNames.contains(expPVarName);
    }

    private static List<String> getAllMemoryLocationsFromSsaMap(SSAMap.SSAMapBuilder ssa) {
        LinkedList<String> memoryLocations = new LinkedList<String>();
        Set<String> ssaVariables = ssa.build().allVariables();
        Pattern p = Pattern.compile("^__address_of__.*");
        for (String variable : ssaVariables) {
            if (!p.matcher(variable).matches()) continue;
            memoryLocations.add(variable);
        }
        return memoryLocations;
    }

    private static List<String> getAllPointerVariablesFromSsaMap(SSAMap.SSAMapBuilder ssa) {
        LinkedList<String> pointerVariables = new LinkedList<String>();
        Set<String> ssaVariables = ssa.build().allVariables();
        for (String variable : ssaVariables) {
            if (!CtoFormulaConverter.isPointerVariable(variable)) continue;
            pointerVariables.add(variable);
        }
        return pointerVariables;
    }

    private static void removeOldPointerVariablesFromSsaMap(String newPVar, SSAMap.SSAMapBuilder ssa) {
        String newVar = CtoFormulaConverter.removePointerMask(newPVar);
        List<String> pointerVariables = CtoFormulaConverter.getAllPointerVariablesFromSsaMap(ssa);
        for (String pointerVar : pointerVariables) {
            String oldVar = CtoFormulaConverter.removePointerMask(pointerVar);
            if (pointerVar.equals(newPVar) || !oldVar.equals(newVar)) continue;
            ssa.deleteVariable(pointerVar);
        }
    }

    private static IASTExpression removeCast(IASTExpression exp) {
        if (exp instanceof IASTCastExpression) {
            return CtoFormulaConverter.removeCast(((IASTCastExpression)exp).getOperand());
        }
        return exp;
    }

    private static IASTRightHandSide removeCast(IASTRightHandSide exp) {
        if (exp instanceof IASTCastExpression) {
            return CtoFormulaConverter.removeCast(((IASTCastExpression)exp).getOperand());
        }
        return exp;
    }

    private class LvalueVisitorPointers
    extends LvalueVisitor {
        public LvalueVisitorPointers(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo) {
            super(pEdge, pFunction, pSsa, pCo);
        }

        @Override
        public Formula visit(IASTCastExpression e) throws UnrecognizedCCodeException {
            return e.getOperand().accept(this);
        }

        private Formula getPointerFormula(IASTExpression pExp) {
            IASTExpression exp = CtoFormulaConverter.removeCast(pExp);
            if (exp instanceof IASTIdExpression) {
                IASTIdExpression pId = (IASTIdExpression)exp;
                String pVarName = CtoFormulaConverter.this.makePointerVariableName(pId, this.function, this.ssa);
                CtoFormulaConverter.this.makeFreshIndex(pVarName, this.ssa);
                return CtoFormulaConverter.this.makePointerVariable(pId, this.function, this.ssa);
            }
            return this.makeUIF(exp);
        }

        @Override
        public Formula visit(IASTUnaryExpression pE) throws UnrecognizedCCodeException {
            if (pE.getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
                return this.getPointerFormula(pE.getOperand());
            }
            return super.visit(pE);
        }
    }

    private class LvalueVisitorUIF
    extends LvalueVisitor {
        public LvalueVisitorUIF(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo) {
            super(pEdge, pFunction, pSsa, pCo);
        }

        @Override
        public Formula visit(IASTUnaryExpression uExp) throws UnrecognizedCCodeException {
            String opname;
            IASTUnaryExpression.UnaryOperator op = uExp.getOperator();
            IASTExpression operand = uExp.getOperand();
            switch (op) {
                case AMPER: {
                    opname = CtoFormulaConverter.OP_ADDRESSOF_NAME;
                    break;
                }
                case STAR: {
                    opname = CtoFormulaConverter.OP_STAR_NAME;
                    break;
                }
                default: {
                    throw new UnrecognizedCCodeException("Invalid unary operator for lvalue", this.edge, uExp);
                }
            }
            Formula term = CtoFormulaConverter.this.buildTerm(operand, this.edge, this.function, this.ssa, this.constraints);
            int idx = CtoFormulaConverter.this.makeFreshIndex(opname, this.ssa);
            return CtoFormulaConverter.this.fmgr.makeUIF(opname, CtoFormulaConverter.this.fmgr.makeList(term), idx);
        }

        @Override
        public Formula visit(IASTFieldReference fexp) throws UnrecognizedCCodeException {
            String field = fexp.getFieldName();
            IASTExpression owner = fexp.getFieldOwner();
            Formula term = CtoFormulaConverter.this.buildTerm(owner, this.edge, this.function, this.ssa, this.constraints);
            String tpname = CtoFormulaConverter.this.getTypeName(owner.getExpressionType());
            String ufname = (fexp.isPointerDereference() ? "->{" : ".{") + tpname + "," + field + "}";
            FormulaList args = CtoFormulaConverter.this.fmgr.makeList(term);
            int idx = CtoFormulaConverter.this.makeLvalIndex(ufname, args, this.ssa);
            return CtoFormulaConverter.this.fmgr.makeUIF(ufname, args, idx);
        }

        @Override
        public Formula visit(IASTArraySubscriptExpression aexp) throws UnrecognizedCCodeException {
            IASTExpression arrexp = aexp.getArrayExpression();
            IASTExpression subexp = aexp.getSubscriptExpression();
            Formula aterm = CtoFormulaConverter.this.buildTerm(arrexp, this.edge, this.function, this.ssa, this.constraints);
            Formula sterm = CtoFormulaConverter.this.buildTerm(subexp, this.edge, this.function, this.ssa, this.constraints);
            String ufname = CtoFormulaConverter.OP_ARRAY_SUBSCRIPT;
            FormulaList args = CtoFormulaConverter.this.fmgr.makeList(aterm, sterm);
            int idx = CtoFormulaConverter.this.makeLvalIndex(ufname, args, this.ssa);
            return CtoFormulaConverter.this.fmgr.makeUIF(ufname, args, idx);
        }
    }

    private class LvalueVisitor
    extends DefaultExpressionVisitor<Formula, UnrecognizedCCodeException> {
        protected final CFAEdge edge;
        protected final String function;
        protected final SSAMap.SSAMapBuilder ssa;
        protected final Constraints constraints;

        public LvalueVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo) {
            this.edge = pEdge;
            this.function = pFunction;
            this.ssa = pSsa;
            this.constraints = pCo;
        }

        @Override
        protected Formula visitDefault(IASTExpression exp) throws UnrecognizedCCodeException {
            throw new UnrecognizedCCodeException("Unknown lvalue", this.edge, exp);
        }

        @Override
        public Formula visit(IASTIdExpression idExp) {
            String var = CtoFormulaConverter.this.scopedIfNecessary(idExp, this.function);
            return CtoFormulaConverter.this.makeFreshVariable(var, this.ssa);
        }

        protected Formula makeUIF(IASTExpression exp) {
            CtoFormulaConverter.this.warnUnsafeAssignment();
            CtoFormulaConverter.this.logDebug("Assigning to ", exp);
            String var = CtoFormulaConverter.scoped(CtoFormulaConverter.exprToVarName(exp), this.function);
            return CtoFormulaConverter.this.makeFreshVariable(var, this.ssa);
        }

        @Override
        public Formula visit(IASTUnaryExpression pE) throws UnrecognizedCCodeException {
            return this.makeUIF(pE);
        }

        @Override
        public Formula visit(IASTFieldReference fExp) throws UnrecognizedCCodeException {
            IASTSimpleDeclaration decl;
            IASTExpression fieldRef = fExp.getFieldOwner();
            if (fieldRef instanceof IASTIdExpression && (decl = ((IASTIdExpression)fieldRef).getDeclaration()) instanceof IASTDeclaration && ((IASTDeclaration)decl).isGlobal()) {
                String var = CtoFormulaConverter.exprToVarName(fExp);
                return CtoFormulaConverter.this.makeFreshVariable(var, this.ssa);
            }
            return this.makeUIF(fExp);
        }

        @Override
        public Formula visit(IASTArraySubscriptExpression pE) throws UnrecognizedCCodeException {
            return this.makeUIF(pE);
        }
    }

    private class StatementToFormulaVisitorPointers
    extends StatementToFormulaVisitor {
        public StatementToFormulaVisitorPointers(String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pConstraints, CFAEdge edge) {
            super(pFunction, pSsa, pConstraints, edge);
        }

        @Override
        public Formula visit(IASTFunctionCallExpression fexp) throws UnrecognizedCCodeException {
            IASTExpression fn = fexp.getFunctionNameExpression();
            if (fn instanceof IASTIdExpression) {
                String fName = ((IASTIdExpression)fn).getName();
                if (CtoFormulaConverter.this.memoryAllocationFunctions.contains(fName)) {
                    List memoryLocations = CtoFormulaConverter.getAllMemoryLocationsFromSsaMap(this.ssa);
                    String mallocVarName = this.makeFreshMallocVariableName();
                    Formula mallocVar = CtoFormulaConverter.this.makeConstant(mallocVarName, this.ssa);
                    Formula ineq = CtoFormulaConverter.this.fmgr.makeTrue();
                    for (String ml : memoryLocations) {
                        Formula n = CtoFormulaConverter.this.makeConstant(ml, this.ssa);
                        Formula notEqual = CtoFormulaConverter.this.fmgr.makeNotEqual(n, mallocVar);
                        ineq = CtoFormulaConverter.this.fmgr.makeAnd(notEqual, ineq);
                    }
                    Formula nullFormula = CtoFormulaConverter.this.fmgr.makeNumber(0);
                    Formula notEqual = CtoFormulaConverter.this.fmgr.makeNotEqual(mallocVar, nullFormula);
                    Formula implication = CtoFormulaConverter.this.fmgr.makeImplication(notEqual, ineq);
                    this.constraints.addConstraint(implication);
                    return mallocVar;
                }
            }
            return super.visit(fexp);
        }

        @Override
        public Formula visit(IASTAssignment assignment) throws UnrecognizedCCodeException {
            IASTExpression left = CtoFormulaConverter.removeCast(assignment.getLeftHandSide());
            if (left instanceof IASTIdExpression) {
                return this.handleDirectAssignment(assignment);
            }
            if (left instanceof IASTUnaryExpression && ((IASTUnaryExpression)left).getOperator() == IASTUnaryExpression.UnaryOperator.STAR) {
                return this.handleIndirectAssignment(assignment);
            }
            return super.visit(assignment);
        }

        private Formula handleIndirectAssignment(IASTAssignment pAssignment) throws UnrecognizedCCodeException {
            IASTExpression lExp = CtoFormulaConverter.removeCast(pAssignment.getLeftHandSide());
            assert (lExp instanceof IASTUnaryExpression);
            IASTUnaryExpression l = (IASTUnaryExpression)lExp;
            assert (l.getOperator() == IASTUnaryExpression.UnaryOperator.STAR);
            IASTExpression lOperand = CtoFormulaConverter.removeCast(l.getOperand());
            if (!(lOperand instanceof IASTIdExpression)) {
                return super.visit(pAssignment);
            }
            IASTRightHandSide r = pAssignment.getRightHandSide();
            String lVarName = CtoFormulaConverter.this.scopedIfNecessary((IASTIdExpression)lOperand, this.function);
            Formula lVar = CtoFormulaConverter.this.makeVariable(lVarName, this.ssa);
            String rVarName = null;
            Formula rPVar = null;
            if (r instanceof IASTIdExpression) {
                rVarName = CtoFormulaConverter.this.scopedIfNecessary((IASTIdExpression)r, this.function);
                rPVar = CtoFormulaConverter.this.makePointerVariable((IASTIdExpression)r, this.function, this.ssa);
            }
            Formula rightVariable = pAssignment.getRightHandSide().accept(this);
            rightVariable = CtoFormulaConverter.this.toNumericFormula(rightVariable);
            Formula lPVar = CtoFormulaConverter.this.buildLvalueTerm(pAssignment.getLeftHandSide(), this.edge, this.function, this.ssa, this.constraints);
            Formula assignments = CtoFormulaConverter.this.fmgr.makeAssignment(lPVar, rightVariable);
            this.updateAllPointers(lVarName, lVar, rVarName, rightVariable);
            boolean doDeepUpdate = r instanceof IASTIdExpression;
            this.updateAllMemoryLocations(lVar, rPVar, rightVariable, doDeepUpdate);
            return assignments;
        }

        private void updateAllMemoryLocations(Formula lVar, Formula rPVar, Formula rightVariable, boolean deepUpdate) {
            List memAddresses = CtoFormulaConverter.getAllMemoryLocationsFromSsaMap(this.ssa);
            if (deepUpdate) {
                for (String memAddress : memAddresses) {
                    String varName = this.getVariableNameFromMemoryAddress(memAddress);
                    Formula memAddressVar = CtoFormulaConverter.this.makeVariable(memAddress, this.ssa);
                    Formula oldVar = CtoFormulaConverter.this.makeVariable(varName, this.ssa);
                    String oldPVarName = CtoFormulaConverter.makePointerMask(varName, this.ssa);
                    Formula oldPVar = CtoFormulaConverter.this.makeVariable(oldPVarName, this.ssa);
                    CtoFormulaConverter.this.makeFreshIndex(varName, this.ssa);
                    Formula newVar = CtoFormulaConverter.this.makeVariable(varName, this.ssa);
                    String newPVarName = CtoFormulaConverter.makePointerMask(varName, this.ssa);
                    Formula newPVar = CtoFormulaConverter.this.makeVariable(varName, this.ssa);
                    CtoFormulaConverter.removeOldPointerVariablesFromSsaMap(newPVarName, this.ssa);
                    Formula varEquality = CtoFormulaConverter.this.fmgr.makeAssignment(newVar, rightVariable);
                    Formula pVarEquality = CtoFormulaConverter.this.fmgr.makeAssignment(newPVar, rPVar);
                    Formula varUpdate = CtoFormulaConverter.this.fmgr.makeAssignment(newVar, oldVar);
                    Formula pVarUpdate = CtoFormulaConverter.this.fmgr.makeAssignment(newPVar, oldPVar);
                    Formula condition = CtoFormulaConverter.this.fmgr.makeEqual(lVar, memAddressVar);
                    Formula equality = CtoFormulaConverter.this.fmgr.makeAnd(varEquality, pVarEquality);
                    Formula update = CtoFormulaConverter.this.fmgr.makeAnd(varUpdate, pVarUpdate);
                    Formula variableUpdate = CtoFormulaConverter.this.fmgr.makeIfThenElse(condition, equality, update);
                    this.constraints.addConstraint(variableUpdate);
                }
            } else {
                for (String memAddress : memAddresses) {
                    String varName = this.getVariableNameFromMemoryAddress(memAddress);
                    Formula oldVar = CtoFormulaConverter.this.makeVariable(varName, this.ssa);
                    CtoFormulaConverter.this.makeFreshIndex(varName, this.ssa);
                    Formula newVar = CtoFormulaConverter.this.makeVariable(varName, this.ssa);
                    String newPVarName = CtoFormulaConverter.makePointerMask(varName, this.ssa);
                    CtoFormulaConverter.removeOldPointerVariablesFromSsaMap(newPVarName, this.ssa);
                    Formula memAddressVar = CtoFormulaConverter.this.makeVariable(memAddress, this.ssa);
                    Formula condition = CtoFormulaConverter.this.fmgr.makeEqual(lVar, memAddressVar);
                    Formula equality = CtoFormulaConverter.this.fmgr.makeAssignment(newVar, rightVariable);
                    Formula update = CtoFormulaConverter.this.fmgr.makeAssignment(newVar, oldVar);
                    Formula variableUpdate = CtoFormulaConverter.this.fmgr.makeIfThenElse(condition, equality, update);
                    this.constraints.addConstraint(variableUpdate);
                }
            }
        }

        private void updateAllPointers(String leftVarName, Formula leftVar, String rightVarName, Formula rightVariable) {
            List pVarNames = CtoFormulaConverter.getAllPointerVariablesFromSsaMap(this.ssa);
            for (String pVarName : pVarNames) {
                String varName = CtoFormulaConverter.removePointerMask(pVarName);
                if (varName.equals(leftVarName) || varName.equals(rightVarName)) continue;
                Formula var = CtoFormulaConverter.this.makeVariable(varName, this.ssa);
                Formula oldPVar = CtoFormulaConverter.this.makeVariable(pVarName, this.ssa);
                CtoFormulaConverter.this.makeFreshIndex(pVarName, this.ssa);
                Formula newPVar = CtoFormulaConverter.this.makeVariable(pVarName, this.ssa);
                Formula condition = CtoFormulaConverter.this.fmgr.makeEqual(var, leftVar);
                Formula equality = CtoFormulaConverter.this.fmgr.makeAssignment(newPVar, rightVariable);
                Formula indexUpdate = CtoFormulaConverter.this.fmgr.makeAssignment(newPVar, oldPVar);
                Formula variableUpdate = CtoFormulaConverter.this.fmgr.makeIfThenElse(condition, equality, indexUpdate);
                this.constraints.addConstraint(variableUpdate);
            }
        }

        private Formula handleDirectAssignment(IASTAssignment assignment) throws UnrecognizedCCodeException {
            IASTExpression lExpr = CtoFormulaConverter.removeCast(assignment.getLeftHandSide());
            assert (lExpr instanceof IASTIdExpression);
            IASTIdExpression left = (IASTIdExpression)lExpr;
            IASTRightHandSide right = CtoFormulaConverter.removeCast(assignment.getRightHandSide());
            String leftVarName = CtoFormulaConverter.this.scopedIfNecessary(left, this.function);
            Formula ri = assignment.getRightHandSide().accept(this);
            Formula rightVariable = CtoFormulaConverter.this.toNumericFormula(ri);
            Formula leftVariable = CtoFormulaConverter.this.buildLvalueTerm(assignment.getLeftHandSide(), this.edge, this.function, this.ssa, this.constraints);
            Formula firstLevelFormula = CtoFormulaConverter.this.fmgr.makeAssignment(leftVariable, rightVariable);
            String lVarName = CtoFormulaConverter.this.scopedIfNecessary(left, this.function);
            Formula secondLevelFormula = CtoFormulaConverter.this.buildDirectSecondLevelAssignment(left.getExpressionType(), lVarName, right, this.function, this.constraints, this.ssa);
            Formula assignmentFormula = CtoFormulaConverter.this.fmgr.makeAnd(firstLevelFormula, secondLevelFormula);
            if (this.isKnownMemoryLocation(leftVarName)) {
                String leftMemLocationName = CtoFormulaConverter.this.makeMemoryLocationVariableName(leftVarName);
                Formula leftMemLocation = CtoFormulaConverter.this.makeConstant(leftMemLocationName, this.ssa);
                List pVarNames = CtoFormulaConverter.getAllPointerVariablesFromSsaMap(this.ssa);
                Formula newLeftVar = leftVariable;
                for (String pVarName : pVarNames) {
                    String varName = CtoFormulaConverter.removePointerMask(pVarName);
                    if (varName.equals(leftVarName)) continue;
                    Formula var = CtoFormulaConverter.this.makeVariable(varName, this.ssa);
                    Formula oldPVar = CtoFormulaConverter.this.makeVariable(pVarName, this.ssa);
                    CtoFormulaConverter.this.makeFreshIndex(pVarName, this.ssa);
                    Formula newPVar = CtoFormulaConverter.this.makeVariable(pVarName, this.ssa);
                    Formula condition = CtoFormulaConverter.this.fmgr.makeEqual(var, leftMemLocation);
                    Formula equivalence = CtoFormulaConverter.this.fmgr.makeAssignment(newPVar, newLeftVar);
                    Formula update = CtoFormulaConverter.this.fmgr.makeAssignment(newPVar, oldPVar);
                    Formula constraint = CtoFormulaConverter.this.fmgr.makeIfThenElse(condition, equivalence, update);
                    this.constraints.addConstraint(constraint);
                }
            }
            return assignmentFormula;
        }

        private boolean isKnownMemoryLocation(String varName) {
            assert (varName != null);
            List memLocations = CtoFormulaConverter.getAllMemoryLocationsFromSsaMap(this.ssa);
            String memVarName = CtoFormulaConverter.this.makeMemoryLocationVariableName(varName);
            return memLocations.contains(memVarName);
        }

        private String makeFreshMallocVariableName() {
            int idx = this.ssa.getIndex(CtoFormulaConverter.MALLOC_COUNTER_VARIABLE_NAME);
            if (idx == -1) {
                idx = 2;
            }
            this.ssa.setIndex(CtoFormulaConverter.MALLOC_COUNTER_VARIABLE_NAME, idx + 1);
            return CtoFormulaConverter.MALLOC_VARIABLE_PREFIX + idx;
        }

        private String getVariableNameFromMemoryAddress(String memoryAddress) {
            assert (memoryAddress.startsWith(CtoFormulaConverter.MEMORY_ADDRESS_VARIABLE_PREFIX));
            return memoryAddress.substring(CtoFormulaConverter.MEMORY_ADDRESS_VARIABLE_PREFIX.length());
        }
    }

    private class StatementToFormulaVisitor
    extends RightHandSideToFormulaVisitor
    implements StatementVisitor<Formula, UnrecognizedCCodeException> {
        public StatementToFormulaVisitor(String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pConstraints, CFAEdge edge) {
            super(pFunction, pSsa, pConstraints, edge);
        }

        @Override
        public Formula visit(IASTExpressionStatement pIastExpressionStatement) {
            return CtoFormulaConverter.this.fmgr.makeTrue();
        }

        public Formula visit(IASTAssignment assignment) throws UnrecognizedCCodeException {
            Formula rightVariable = assignment.getRightHandSide().accept(this);
            Formula r = CtoFormulaConverter.this.toNumericFormula(rightVariable);
            Formula l = CtoFormulaConverter.this.buildLvalueTerm(assignment.getLeftHandSide(), this.edge, this.function, this.ssa, this.constraints);
            return CtoFormulaConverter.this.fmgr.makeAssignment(l, r);
        }

        @Override
        public Formula visit(IASTExpressionAssignmentStatement pIastExpressionAssignmentStatement) throws UnrecognizedCCodeException {
            return this.visit((IASTAssignment)pIastExpressionAssignmentStatement);
        }

        @Override
        public Formula visit(IASTFunctionCallAssignmentStatement pIastFunctionCallAssignmentStatement) throws UnrecognizedCCodeException {
            return this.visit((IASTAssignment)pIastFunctionCallAssignmentStatement);
        }

        @Override
        public Formula visit(IASTFunctionCallStatement fexp) throws UnrecognizedCCodeException {
            this.visit(fexp.getFunctionCallExpression());
            return CtoFormulaConverter.this.fmgr.makeTrue();
        }
    }

    private class RightHandSideToFormulaVisitor
    extends ForwardingExpressionVisitor<Formula, UnrecognizedCCodeException>
    implements RightHandSideVisitor<Formula, UnrecognizedCCodeException> {
        protected final CFAEdge edge;
        protected final String function;
        protected final SSAMap.SSAMapBuilder ssa;
        protected final Constraints constraints;

        public RightHandSideToFormulaVisitor(String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo, CFAEdge pEdge) {
            super(CtoFormulaConverter.this.getExpressionVisitor(pEdge, pFunction, pSsa, pCo));
            this.edge = pEdge;
            this.function = pFunction;
            this.ssa = pSsa;
            this.constraints = pCo;
        }

        @Override
        public Formula visit(IASTFunctionCallExpression fexp) throws UnrecognizedCCodeException {
            String func;
            IASTExpression fn = fexp.getFunctionNameExpression();
            List<IASTExpression> pexps = fexp.getParameterExpressions();
            if (fn instanceof IASTIdExpression) {
                func = ((IASTIdExpression)fn).getName();
                if (CtoFormulaConverter.this.nondetFunctions.contains(func)) {
                    return CtoFormulaConverter.this.makeFreshVariable(func, this.ssa);
                }
                if (UNSUPPORTED_FUNCTIONS.containsKey(func)) {
                    throw new UnsupportedCCodeException((String)UNSUPPORTED_FUNCTIONS.get(func), this.edge, fexp);
                }
                if (!PURE_EXTERNAL_FUNCTIONS.contains(func)) {
                    if (pexps.isEmpty()) {
                        CtoFormulaConverter.this.log(Level.INFO, "Assuming external function " + func + " to be a constant function.");
                    } else {
                        CtoFormulaConverter.this.log(Level.INFO, "Assuming external function " + func + " to be a pure function.");
                    }
                }
            } else {
                CtoFormulaConverter.this.log(Level.WARNING, CtoFormulaConverter.this.getLogMessage("Ignoring function call through function pointer", fexp));
                func = "<func>{" + fn.toASTString() + "}";
            }
            if (pexps.isEmpty()) {
                return CtoFormulaConverter.this.makeConstant(func, this.ssa);
            }
            func = func + "{" + pexps.size() + "}";
            ArrayList<Formula> args = new ArrayList<Formula>(pexps.size());
            for (IASTExpression pexp : pexps) {
                args.add(CtoFormulaConverter.this.toNumericFormula(((IASTRightHandSide)pexp).accept(this)));
            }
            return CtoFormulaConverter.this.fmgr.makeUIF(func, CtoFormulaConverter.this.fmgr.makeList(args));
        }
    }

    private class ExpressionToFormulaVisitorPointers
    extends ExpressionToFormulaVisitor {
        public ExpressionToFormulaVisitorPointers(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo) {
            super(pEdge, pFunction, pSsa, pCo);
        }

        @Override
        public Formula visit(IASTUnaryExpression exp) throws UnrecognizedCCodeException {
            IASTExpression opExp = CtoFormulaConverter.removeCast(exp.getOperand());
            IASTUnaryExpression.UnaryOperator op = exp.getOperator();
            switch (op) {
                case AMPER: {
                    return this.makeAddressVariable(exp, this.function);
                }
                case STAR: {
                    if (!(opExp instanceof IASTIdExpression)) break;
                    return CtoFormulaConverter.this.makePointerVariable((IASTIdExpression)opExp, this.function, this.ssa);
                }
            }
            return super.visit(exp);
        }

        private Formula makeAddressVariable(IASTUnaryExpression exp, String function) throws UnrecognizedCCodeException {
            IASTExpression operand = CtoFormulaConverter.removeCast(exp.getOperand());
            IASTUnaryExpression.UnaryOperator op = exp.getOperator();
            if (op != IASTUnaryExpression.UnaryOperator.AMPER || !(operand instanceof IASTIdExpression)) {
                return super.visitDefault(exp);
            }
            return this.makeMemoryLocationVariable((IASTIdExpression)operand, function);
        }

        private Formula makeMemoryLocationVariable(IASTIdExpression exp, String function) {
            String addressVariable = CtoFormulaConverter.this.makeMemoryLocationVariableName(CtoFormulaConverter.this.scopedIfNecessary(exp, function));
            if (this.ssa.getIndex(addressVariable) == -1) {
                List oldMemoryLocations = CtoFormulaConverter.getAllMemoryLocationsFromSsaMap(this.ssa);
                Formula newMemoryLocation = CtoFormulaConverter.this.makeConstant(addressVariable, this.ssa);
                for (String memoryLocation : oldMemoryLocations) {
                    Formula oldMemoryLocation = CtoFormulaConverter.this.makeConstant(memoryLocation, this.ssa);
                    Formula addressInequality = CtoFormulaConverter.this.fmgr.makeNot(CtoFormulaConverter.this.fmgr.makeEqual(newMemoryLocation, oldMemoryLocation));
                    this.constraints.addConstraint(addressInequality);
                }
                Formula notZero = CtoFormulaConverter.this.fmgr.makeNotEqual(newMemoryLocation, CtoFormulaConverter.this.fmgr.makeNumber(0));
                this.constraints.addConstraint(notZero);
            }
            return CtoFormulaConverter.this.makeConstant(addressVariable, this.ssa);
        }
    }

    private class ExpressionToFormulaVisitorUIF
    extends ExpressionToFormulaVisitor {
        public ExpressionToFormulaVisitorUIF(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo) {
            super(pEdge, pFunction, pSsa, pCo);
        }

        private Formula makeUIF(String name, FormulaList args, SSAMap.SSAMapBuilder ssa) {
            int idx = ssa.getIndex(name, args);
            if (idx <= 0) {
                CtoFormulaConverter.this.logger.log(Level.ALL, new Object[]{"DEBUG_3", "WARNING: Auto-instantiating lval: ", name, "(", args, ")"});
                idx = 1;
                ssa.setIndex(name, args, idx);
            }
            return CtoFormulaConverter.this.fmgr.makeUIF(name, args, idx);
        }

        @Override
        public Formula visit(IASTArraySubscriptExpression aexp) throws UnrecognizedCCodeException {
            IASTExpression arrexp = aexp.getArrayExpression();
            IASTExpression subexp = aexp.getSubscriptExpression();
            Formula aterm = CtoFormulaConverter.this.toNumericFormula(arrexp.accept(this));
            Formula sterm = CtoFormulaConverter.this.toNumericFormula(subexp.accept(this));
            String ufname = CtoFormulaConverter.OP_ARRAY_SUBSCRIPT;
            return this.makeUIF(ufname, CtoFormulaConverter.this.fmgr.makeList(aterm, sterm), this.ssa);
        }

        @Override
        public Formula visit(IASTFieldReference fexp) throws UnrecognizedCCodeException {
            String field = fexp.getFieldName();
            IASTExpression owner = fexp.getFieldOwner();
            Formula term = CtoFormulaConverter.this.toNumericFormula(owner.accept(this));
            String tpname = CtoFormulaConverter.this.getTypeName(owner.getExpressionType());
            String ufname = (fexp.isPointerDereference() ? "->{" : ".{") + tpname + "," + field + "}";
            return this.makeUIF(ufname, CtoFormulaConverter.this.fmgr.makeList(term), this.ssa);
        }

        @Override
        public Formula visit(IASTUnaryExpression exp) throws UnrecognizedCCodeException {
            IASTUnaryExpression.UnaryOperator op = exp.getOperator();
            switch (op) {
                case AMPER: 
                case STAR: {
                    String opname = op == IASTUnaryExpression.UnaryOperator.AMPER ? CtoFormulaConverter.OP_ADDRESSOF_NAME : CtoFormulaConverter.OP_STAR_NAME;
                    Formula term = CtoFormulaConverter.this.toNumericFormula(exp.getOperand().accept(this));
                    int idx = CtoFormulaConverter.this.getIndex(opname, this.ssa);
                    return CtoFormulaConverter.this.fmgr.makeUIF(opname, CtoFormulaConverter.this.fmgr.makeList(term), idx);
                }
            }
            return super.visit(exp);
        }
    }

    private class ExpressionToFormulaVisitor
    extends DefaultExpressionVisitor<Formula, UnrecognizedCCodeException> {
        protected final CFAEdge edge;
        protected final String function;
        protected final SSAMap.SSAMapBuilder ssa;
        protected final Constraints constraints;

        public ExpressionToFormulaVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pCo) {
            this.edge = pEdge;
            this.function = pFunction;
            this.ssa = pSsa;
            this.constraints = pCo;
        }

        @Override
        protected Formula visitDefault(IASTExpression exp) throws UnrecognizedCCodeException {
            CtoFormulaConverter.this.warnUnsafeVar(exp);
            return CtoFormulaConverter.this.makeVariable(CtoFormulaConverter.scoped(CtoFormulaConverter.exprToVarName(exp), this.function), this.ssa);
        }

        @Override
        public Formula visit(IASTBinaryExpression exp) throws UnrecognizedCCodeException {
            IASTBinaryExpression.BinaryOperator op = exp.getOperator();
            IASTExpression e1 = exp.getOperand1();
            IASTExpression e2 = exp.getOperand2();
            switch (op) {
                case LOGICAL_AND: 
                case LOGICAL_OR: {
                    Formula me1 = CtoFormulaConverter.this.toBooleanFormula(e1.accept(this));
                    Formula me2 = CtoFormulaConverter.this.toBooleanFormula(e2.accept(this));
                    switch (op) {
                        case LOGICAL_AND: {
                            return CtoFormulaConverter.this.fmgr.makeAnd(me1, me2);
                        }
                        case LOGICAL_OR: {
                            return CtoFormulaConverter.this.fmgr.makeOr(me1, me2);
                        }
                    }
                    throw new AssertionError();
                }
            }
            Formula me1 = CtoFormulaConverter.this.toNumericFormula(e1.accept(this));
            Formula me2 = CtoFormulaConverter.this.toNumericFormula(e2.accept(this));
            switch (op) {
                case PLUS: {
                    return CtoFormulaConverter.this.fmgr.makePlus(me1, me2);
                }
                case MINUS: {
                    return CtoFormulaConverter.this.fmgr.makeMinus(me1, me2);
                }
                case MULTIPLY: {
                    return CtoFormulaConverter.this.fmgr.makeMultiply(me1, me2);
                }
                case DIVIDE: {
                    return CtoFormulaConverter.this.fmgr.makeDivide(me1, me2);
                }
                case MODULO: {
                    return CtoFormulaConverter.this.fmgr.makeModulo(me1, me2);
                }
                case BINARY_AND: {
                    return CtoFormulaConverter.this.fmgr.makeBitwiseAnd(me1, me2);
                }
                case BINARY_OR: {
                    return CtoFormulaConverter.this.fmgr.makeBitwiseOr(me1, me2);
                }
                case BINARY_XOR: {
                    return CtoFormulaConverter.this.fmgr.makeBitwiseXor(me1, me2);
                }
                case SHIFT_LEFT: {
                    return CtoFormulaConverter.this.fmgr.makeShiftLeft(me1, me2);
                }
                case SHIFT_RIGHT: {
                    return CtoFormulaConverter.this.fmgr.makeShiftRight(me1, me2);
                }
                case GREATER_THAN: {
                    return CtoFormulaConverter.this.fmgr.makeGt(me1, me2);
                }
                case GREATER_EQUAL: {
                    return CtoFormulaConverter.this.fmgr.makeGeq(me1, me2);
                }
                case LESS_THAN: {
                    return CtoFormulaConverter.this.fmgr.makeLt(me1, me2);
                }
                case LESS_EQUAL: {
                    return CtoFormulaConverter.this.fmgr.makeLeq(me1, me2);
                }
                case EQUALS: {
                    return CtoFormulaConverter.this.fmgr.makeEqual(me1, me2);
                }
                case NOT_EQUALS: {
                    return CtoFormulaConverter.this.fmgr.makeNot(CtoFormulaConverter.this.fmgr.makeEqual(me1, me2));
                }
            }
            throw new UnrecognizedCCodeException("Unknown binary operator", this.edge, exp);
        }

        @Override
        public Formula visit(IASTCastExpression cexp) throws UnrecognizedCCodeException {
            CtoFormulaConverter.this.logDebug("IGNORING TYPE CAST:", cexp);
            return cexp.getOperand().accept(this);
        }

        @Override
        public Formula visit(IASTIdExpression idExp) {
            if (idExp.getDeclaration() instanceof IASTEnumerationSpecifier.IASTEnumerator) {
                IASTEnumerationSpecifier.IASTEnumerator enumerator = (IASTEnumerationSpecifier.IASTEnumerator)idExp.getDeclaration();
                if (enumerator.hasValue()) {
                    return CtoFormulaConverter.this.fmgr.makeNumber(Long.toString(enumerator.getValue()));
                }
                return CtoFormulaConverter.this.makeConstant(enumerator.getName(), this.ssa);
            }
            return CtoFormulaConverter.this.makeVariable(CtoFormulaConverter.this.scopedIfNecessary(idExp, this.function), this.ssa);
        }

        @Override
        public Formula visit(IASTFieldReference fExp) throws UnrecognizedCCodeException {
            IASTSimpleDeclaration decl;
            IASTExpression fieldRef = fExp.getFieldOwner();
            if (fieldRef instanceof IASTIdExpression && (decl = ((IASTIdExpression)fieldRef).getDeclaration()) instanceof IASTDeclaration && ((IASTDeclaration)decl).isGlobal()) {
                return CtoFormulaConverter.this.makeVariable(CtoFormulaConverter.exprToVarName(fExp), this.ssa);
            }
            return (Formula)super.visit(fExp);
        }

        @Override
        public Formula visit(IASTCharLiteralExpression cExp) throws UnrecognizedCCodeException {
            return CtoFormulaConverter.this.fmgr.makeNumber(cExp.getCharacter());
        }

        @Override
        public Formula visit(IASTIntegerLiteralExpression iExp) throws UnrecognizedCCodeException {
            return CtoFormulaConverter.this.fmgr.makeNumber(iExp.getValue().toString());
        }

        @Override
        public Formula visit(IASTFloatLiteralExpression fExp) throws UnrecognizedCCodeException {
            return CtoFormulaConverter.this.fmgr.makeNumber(fExp.getValue().toString());
        }

        @Override
        public Formula visit(IASTStringLiteralExpression lexp) throws UnrecognizedCCodeException {
            String literal = lexp.getValue();
            Formula result = (Formula)CtoFormulaConverter.this.stringLitToFormula.get(literal);
            if (result == null) {
                int n = CtoFormulaConverter.this.nextStringLitIndex++;
                result = CtoFormulaConverter.this.fmgr.makeString(n);
                CtoFormulaConverter.this.stringLitToFormula.put(literal, result);
            }
            return result;
        }

        @Override
        public Formula visit(IASTUnaryExpression exp) throws UnrecognizedCCodeException {
            IASTExpression operand = exp.getOperand();
            IASTUnaryExpression.UnaryOperator op = exp.getOperator();
            switch (op) {
                case MINUS: {
                    Formula term = CtoFormulaConverter.this.toNumericFormula(operand.accept(this));
                    return CtoFormulaConverter.this.fmgr.makeNegate(term);
                }
                case TILDE: {
                    Formula term = CtoFormulaConverter.this.toNumericFormula(operand.accept(this));
                    return CtoFormulaConverter.this.fmgr.makeBitwiseNot(term);
                }
                case NOT: {
                    Formula term = CtoFormulaConverter.this.toBooleanFormula(operand.accept(this));
                    return CtoFormulaConverter.this.fmgr.makeNot(term);
                }
                case AMPER: 
                case STAR: {
                    return this.visitDefault(exp);
                }
                case SIZEOF: {
                    if (exp.getOperand() instanceof IASTIdExpression) {
                        IType lIType = ((IASTIdExpression)exp.getOperand()).getExpressionType();
                        return this.handleSizeof(exp, lIType);
                    }
                    return this.visitDefault(exp);
                }
            }
            throw new UnrecognizedCCodeException("Unknown unary operator", this.edge, exp);
        }

        @Override
        public Formula visit(IASTTypeIdExpression tIdExp) throws UnrecognizedCCodeException {
            if (tIdExp.getOperator() == IASTTypeIdExpression.TypeIdOperator.SIZEOF) {
                IType lIType = tIdExp.getType();
                return this.handleSizeof(tIdExp, lIType);
            }
            return this.visitDefault(tIdExp);
        }

        private Formula handleSizeof(IASTExpression pExp, IType pIType) throws UnrecognizedCCodeException {
            if (pIType instanceof IASTSimpleDeclSpecifier) {
                return CtoFormulaConverter.this.fmgr.makeNumber(CtoFormulaConverter.this.machineModel.getSizeof((IASTSimpleDeclSpecifier)pIType));
            }
            return this.visitDefault(pExp);
        }
    }

    private class Constraints {
        private Formula constraints;

        private Constraints() {
            this.constraints = CtoFormulaConverter.this.fmgr.makeTrue();
        }

        private void addConstraint(Formula pCo) {
            this.constraints = CtoFormulaConverter.this.fmgr.makeAnd(this.constraints, pCo);
        }

        public Formula get() {
            return this.constraints;
        }
    }
}

