/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.ForwardingFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

@Options(prefix="cpa.predicate")
public final class ExtendedFormulaManager
extends ForwardingFormulaManager {
    @Option(name="formulaDumpFilePattern", description="where to dump interpolation and abstraction problems (format string)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File formulaDumpFile = new File("%s%04d-%s%03d.msat");
    private final String formulaDumpFilePattern;
    @Option(description="try to add some useful static-learning-like axioms for bitwise operations (which are encoded as UFs): essentially, we simply collect all the numbers used in bitwise operations, and add axioms like (0 & n = 0)")
    private boolean useBitwiseAxioms = false;
    private final LogManager logger;
    private static final Joiner LINE_JOINER = Joiner.on((char)'\n');

    public ExtendedFormulaManager(FormulaManager pFmgr, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        super(pFmgr);
        config.inject((Object)this, ExtendedFormulaManager.class);
        this.logger = pLogger;
        this.formulaDumpFilePattern = this.formulaDumpFile != null ? this.formulaDumpFile.getAbsolutePath() : null;
    }

    @Override
    public FormulaManager getDelegate() {
        return super.getDelegate();
    }

    public boolean useBitwiseAxioms() {
        return this.useBitwiseAxioms;
    }

    public Formula makeConjunction(List<Formula> f) {
        Formula result = this.makeTrue();
        for (Formula formula : f) {
            result = this.makeAnd(result, formula);
        }
        return result;
    }

    public Formula makeImplication(Formula p, Formula q) {
        Formula left = this.makeNot(p);
        return this.makeOr(left, q);
    }

    public Formula makeNotEqual(Formula f1, Formula f2) {
        return this.makeNot(this.makeEqual(f1, f2));
    }

    public File formatFormulaOutputFile(String function, int call, String formula, int index) {
        if (this.formulaDumpFilePattern == null) {
            return null;
        }
        return new File(String.format(this.formulaDumpFilePattern, function, call, formula, index));
    }

    public void dumpFormulaToFile(Formula f, File outputFile) {
        if (outputFile != null) {
            try {
                Files.writeFile((File)outputFile, (Object)this.dumpFormula(f));
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Failed to save formula to file");
            }
        }
    }

    public void printFormulasToFile(Iterable<Formula> f, File outputFile) {
        if (outputFile != null) {
            try {
                Files.writeFile((File)outputFile, (Object)LINE_JOINER.join(f));
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Failed to save formula to file");
            }
        }
    }
}

