/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingTheoremProver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat.ArithmeticMathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.BitwiseMathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatInterpolatingProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatTheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat.YicesTheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.ArithmeticMathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.BitwiseMathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5InterpolatingProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5TheoremProver;

@Options(prefix="cpa.predicate")
public class FormulaManagerFactory {
    @Option(values={"MATHSAT4", "MATHSAT5", "YICES"}, toUppercase=true, description="Whether to use MathSAT 4, MathSAT 5 or YICES (in combination with Mathsat 4) as SMT solver")
    private String solver = "MATHSAT4";
    private final FormulaManager fmgr;
    private final TheoremProver prover;

    public FormulaManagerFactory(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        MathsatOptions options = new MathsatOptions();
        config.inject((Object)options);
        if (options.useBitwise && options.useIntegers) {
            throw new InvalidConfigurationException("Can use either integers or bitvecors, not both!");
        }
        if (this.solver.equals("MATHSAT5")) {
            try {
                this.fmgr = options.useBitwise ? new BitwiseMathsat5FormulaManager(config, logger, options.bitWidth) : new ArithmeticMathsat5FormulaManager(config, logger, options.useIntegers);
            }
            catch (UnsatisfiedLinkError e) {
                if (e.getMessage() != null && e.getMessage().contains("mathsat5j")) {
                    throw new InvalidConfigurationException("MathSAT 5 is not supported on your platform, please use another SMT solver.", (Throwable)e);
                }
                throw e;
            }
            this.prover = new Mathsat5TheoremProver((Mathsat5FormulaManager)this.fmgr);
        } else {
            assert (this.solver.equals("MATHSAT4") || this.solver.equals("YICES"));
            try {
                this.fmgr = options.useBitwise ? new BitwiseMathsatFormulaManager(config, logger, options.bitWidth) : new ArithmeticMathsatFormulaManager(config, logger, options.useIntegers);
            }
            catch (UnsatisfiedLinkError e) {
                if (e.getMessage() != null && e.getMessage().contains("mathsatj")) {
                    throw new InvalidConfigurationException("MathSAT 4 is not supported on your platform, please use another SMT solver.", (Throwable)e);
                }
                throw e;
            }
            if (this.solver.equals("YICES")) {
                try {
                    this.prover = new YicesTheoremProver((MathsatFormulaManager)this.fmgr, logger);
                }
                catch (UnsatisfiedLinkError e) {
                    if (e.getMessage() != null && e.getMessage().contains("YicesLite")) {
                        throw new InvalidConfigurationException("In order to use the Yices SMT solver, you need to install the library YicesLite.", (Throwable)e);
                    }
                    throw e;
                }
            } else {
                assert (this.solver.equals("MATHSAT4"));
                this.prover = new MathsatTheoremProver((MathsatFormulaManager)this.fmgr);
            }
        }
    }

    public FormulaManager getFormulaManager() {
        return this.fmgr;
    }

    public TheoremProver createTheoremProver() {
        return this.prover;
    }

    public InterpolatingTheoremProver<?> createInterpolatingTheoremProver(boolean shared) {
        if (this.solver.equals("MATHSAT5")) {
            return new Mathsat5InterpolatingProver((Mathsat5FormulaManager)this.fmgr, shared);
        }
        assert (this.solver.equals("MATHSAT4") || this.solver.equals("YICES"));
        return new MathsatInterpolatingProver((MathsatFormulaManager)this.fmgr, shared);
    }

    @Options(prefix="cpa.predicate.mathsat")
    private static class MathsatOptions {
        @Option(description="encode program variables as INTEGERs in MathSAT, instead of using REALs. Since interpolation is not really supported by the laz solver, when computing interpolants we still use the LA solver, but encoding variables as ints might still be a good idea: we can tighten strict inequalities, and split negated equalities")
        private boolean useIntegers = false;
        @Option(description="Encode program variables of bitvectors of a fixed size,instead of using REALS. No interpolation and thus no refinement issupported in this case.")
        private boolean useBitwise = false;
        @Option(description="With of the bitvectors if useBitwise is true.")
        @IntegerOption(min=1L, max=128L)
        private int bitWidth = 32;

        private MathsatOptions() {
        }
    }
}

