/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Joiner;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class Model
extends ForwardingMap<AssignableTerm, Object> {
    private final Map<AssignableTerm, Object> mModel;
    private final Formula formulaRepresentation;
    private static final Joiner.MapJoiner joiner = Joiner.on((char)'\n').withKeyValueSeparator(": ");

    protected Map<AssignableTerm, Object> delegate() {
        return this.mModel;
    }

    public Model(FormulaManager fmgr) {
        this.mModel = ImmutableMap.of();
        this.formulaRepresentation = fmgr.makeTrue();
    }

    public Model(Map<AssignableTerm, Object> content, Formula f) {
        this.mModel = ImmutableMap.copyOf(content);
        this.formulaRepresentation = f;
    }

    public Formula getFormulaRepresentation() {
        return this.formulaRepresentation;
    }

    public String toString() {
        return joiner.join(this.mModel);
    }

    public static class Function
    implements AssignableTerm {
        private final String mName;
        private final TermType mReturnType;
        private final List<Object> mArguments;
        private int mHashCode;

        public Function(String pName, TermType pReturnType, Object[] pArguments) {
            this.mName = pName;
            this.mReturnType = pReturnType;
            this.mArguments = ImmutableList.copyOf((Object[])pArguments);
            this.mHashCode = 32453 + this.mName.hashCode() + this.mReturnType.hashCode();
            for (Object lValue : this.mArguments) {
                this.mHashCode += lValue.hashCode();
            }
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public TermType getType() {
            return this.mReturnType;
        }

        public int getArity() {
            return this.mArguments.size();
        }

        public Object getArgument(int lArgumentIndex) {
            return this.mArguments.get(lArgumentIndex);
        }

        public String toString() {
            return this.mName + "(" + Joiner.on((char)',').join(this.mArguments) + ") : " + (Object)((Object)this.mReturnType);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther == null) {
                return false;
            }
            if (!this.getClass().equals(pOther.getClass())) {
                return false;
            }
            Function lFunction = (Function)pOther;
            return lFunction.mName.equals(this.mName) && lFunction.mReturnType.equals((Object)this.mReturnType) && ((Object)lFunction.mArguments).equals(this.mArguments);
        }
    }

    public static class Variable
    implements AssignableTerm {
        private final String mName;
        private final int mSSAIndex;
        private final TermType mType;

        public Variable(String pName, int pSSAIndex, TermType pType) {
            this.mName = pName;
            this.mSSAIndex = pSSAIndex;
            this.mType = pType;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public TermType getType() {
            return this.mType;
        }

        public int getSSAIndex() {
            return this.mSSAIndex;
        }

        public String toString() {
            return this.mName + "@" + this.mSSAIndex + " : " + (Object)((Object)this.mType);
        }

        public int hashCode() {
            return 324 + this.mName.hashCode() + this.mSSAIndex + this.mType.hashCode();
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther == null) {
                return false;
            }
            if (!this.getClass().equals(pOther.getClass())) {
                return false;
            }
            Variable lVariable = (Variable)pOther;
            return this.mName.equals(lVariable.mName) && this.mSSAIndex == lVariable.mSSAIndex && this.mType.equals((Object)lVariable.mType);
        }
    }

    public static interface AssignableTerm {
        public TermType getType();

        public String getName();
    }

    public static enum TermType {
        Boolean,
        Uninterpreted,
        Integer,
        Real,
        Bitvector;

    }
}

