/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

public class NamedRegionManager
implements RegionManager {
    private final RegionManager delegate;
    private final BiMap<String, Region> regionMap = HashBiMap.create();
    private static final String ANONYMOUS_PREDICATE = "__anon_pred";
    private int anonymousPredicateCounter = 0;

    public NamedRegionManager(RegionManager pDelegate) {
        this.delegate = (RegionManager)Preconditions.checkNotNull((Object)pDelegate);
    }

    public Region createPredicate(String pName) {
        Region result = (Region)this.regionMap.get((Object)pName);
        if (result == null) {
            result = this.delegate.createPredicate();
            this.regionMap.put((Object)pName, (Object)result);
        }
        return result;
    }

    @Override
    public Region createPredicate() {
        return this.createPredicate(ANONYMOUS_PREDICATE + this.anonymousPredicateCounter++);
    }

    public String dumpRegion(Region r) {
        if (this.regionMap.containsValue((Object)r)) {
            return (String)this.regionMap.inverse().get((Object)r);
        }
        if (r.isFalse()) {
            return "FALSE";
        }
        if (r.isTrue()) {
            return "TRUE";
        }
        Triple<Region, Region, Region> triple = this.delegate.getIfThenElse(r);
        String predName = (String)this.regionMap.inverse().get(triple.getFirst());
        Region trueBranch = (Region)triple.getSecond();
        String ifTrue = "";
        if (!trueBranch.isFalse()) {
            ifTrue = trueBranch.isTrue() ? predName : predName + " & " + this.dumpRegion(trueBranch);
        }
        Region falseBranch = (Region)triple.getThird();
        String ifFalse = "";
        if (!falseBranch.isFalse()) {
            ifFalse = falseBranch.isTrue() ? "!" + predName : "!" + predName + " & " + this.dumpRegion(falseBranch);
        }
        if (!ifTrue.isEmpty() && !ifFalse.isEmpty()) {
            return "((" + ifTrue + ") | (" + ifFalse + "))";
        }
        if (ifTrue.isEmpty()) {
            return ifFalse;
        }
        if (ifFalse.isEmpty()) {
            return ifTrue;
        }
        throw new AssertionError((Object)"Both BDD Branches are empty!?");
    }

    @Override
    public boolean entails(Region pF1, Region pF2) {
        return this.delegate.entails(pF1, pF2);
    }

    @Override
    public Region makeTrue() {
        return this.delegate.makeTrue();
    }

    @Override
    public Region makeFalse() {
        return this.delegate.makeFalse();
    }

    @Override
    public Region makeNot(Region pF) {
        return this.delegate.makeNot(pF);
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        return this.delegate.makeAnd(pF1, pF2);
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        return this.delegate.makeOr(pF1, pF2);
    }

    @Override
    public Region makeExists(Region pF1, Region pF2) {
        return this.delegate.makeExists(pF1, pF2);
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        return this.delegate.getIfThenElse(pF);
    }
}

