/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.impact.ImpactAbstractElement;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractElement;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.predicates.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;

public class PathFormulaManagerImpl
extends CtoFormulaConverter
implements PathFormulaManager {
    private static final String BRANCHING_PREDICATE_NAME = "__ART__";
    private static final Pattern BRANCHING_PREDICATE_NAME_PATTERN = Pattern.compile("^.*__ART__(?=\\d+$)");

    public PathFormulaManagerImpl(ExtendedFormulaManager pFmgr, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        super(config, pFmgr, pLogger);
    }

    @Override
    public PathFormula makeEmptyPathFormula() {
        return new PathFormula(this.fmgr.makeTrue(), SSAMap.emptySSAMap(), 0);
    }

    @Override
    public PathFormula makeEmptyPathFormula(PathFormula oldFormula) {
        return new PathFormula(this.fmgr.makeTrue(), oldFormula.getSsa(), 0);
    }

    @Override
    public PathFormula makeNewPathFormula(PathFormula oldFormula, SSAMap m) {
        return new PathFormula(oldFormula.getFormula(), m, oldFormula.getLength());
    }

    @Override
    public PathFormula makeOr(PathFormula pF1, PathFormula pF2) {
        Formula formula1 = pF1.getFormula();
        Formula formula2 = pF2.getFormula();
        SSAMap ssa1 = pF1.getSsa();
        SSAMap ssa2 = pF2.getSsa();
        Pair<Pair<Formula, Formula>, SSAMap> pm = this.mergeSSAMaps(ssa2, ssa1);
        Formula newFormula2 = this.fmgr.makeAnd(formula2, (Formula)((Pair)pm.getFirst()).getFirst());
        Formula newFormula1 = this.fmgr.makeAnd(formula1, (Formula)((Pair)pm.getFirst()).getSecond());
        Formula newFormula = this.fmgr.makeOr(newFormula1, newFormula2);
        SSAMap newSsa = (SSAMap)pm.getSecond();
        int newLength = Math.max(pF1.getLength(), pF2.getLength());
        return new PathFormula(newFormula, newSsa, newLength);
    }

    @Override
    public PathFormula makeAnd(PathFormula pPathFormula, Formula pOtherFormula) {
        SSAMap ssa = pPathFormula.getSsa();
        Formula otherFormula = this.fmgr.instantiate(pOtherFormula, ssa);
        Formula resultFormula = this.fmgr.makeAnd(pPathFormula.getFormula(), otherFormula);
        return new PathFormula(resultFormula, ssa, pPathFormula.getLength());
    }

    private Pair<Pair<Formula, Formula>, SSAMap> mergeSSAMaps(SSAMap ssa1, SSAMap ssa2) {
        SSAMap result = SSAMap.merge(ssa1, ssa2);
        Formula mt1 = this.fmgr.makeTrue();
        Formula mt2 = this.fmgr.makeTrue();
        for (String string : result.allVariables()) {
            Formula t;
            int i2;
            if (string.equals("__nondet__")) continue;
            int i1 = ssa1.getIndex(string);
            if (i1 > (i2 = ssa2.getIndex(string)) && i1 > 1) {
                t = this.useNondetFlags && string.equals("__nondet__flag__") ? this.makeNondetFlagMerger(Math.max(i2, 1), i1) : this.makeSSAMerger(string, Math.max(i2, 1), i1);
                mt2 = this.fmgr.makeAnd(mt2, t);
                continue;
            }
            if (i1 >= i2 || i2 <= 1) continue;
            t = this.useNondetFlags && string.equals("__nondet__flag__") ? this.makeNondetFlagMerger(Math.max(i1, 1), i2) : this.makeSSAMerger(string, Math.max(i1, 1), i2);
            mt1 = this.fmgr.makeAnd(mt1, t);
        }
        for (Pair pair : result.allFunctions()) {
            Formula t;
            int i2;
            String name = (String)pair.getFirst();
            FormulaList args = (FormulaList)pair.getSecond();
            int i1 = ssa1.getIndex((Pair<String, FormulaList>)pair);
            if (i1 > (i2 = ssa2.getIndex((Pair<String, FormulaList>)pair)) && i1 > 1) {
                t = this.makeSSAMerger(name, args, Math.max(i2, 1), i1);
                mt2 = this.fmgr.makeAnd(mt2, t);
                continue;
            }
            if (i1 >= i2 || i2 <= 1) continue;
            t = this.makeSSAMerger(name, args, Math.max(i1, 1), i2);
            mt1 = this.fmgr.makeAnd(mt1, t);
        }
        return Pair.of((Object)Pair.of((Object)mt1, (Object)mt2), (Object)result);
    }

    private Formula makeNondetFlagMerger(int iSmaller, int iBigger) {
        return this.makeMerger("__nondet__flag__", iSmaller, iBigger, this.fmgr.makeNumber(0));
    }

    private Formula makeMerger(String var, int iSmaller, int iBigger, Formula pInitialValue) {
        assert (iSmaller < iBigger);
        Formula lResult = this.fmgr.makeTrue();
        for (int i = iSmaller + 1; i <= iBigger; ++i) {
            Formula currentVar = this.fmgr.makeVariable(var, i);
            Formula e = this.fmgr.makeEqual(currentVar, pInitialValue);
            lResult = this.fmgr.makeAnd(lResult, e);
        }
        return lResult;
    }

    private Formula makeSSAMerger(String var, int iSmaller, int iBigger) {
        return this.makeMerger(var, iSmaller, iBigger, this.fmgr.makeVariable(var, iSmaller));
    }

    private Formula makeSSAMerger(String name, FormulaList args, int iSmaller, int iBigger) {
        assert (iSmaller < iBigger);
        Formula intialFunc = this.fmgr.makeUIF(name, args, iSmaller);
        Formula result = this.fmgr.makeTrue();
        for (int i = iSmaller + 1; i <= iBigger; ++i) {
            Formula currentFunc = this.fmgr.makeUIF(name, args, i);
            Formula e = this.fmgr.makeEqual(currentFunc, intialFunc);
            result = this.fmgr.makeAnd(result, e);
        }
        return result;
    }

    @Override
    public PathFormula makeFormulaForPath(List<CFAEdge> pPath) throws CPATransferException {
        PathFormula pathFormula = this.makeEmptyPathFormula();
        for (CFAEdge edge : pPath) {
            pathFormula = this.makeAnd(pathFormula, edge);
        }
        return pathFormula;
    }

    @Override
    public Formula buildBranchingFormula(Iterable<ARTElement> elementsOnPath) throws CPATransferException {
        Formula branchingFormula = this.fmgr.makeTrue();
        for (final ARTElement pathElement : elementsOnPath) {
            PathFormula pf;
            if (pathElement.getChildren().size() <= 1) continue;
            if (pathElement.getChildren().size() > 2) {
                this.logger.log(Level.WARNING, new Object[]{"ART branching with more than two outgoing edges"});
                return this.fmgr.makeTrue();
            }
            Iterable outgoingEdges = Iterables.transform(pathElement.getChildren(), (Function)new Function<ARTElement, CFAEdge>(){

                public CFAEdge apply(ARTElement child) {
                    return pathElement.getEdgeToChild(child);
                }
            });
            if (!Iterables.all((Iterable)outgoingEdges, (Predicate)Predicates.instanceOf(AssumeEdge.class))) {
                this.logger.log(Level.WARNING, new Object[]{"ART branching without AssumeEdge"});
                return this.fmgr.makeTrue();
            }
            AssumeEdge edge = null;
            for (CFAEdge currentEdge : outgoingEdges) {
                if (!((AssumeEdge)currentEdge).getTruthAssumption()) continue;
                edge = (AssumeEdge)currentEdge;
                break;
            }
            assert (edge != null);
            Formula pred = this.fmgr.makePredicateVariable(BRANCHING_PREDICATE_NAME + pathElement.getElementId(), 0);
            PredicateAbstractElement pe = AbstractElements.extractElementByType(pathElement, PredicateAbstractElement.class);
            if (pe == null) {
                ImpactAbstractElement ie = AbstractElements.extractElementByType(pathElement, ImpactAbstractElement.class);
                if (ie == null) {
                    this.logger.log(Level.WARNING, new Object[]{"Cannot find precise error path information without PredicateCPA or ImpactCPA"});
                    return this.fmgr.makeTrue();
                }
                pf = ie.getPathFormula();
            } else {
                pf = pe.getPathFormula();
            }
            pf = this.makeEmptyPathFormula(pf);
            pf = this.makeAnd(pf, edge);
            Formula equiv = this.fmgr.makeEquivalence(pred, pf.getFormula());
            branchingFormula = this.fmgr.makeAnd(branchingFormula, equiv);
        }
        return branchingFormula;
    }

    @Override
    public Map<Integer, Boolean> getBranchingPredicateValuesFromModel(Model model) {
        if (model.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"No satisfying assignment given by solver!"});
            return Collections.emptyMap();
        }
        HashMap preds = Maps.newHashMap();
        for (Model.AssignableTerm a : model.keySet()) {
            String name;
            if (!(a instanceof Model.Variable) || a.getType() != Model.TermType.Boolean || (name = BRANCHING_PREDICATE_NAME_PATTERN.matcher(a.getName()).replaceFirst("")).equals(a.getName())) continue;
            Integer nodeId = Integer.parseInt(name);
            assert (!preds.containsKey(nodeId));
            Boolean value = (Boolean)model.get(a);
            preds.put(nodeId, value);
        }
        return preds;
    }
}

