/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;

public class SSAMap
implements Serializable {
    private static final long serialVersionUID = 7618801653203679876L;
    private static final SSAMap EMPTY_SSA_MAP = new SSAMap((Multiset<String>)ImmutableMultiset.of(), (Multiset<Pair<String, FormulaList>>)ImmutableMultiset.of());
    private final Multiset<String> vars;
    private final Multiset<Pair<String, FormulaList>> funcs;
    private static final Joiner joiner = Joiner.on((String)" ");

    public static SSAMap emptySSAMap() {
        return EMPTY_SSA_MAP;
    }

    public SSAMap withDefault(final int defaultValue) {
        return new SSAMap(this.vars, this.funcs){
            private static final long serialVersionUID = -5638018887478723717L;

            @Override
            public int getIndex(String pVariable) {
                int result = super.getIndex(pVariable);
                return result < 0 ? defaultValue : result;
            }

            @Override
            public int getIndex(String pName, FormulaList pArgs) {
                int result = super.getIndex(pName, pArgs);
                return result < 0 ? defaultValue : result;
            }

            @Override
            protected int getIndex(Pair<String, FormulaList> pKey) {
                int result = super.getIndex(pKey);
                return result < 0 ? defaultValue : result;
            }
        };
    }

    public static SSAMap merge(SSAMap s1, SSAMap s2) {
        Multiset<String> vars;
        if (s1.vars == s2.vars) {
            if (s1.funcs == s2.funcs) {
                return s1;
            }
            vars = s1.vars;
        } else {
            vars = SSAMap.merge(s1.vars, s2.vars);
        }
        Multiset<Pair<String, FormulaList>> funcs = s1.funcs == s2.funcs || s2.funcs.isEmpty() ? s1.funcs : (s1.funcs.isEmpty() ? s2.funcs : SSAMap.merge(s1.funcs, s2.funcs));
        return new SSAMap(vars, funcs);
    }

    private static <T> Multiset<T> merge(Multiset<T> s1, Multiset<T> s2) {
        Object key;
        LinkedHashMultiset result = LinkedHashMultiset.create((int)Math.max(s1.size(), s2.size()));
        for (Multiset.Entry entry : s1.entrySet()) {
            key = entry.getElement();
            int i1 = entry.getCount();
            int i2 = s2.count(key);
            result.setCount(key, Math.max(i1, i2));
        }
        for (Multiset.Entry entry : s2.entrySet()) {
            key = entry.getElement();
            if (s1.contains(key)) continue;
            result.setCount(key, entry.getCount());
        }
        return result;
    }

    private SSAMap(Multiset<String> vars, Multiset<Pair<String, FormulaList>> funcs) {
        this.vars = vars;
        this.funcs = funcs;
    }

    public SSAMapBuilder builder() {
        return new SSAMapBuilder(this);
    }

    private static <T> int getIndex(T key, Multiset<T> map) {
        int i = map.count(key);
        if (i != 0) {
            return i;
        }
        return -1;
    }

    public int getIndex(String variable) {
        return SSAMap.getIndex(variable, this.vars);
    }

    public int getIndex(String name, FormulaList args) {
        return SSAMap.getIndex(Pair.of((Object)name, (Object)args), this.funcs);
    }

    protected int getIndex(Pair<String, FormulaList> key) {
        return SSAMap.getIndex(key, this.funcs);
    }

    public Set<String> allVariables() {
        return Collections.unmodifiableSet(this.vars.elementSet());
    }

    public Set<Pair<String, FormulaList>> allFunctions() {
        return Collections.unmodifiableSet(this.funcs.elementSet());
    }

    public String toString() {
        return joiner.join((Iterable)this.vars.entrySet()) + " " + joiner.join((Iterable)this.funcs.entrySet());
    }

    public int hashCode() {
        return (31 + this.funcs.hashCode()) * 31 + this.vars.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SSAMap)) {
            return false;
        }
        SSAMap other = (SSAMap)obj;
        return this.vars.equals(other.vars) && this.funcs.equals(other.funcs);
    }

    public static class SSAMapBuilder {
        private SSAMap ssa;
        private Multiset<String> varsBuilder = null;
        private Multiset<Pair<String, FormulaList>> funcsBuilder = null;

        protected SSAMapBuilder(SSAMap ssa) {
            this.ssa = ssa;
        }

        public int getIndex(String variable) {
            return SSAMap.getIndex(variable, (Multiset)Objects.firstNonNull(this.varsBuilder, (Object)this.ssa.vars));
        }

        public int getIndex(String func, FormulaList args) {
            return SSAMap.getIndex(Pair.of((Object)func, (Object)args), (Multiset)Objects.firstNonNull(this.funcsBuilder, (Object)this.ssa.funcs));
        }

        public void setIndex(String var, int idx) {
            Preconditions.checkArgument((idx > 0 ? 1 : 0) != 0, (Object)"Indices need to be positive for this SSAMap implementation!");
            if (this.varsBuilder == null) {
                this.varsBuilder = LinkedHashMultiset.create((Iterable)this.ssa.vars);
            }
            Preconditions.checkArgument((idx >= this.varsBuilder.count((Object)var) ? 1 : 0) != 0, (Object)"SSAMap updates need to be strictly monotone!");
            this.varsBuilder.setCount((Object)var, idx);
        }

        public void setIndex(String func, FormulaList args, int idx) {
            Pair key;
            Preconditions.checkArgument((idx > 0 ? 1 : 0) != 0, (Object)"Indices need to be positive for this SSAMap implementation!");
            if (this.funcsBuilder == null) {
                this.funcsBuilder = LinkedHashMultiset.create((Iterable)this.ssa.funcs);
            }
            Preconditions.checkArgument((idx >= this.funcsBuilder.count((Object)(key = Pair.of((Object)func, (Object)args))) ? 1 : 0) != 0, (Object)"SSAMap updates need to be strictly monotone!");
            this.funcsBuilder.setCount((Object)key, idx);
        }

        public void deleteVariable(String variable) {
            int index = this.getIndex(variable);
            if (index != -1) {
                if (this.varsBuilder == null) {
                    this.varsBuilder = LinkedHashMultiset.create((Iterable)this.ssa.vars);
                }
                this.varsBuilder.remove((Object)variable, index);
            }
        }

        public SSAMap build() {
            if (this.varsBuilder == null && this.funcsBuilder == null) {
                return this.ssa;
            }
            this.ssa = new SSAMap((Multiset)Objects.firstNonNull(this.varsBuilder, (Object)this.ssa.vars), (Multiset)Objects.firstNonNull(this.funcsBuilder, (Object)this.ssa.funcs));
            this.varsBuilder = null;
            this.funcsBuilder = null;
            return this.ssa;
        }
    }
}

