/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.Maps;
import java.util.Map;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;

public class Solver {
    private final ExtendedFormulaManager fmgr;
    private final TheoremProver prover;
    private final Map<Formula, Boolean> implicationCache = Maps.newHashMap();
    public final Timer solverTime = new Timer();
    public int implicationChecks = 0;
    public int trivialImplicationChecks = 0;
    public int cachedImplicationChecks = 0;

    public Solver(ExtendedFormulaManager pFmgr, TheoremProver pProver) {
        this.fmgr = pFmgr;
        this.prover = pProver;
    }

    public TheoremProver getTheoremProver() {
        return this.prover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnsat(Formula f) {
        this.solverTime.start();
        this.prover.init();
        try {
            this.prover.push(f);
            boolean bl = this.prover.isUnsat();
            return bl;
        }
        finally {
            this.prover.reset();
            this.solverTime.stop();
        }
    }

    public boolean implies(Formula a, Formula b) {
        ++this.implicationChecks;
        if (a.isFalse() || b.isTrue()) {
            ++this.trivialImplicationChecks;
            return true;
        }
        if (a.isTrue() || b.isFalse()) {
            ++this.trivialImplicationChecks;
            return false;
        }
        if (a.equals(b)) {
            ++this.trivialImplicationChecks;
            return true;
        }
        Formula f = this.fmgr.makeNot(this.fmgr.makeImplication(a, b));
        Boolean result = this.implicationCache.get(f);
        if (result != null) {
            ++this.cachedImplicationChecks;
            return result;
        }
        result = this.isUnsat(f);
        this.implicationCache.put(f, result);
        return result;
    }
}

