/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

public class SymbolicRegionManager
implements RegionManager {
    private final Solver solver;
    private final SymbolicRegion trueRegion;
    private final SymbolicRegion falseRegion;

    public SymbolicRegionManager(FormulaManager fmgr, Solver pSolver) {
        this.solver = pSolver;
        this.trueRegion = new SymbolicRegion(fmgr.makeTrue());
        this.falseRegion = new SymbolicRegion(fmgr.makeFalse());
    }

    @Override
    public boolean entails(Region pF1, Region pF2) {
        SymbolicRegion r1 = (SymbolicRegion)pF1;
        SymbolicRegion r2 = (SymbolicRegion)pF2;
        return this.solver.implies(r1.f, r2.f);
    }

    @Override
    public SymbolicRegion makeTrue() {
        return this.trueRegion;
    }

    @Override
    public SymbolicRegion makeFalse() {
        return this.falseRegion;
    }

    @Override
    public Region makeNot(Region pF) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region makeExists(Region pF1, Region pF2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region createPredicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        throw new UnsupportedOperationException();
    }

    public static class SymbolicRegion
    implements Region {
        private final Formula f;

        public SymbolicRegion(Formula pF) {
            this.f = pF;
        }

        @Override
        public boolean isTrue() {
            return this.f.isTrue();
        }

        @Override
        public boolean isFalse() {
            return this.f.isFalse();
        }
    }
}

