/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.bdd;

import com.google.common.collect.Maps;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDRegion;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

public class BDDRegionManager
implements RegionManager {
    private static final String BDD_PACKAGE = "cudd";
    private static final BDDFactory factory = BDDFactory.init((String)"cudd", (int)10000, (int)1000);
    private static final Region trueFormula = new BDDRegion(factory.one());
    private static final Region falseFormula = new BDDRegion(factory.zero());
    private static int nextvar = 0;
    private static int varcount = 100;
    private static RegionManager instance = new BDDRegionManager();
    private final ReferenceQueue<BDDRegion> referenceQueue;
    private final Map<PhantomReference<BDDRegion>, BDD> referenceMap;

    public BDDRegionManager() {
        factory.setVarNum(varcount);
        this.referenceQueue = new ReferenceQueue();
        this.referenceMap = Maps.newIdentityHashMap();
    }

    private static BDD createNewVar() {
        if (nextvar >= varcount) {
            varcount = (int)((double)varcount * 1.5);
            factory.setVarNum(varcount);
        }
        BDD ret = factory.ithVar(nextvar++);
        return ret;
    }

    public static RegionManager getInstance() {
        return instance;
    }

    private void cleanupReferences() {
        PhantomReference ref;
        while ((ref = (PhantomReference)this.referenceQueue.poll()) != null) {
            BDD bdd = this.referenceMap.remove(ref);
            assert (bdd != null);
            bdd.free();
        }
    }

    private BDDRegion wrap(BDD bdd) {
        BDDRegion region = new BDDRegion(bdd);
        PhantomReference<BDDRegion> ref = new PhantomReference<BDDRegion>(region, this.referenceQueue);
        this.referenceMap.put(ref, bdd);
        return region;
    }

    @Override
    public boolean entails(Region pF1, Region pF2) {
        this.cleanupReferences();
        BDDRegion f1 = (BDDRegion)pF1;
        BDDRegion f2 = (BDDRegion)pF2;
        BDD imp = f1.getBDD().imp(f2.getBDD());
        boolean result = imp.isOne();
        imp.free();
        return result;
    }

    @Override
    public Region makeTrue() {
        this.cleanupReferences();
        return trueFormula;
    }

    @Override
    public Region makeFalse() {
        this.cleanupReferences();
        return falseFormula;
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        this.cleanupReferences();
        BDDRegion f1 = (BDDRegion)pF1;
        BDDRegion f2 = (BDDRegion)pF2;
        return this.wrap(f1.getBDD().and(f2.getBDD()));
    }

    @Override
    public Region makeNot(Region pF) {
        this.cleanupReferences();
        BDDRegion f = (BDDRegion)pF;
        return this.wrap(f.getBDD().not());
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        this.cleanupReferences();
        BDDRegion f1 = (BDDRegion)pF1;
        BDDRegion f2 = (BDDRegion)pF2;
        return this.wrap(f1.getBDD().or(f2.getBDD()));
    }

    @Override
    public Region createPredicate() {
        this.cleanupReferences();
        BDD bddVar = BDDRegionManager.createNewVar();
        return this.wrap(bddVar);
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        this.cleanupReferences();
        BDD f = ((BDDRegion)pF).getBDD();
        BDDRegion predicate = this.wrap(factory.ithVar(f.var()));
        BDDRegion fThen = this.wrap(f.high());
        BDDRegion fElse = this.wrap(f.low());
        return new Triple((Object)predicate, (Object)fThen, (Object)fElse);
    }

    @Override
    public Region makeExists(Region pF1, Region pF2) {
        this.cleanupReferences();
        BDD f1 = ((BDDRegion)pF1).getBDD();
        BDD f2 = ((BDDRegion)pF2).getBDD();
        return this.wrap(f1.exist(f2));
    }

    public String getVersion() {
        return factory.getVersion();
    }
}

