/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.ARTReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTUtils;
import org.sosy_lab.cpachecker.cpa.art.AbstractARTBasedRefiner;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;

@Options(prefix="cpa.predicate.refinement")
public abstract class AbstractInterpolationBasedRefiner<I, P>
extends AbstractARTBasedRefiner {
    @Option(name="msatCexFile", description="where to dump the counterexample formula in case the error location is reached")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File dumpCexFile = new File("counterexample.msat");
    public final Timer totalRefinement = new Timer();
    public final Timer errorPathProcessing = new Timer();
    protected final LogManager logger;
    private final InterpolationManager<I> formulaManager;
    protected List<Formula> lastErrorPath = null;

    protected AbstractInterpolationBasedRefiner(Configuration config, LogManager pLogger, ConfigurableProgramAnalysis pCpa, InterpolationManager<I> pInterpolationManager) throws CPAException, InvalidConfigurationException {
        super(pCpa);
        config.inject((Object)this, AbstractInterpolationBasedRefiner.class);
        this.logger = pLogger;
        this.formulaManager = pInterpolationManager;
    }

    @Override
    protected CounterexampleInfo performRefinement(ARTReachedSet pReached, Path pPath) throws CPAException, InterruptedException {
        CounterexampleTraceInfo preciseCounterexample;
        Path targetPath;
        this.totalRefinement.start();
        Set<ARTElement> elementsOnPath = ARTUtils.getAllElementsOnPathsTo((ARTElement)((Pair)pPath.getLast()).getFirst());
        boolean branchingOccurred = true;
        if (elementsOnPath.size() == pPath.size()) {
            elementsOnPath = Collections.emptySet();
            branchingOccurred = false;
        }
        this.logger.log(Level.FINEST, new Object[]{"Starting interpolation-based refinement"});
        List<P> path = this.transformPath(pPath);
        this.logger.log(Level.ALL, new Object[]{"Abstraction trace is", path});
        List<Formula> formulas = this.getFormulasForPath(path, (ARTElement)((Pair)pPath.getFirst()).getFirst());
        assert (path.size() == formulas.size());
        CounterexampleTraceInfo counterexample = this.formulaManager.buildCounterexampleTrace(formulas, elementsOnPath);
        if (counterexample.isSpurious()) {
            this.logger.log(Level.FINEST, new Object[]{"Error trace is spurious, refining the abstraction"});
            boolean repeatedCounterexample = ((Object)formulas).equals(this.lastErrorPath);
            this.lastErrorPath = formulas;
            this.performRefinement(pReached, path, counterexample, repeatedCounterexample);
            this.totalRefinement.stop();
            return CounterexampleInfo.spurious();
        }
        this.logger.log(Level.FINEST, new Object[]{"Error trace is not spurious"});
        if (branchingOccurred) {
            Pair<Path, CounterexampleTraceInfo<I>> preciseInfo = this.findPreciseErrorPath(pPath, counterexample);
            if (preciseInfo != null) {
                targetPath = (Path)preciseInfo.getFirst();
                preciseCounterexample = (CounterexampleTraceInfo)preciseInfo.getSecond();
            } else {
                this.logger.log(Level.WARNING, new Object[]{"The error path and the satisfying assignment may be imprecise!"});
                targetPath = pPath;
                preciseCounterexample = counterexample;
            }
        } else {
            targetPath = pPath;
            preciseCounterexample = counterexample;
        }
        CounterexampleInfo cex = CounterexampleInfo.feasible(targetPath, (Object)preciseCounterexample.getCounterexample());
        cex.addFurtherInformation(new Object(){

            public String toString() {
                return AbstractInterpolationBasedRefiner.this.formulaManager.dumpCounterexample(preciseCounterexample);
            }
        }, this.dumpCexFile);
        this.totalRefinement.stop();
        return cex;
    }

    protected abstract List<P> transformPath(Path var1);

    protected abstract List<Formula> getFormulasForPath(List<P> var1, ARTElement var2) throws CPATransferException;

    protected abstract void performRefinement(ARTReachedSet var1, List<P> var2, CounterexampleTraceInfo<I> var3, boolean var4) throws CPAException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Path, CounterexampleTraceInfo<I>> findPreciseErrorPath(Path pPath, CounterexampleTraceInfo<I> counterexample) {
        this.errorPathProcessing.start();
        try {
            Pair pair;
            CounterexampleTraceInfo<I> info2;
            Path targetPath;
            Map<Integer, Boolean> preds = counterexample.getBranchingPredicates();
            if (preds.isEmpty()) {
                this.logger.log(Level.WARNING, new Object[]{"No information about ART branches available!"});
                Pair<Path, CounterexampleTraceInfo<I>> pair2 = null;
                return pair2;
            }
            try {
                ARTElement root = (ARTElement)((Pair)pPath.getFirst()).getFirst();
                ARTElement target = (ARTElement)((Pair)pPath.getLast()).getFirst();
                Set<ARTElement> pathElements = ARTUtils.getAllElementsOnPathsTo(target);
                targetPath = ARTUtils.getPathFromBranchingInformation(root, target, pathElements, preds);
            }
            catch (IllegalArgumentException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, null);
                Pair<Path, CounterexampleTraceInfo<I>> target = null;
                this.errorPathProcessing.stop();
                return target;
            }
            try {
                info2 = this.formulaManager.checkPath(targetPath.asEdgesList());
            }
            catch (CPATransferException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not replay error path");
                Pair<Path, CounterexampleTraceInfo<I>> pair3 = null;
                this.errorPathProcessing.stop();
                return pair3;
            }
            if (info2.isSpurious()) {
                this.logger.log(Level.WARNING, new Object[]{"Inconsistent replayed error path!"});
                pair = null;
                return pair;
            }
            pair = Pair.of((Object)targetPath, info2);
            return pair;
        }
        finally {
            this.errorPathProcessing.stop();
        }
    }

    protected void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        if (this.totalRefinement.getSumTime() > 0L) {
            out.println("Time for refinement:              " + this.totalRefinement);
            this.formulaManager.stats.printStatistics(out, result, reached);
            out.println("  Error path post-processing:     " + this.errorPathProcessing);
        }
    }
}

