/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;

public class CounterexampleTraceInfo<I> {
    private final boolean spurious;
    private final List<I> pmap;
    private final Model mCounterexampleModel;
    private final List<Formula> mCounterexampleFormula;
    private final Map<Integer, Boolean> branchingPreds;

    public CounterexampleTraceInfo() {
        this.mCounterexampleFormula = Collections.emptyList();
        this.mCounterexampleModel = null;
        this.spurious = true;
        this.pmap = Lists.newArrayList();
        this.branchingPreds = ImmutableMap.of();
    }

    public CounterexampleTraceInfo(List<Formula> pCounterexampleFormula, Model pModel, Map<Integer, Boolean> preds) {
        Preconditions.checkNotNull(pCounterexampleFormula);
        Preconditions.checkNotNull((Object)((Object)pModel));
        this.mCounterexampleFormula = pCounterexampleFormula;
        this.mCounterexampleModel = pModel;
        this.spurious = false;
        this.pmap = ImmutableList.of();
        this.branchingPreds = preds;
    }

    public boolean isSpurious() {
        return this.spurious;
    }

    public List<I> getPredicatesForRefinement() {
        return this.pmap;
    }

    public void addPredicatesForRefinement(I preds) {
        this.pmap.add(preds);
    }

    public String toString() {
        return "Spurious: " + this.isSpurious() + (this.isSpurious() ? ", new predicates: " + this.pmap : "");
    }

    public boolean hasCounterexample() {
        return this.mCounterexampleModel != null;
    }

    public List<Formula> getCounterExampleFormulas() {
        return this.mCounterexampleFormula;
    }

    public Model getCounterexample() {
        Preconditions.checkState((boolean)this.hasCounterexample());
        return this.mCounterexampleModel;
    }

    public Map<Integer, Boolean> getBranchingPredicates() {
        return this.branchingPreds;
    }
}

