/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.CSIsatInterpolatingProver;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingTheoremProver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

@Options(prefix="cpa.predicate.refinement")
public abstract class InterpolationManager<I> {
    final Stats stats = new Stats();
    protected final LogManager logger;
    protected final ExtendedFormulaManager fmgr;
    protected final PathFormulaManager pmgr;
    private final Solver solver;
    private final InterpolatingTheoremProver<?> firstItpProver;
    private final InterpolatingTheoremProver<?> secondItpProver;
    @Option(name="interpolatingProver", toUppercase=true, values={"DEFAULT", "CSISAT"}, description="Which interpolating solver to use for interpolant generation?\nDEFAULT means to use the solver used for everything else as well.")
    private String whichItpProver = "DEFAULT";
    @Option(description="apply deletion-filter to the abstract counterexample, to get a minimal set of blocks, before applying interpolation-based refinement")
    private boolean getUsefulBlocks = false;
    @Option(name="shortestCexTrace", description="use incremental search in counterexample analysis, to find the minimal infeasible prefix")
    private boolean shortestTrace = false;
    @Option(name="shortestCexTraceUseSuffix", description="if shortestCexTrace is used, start from the end with the incremental search")
    private boolean useSuffix = false;
    @Option(name="shortestCexTraceZigZag", description="if shortestCexTrace is used, alternatingly search from start and end of the trace")
    private boolean useZigZag = false;
    @Option(name="addWellScopedPredicates", description="refinement will try to build 'well-scoped' predicates, by cutting spurious traces as explained in Section 5.2 of the paper 'Abstractions From Proofs'\n(this does not work with function inlining).\nTHIS FEATURE IS CURRENTLY NOT AVAILABLE. ")
    private boolean wellScopedPredicates = false;
    @Option(description="dump all interpolation problems")
    private boolean dumpInterpolationProblems = false;
    @Option(description="verify if the interpolants fulfill the interpolant properties")
    private boolean verifyInterpolants = false;
    @Option(name="timelimit", description="time limit for refinement (use milliseconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=0L)
    private long itpTimeLimit = 0L;
    @Option(name="changesolverontimeout", description="try again with a second solver if refinement timed out")
    private boolean changeItpSolveOTF = false;
    @Option(description="skip refinement if input formula is larger than this amount of bytes (ignored if 0)")
    private int maxRefinementSize = 0;
    private final ExecutorService executor;

    public InterpolationManager(ExtendedFormulaManager pFmgr, PathFormulaManager pPmgr, Solver pSolver, FormulaManagerFactory pFmgrFactory, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this, InterpolationManager.class);
        this.logger = pLogger;
        this.fmgr = pFmgr;
        this.pmgr = pPmgr;
        this.solver = pSolver;
        if (this.whichItpProver.equals("CSISAT")) {
            this.firstItpProver = new CSIsatInterpolatingProver(this.fmgr, this.logger);
        } else {
            assert (this.whichItpProver.equals("DEFAULT"));
            this.firstItpProver = pFmgrFactory.createInterpolatingTheoremProver(false);
        }
        if (this.changeItpSolveOTF) {
            if (this.whichItpProver.equals("CSISAT")) {
                this.secondItpProver = pFmgrFactory.createInterpolatingTheoremProver(false);
            } else {
                assert (this.whichItpProver.equals("DEFAULT"));
                this.secondItpProver = new CSIsatInterpolatingProver(this.fmgr, this.logger);
            }
        } else {
            this.secondItpProver = null;
        }
        this.executor = this.itpTimeLimit == 0L ? null : Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
        if (this.wellScopedPredicates) {
            throw new InvalidConfigurationException("wellScopePredicates are currently disabled");
        }
    }

    public String dumpCounterexample(CounterexampleTraceInfo<I> cex) {
        return this.fmgr.dumpFormula(this.fmgr.makeConjunction(cex.getCounterExampleFormulas()));
    }

    public CounterexampleTraceInfo<I> buildCounterexampleTrace(final List<Formula> pFormulas, final Set<ARTElement> elementsOnPath) throws CPAException, InterruptedException {
        if (this.itpTimeLimit == 0L) {
            return this.buildCounterexampleTraceWithSpecifiedItp(pFormulas, elementsOnPath, this.firstItpProver);
        }
        assert (this.executor != null);
        int noOfTries = 0;
        while (true) {
            final InterpolatingTheoremProver<?> currentItpProver = noOfTries == 0 ? this.firstItpProver : this.secondItpProver;
            Callable tc = new Callable<CounterexampleTraceInfo<I>>(){

                @Override
                public CounterexampleTraceInfo<I> call() throws CPAException, InterruptedException {
                    return InterpolationManager.this.buildCounterexampleTraceWithSpecifiedItp(pFormulas, elementsOnPath, currentItpProver);
                }
            };
            Future future = this.executor.submit(tc);
            try {
                return (CounterexampleTraceInfo)future.get(this.itpTimeLimit, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                if (this.changeItpSolveOTF && noOfTries == 0) {
                    this.logger.log(Level.WARNING, new Object[]{"SMT-solver timed out during interpolation process, trying next solver."});
                    ++noOfTries;
                    continue;
                }
                this.logger.log(Level.SEVERE, new Object[]{"SMT-solver timed out during interpolation process"});
                throw new RefinementFailedException(RefinementFailedException.Reason.TIMEOUT, null);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                Throwables.propagateIfPossible((Throwable)t, CPAException.class, InterruptedException.class);
                throw new Classes.UnexpectedCheckedException("interpolation", t);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CounterexampleTraceInfo<I> buildCounterexampleTraceWithSpecifiedItp(List<Formula> pFormulas, Set<ARTElement> elementsOnPath, InterpolatingTheoremProver<T> pItpProver) throws CPAException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Building counterexample trace"});
        this.stats.cexAnalysisTimer.start();
        pItpProver.init();
        try {
            CounterexampleTraceInfo<I> info;
            boolean spurious;
            ArrayList<Object> itpGroupsIds;
            int size;
            List<Formula> f = new ArrayList<Formula>(pFormulas);
            if (this.fmgr.useBitwiseAxioms()) {
                this.addBitwiseAxioms(f);
            }
            f = Collections.unmodifiableList(f);
            this.logger.log(Level.ALL, new Object[]{"Counterexample trace formulas:", f});
            if (this.maxRefinementSize > 0 && (size = this.fmgr.dumpFormula(this.fmgr.makeConjunction(f)).length()) > this.maxRefinementSize) {
                this.logger.log(Level.FINEST, new Object[]{"Skipping refinement because input formula is", size, "bytes large."});
                throw new RefinementFailedException(RefinementFailedException.Reason.TooMuchUnrolling, null);
            }
            this.logger.log(Level.FINEST, new Object[]{"Checking feasibility of counterexample trace"});
            this.stats.cexAnalysisSolverTimer.start();
            try {
                if (this.shortestTrace && this.getUsefulBlocks) {
                    f = Collections.unmodifiableList(this.getUsefulBlocks(f, this.useSuffix, this.useZigZag));
                }
                if (this.dumpInterpolationProblems) {
                    this.dumpInterpolationProblem(f);
                }
                itpGroupsIds = new ArrayList<Object>(Collections.nCopies(f.size(), null));
                spurious = this.getUsefulBlocks || !this.shortestTrace ? this.checkInfeasibilityOfFullTrace(f, itpGroupsIds, pItpProver) : this.checkInfeasabilityOfShortestTrace(f, itpGroupsIds, pItpProver);
                assert (itpGroupsIds.size() == f.size());
                assert (!itpGroupsIds.contains(null));
            }
            finally {
                this.stats.cexAnalysisSolverTimer.stop();
            }
            this.logger.log(Level.FINEST, new Object[]{"Counterexample trace is", spurious ? "infeasible" : "feasible"});
            if (spurious) {
                List<Formula> interpolants = this.getInterpolants(pItpProver, itpGroupsIds);
                if (this.verifyInterpolants) {
                    this.verifyInterpolants(interpolants, f, pItpProver);
                }
                info = this.extractPredicates(interpolants);
            } else {
                info = this.getErrorPath(f, pItpProver, elementsOnPath);
            }
            this.logger.log(Level.ALL, new Object[]{"Counterexample information:", info});
            CounterexampleTraceInfo<I> counterexampleTraceInfo = info;
            return counterexampleTraceInfo;
        }
        finally {
            pItpProver.reset();
            this.stats.cexAnalysisTimer.stop();
        }
    }

    private void addBitwiseAxioms(List<Formula> f) {
        Formula bitwiseAxioms = this.fmgr.makeTrue();
        for (Formula fm : f) {
            Formula a = this.fmgr.getBitwiseAxioms(fm);
            if (a.isTrue()) continue;
            bitwiseAxioms = this.fmgr.makeAnd(bitwiseAxioms, a);
        }
        if (!bitwiseAxioms.isTrue()) {
            this.logger.log(Level.ALL, new Object[]{"DEBUG_3", "ADDING BITWISE AXIOMS TO THE", "LAST GROUP: ", bitwiseAxioms});
            int lastIndex = f.size() - 1;
            f.set(lastIndex, this.fmgr.makeAnd(f.get(lastIndex), bitwiseAxioms));
        }
    }

    private List<Formula> getUsefulBlocks(List<Formula> f, boolean suffixTrace, boolean zigZag) {
        boolean consistent;
        this.stats.cexAnalysisGetUsefulBlocksTimer.start();
        TheoremProver thmProver = this.solver.getTheoremProver();
        thmProver.init();
        this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Calling getUsefulBlocks on path", "of length:", f.size()});
        Formula[] needed = new Formula[f.size()];
        for (int i = 0; i < needed.length; ++i) {
            needed[i] = this.fmgr.makeTrue();
        }
        int pos = suffixTrace ? f.size() - 1 : 0;
        int incr = suffixTrace ? -1 : 1;
        int toPop = 0;
        block1: do {
            int i;
            consistent = true;
            for (i = 0; i < needed.length; ++i) {
                if (needed[i].isTrue()) continue;
                thmProver.push(needed[i]);
                ++toPop;
            }
            if (thmProver.isUnsat()) {
                f = Arrays.asList(needed);
                break;
            }
            if (zigZag) {
                int s = 0;
                int e = f.size() - 1;
                boolean fromStart = false;
                do {
                    int i2;
                    int n = i2 = fromStart ? s : e;
                    if (fromStart) {
                        ++s;
                    } else {
                        --e;
                    }
                    fromStart = !fromStart;
                    Formula t = f.get(i2);
                    thmProver.push(t);
                    ++toPop;
                    if (!thmProver.isUnsat()) continue;
                    needed[i2] = t;
                    this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Found needed block: ", i2, ", term: ", t});
                    while (toPop > 0) {
                        --toPop;
                        thmProver.pop();
                    }
                    consistent = false;
                    continue block1;
                } while (e >= s);
                continue;
            }
            i = pos;
            while (suffixTrace ? i >= 0 : i < f.size()) {
                Formula t = f.get(i);
                thmProver.push(t);
                ++toPop;
                if (thmProver.isUnsat()) {
                    needed[i] = t;
                    this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Found needed block: ", i, ", term: ", t});
                    while (toPop > 0) {
                        --toPop;
                        thmProver.pop();
                    }
                    consistent = false;
                    continue block1;
                }
                i += incr;
            }
        } while (!consistent);
        while (toPop > 0) {
            --toPop;
            thmProver.pop();
        }
        thmProver.reset();
        this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Done getUsefulBlocks"});
        this.stats.cexAnalysisGetUsefulBlocksTimer.stop();
        return f;
    }

    private <T> boolean checkInfeasibilityOfFullTrace(List<Formula> f, List<T> itpGroupsIds, InterpolatingTheoremProver<T> pItpProver) throws InterruptedException {
        int i;
        int n = i = this.useSuffix ? f.size() - 1 : 0;
        while (this.useSuffix ? i >= 0 : i < f.size()) {
            itpGroupsIds.set(i, pItpProver.addFormula(f.get(i)));
            i += this.useSuffix ? -1 : 1;
        }
        return pItpProver.isUnsat();
    }

    private <T> boolean checkInfeasabilityOfShortestTrace(List<Formula> traceFormulas, List<T> itpGroupsIds, InterpolatingTheoremProver<T> pItpProver) throws InterruptedException {
        Boolean tmpSpurious = null;
        if (this.useZigZag) {
            int e = traceFormulas.size() - 1;
            int s = 0;
            boolean fromStart = false;
            while (s <= e) {
                int i;
                int n = i = fromStart ? s : e;
                if (fromStart) {
                    ++s;
                } else {
                    --e;
                }
                fromStart = !fromStart;
                tmpSpurious = null;
                Formula fm = traceFormulas.get(i);
                itpGroupsIds.set(i, pItpProver.addFormula(fm));
                if (fm.isTrue()) continue;
                if (pItpProver.isUnsat()) {
                    tmpSpurious = Boolean.TRUE;
                    for (int j = s; j <= e; ++j) {
                        itpGroupsIds.set(j, pItpProver.addFormula(traceFormulas.get(j)));
                    }
                    break;
                }
                tmpSpurious = Boolean.FALSE;
            }
        } else {
            int i;
            int n = i = this.useSuffix ? traceFormulas.size() - 1 : 0;
            while (this.useSuffix ? i >= 0 : i < traceFormulas.size()) {
                tmpSpurious = null;
                Formula fm = traceFormulas.get(i);
                itpGroupsIds.set(i, pItpProver.addFormula(fm));
                if (!fm.isTrue()) {
                    if (pItpProver.isUnsat()) {
                        tmpSpurious = Boolean.TRUE;
                        int j = i + (this.useSuffix ? -1 : 1);
                        while (this.useSuffix ? j >= 0 : j < traceFormulas.size()) {
                            itpGroupsIds.set(j, pItpProver.addFormula(traceFormulas.get(j)));
                            j += this.useSuffix ? -1 : 1;
                        }
                        break;
                    }
                    tmpSpurious = Boolean.FALSE;
                }
                i += this.useSuffix ? -1 : 1;
            }
        }
        return tmpSpurious == null ? pItpProver.isUnsat() : tmpSpurious.booleanValue();
    }

    private <T> List<Formula> getInterpolants(InterpolatingTheoremProver<T> pItpProver, List<T> itpGroupsIds) {
        ArrayList interpolants = Lists.newArrayListWithExpectedSize((int)(itpGroupsIds.size() - 1));
        ArrayDeque<Integer> entryPoints = null;
        if (this.wellScopedPredicates) {
            entryPoints = new ArrayDeque<Integer>();
            entryPoints.push(0);
        }
        for (int i = 0; i < itpGroupsIds.size() - 1; ++i) {
            int start_of_a = this.wellScopedPredicates ? (Integer)entryPoints.peek() : 0;
            this.logger.log(Level.ALL, new Object[]{"Looking for interpolant for formulas from", start_of_a, "to", i});
            this.stats.cexAnalysisSolverTimer.start();
            Formula itp = pItpProver.getInterpolant(itpGroupsIds.subList(start_of_a, i + 1));
            this.stats.cexAnalysisSolverTimer.stop();
            if (this.dumpInterpolationProblems) {
                File dumpFile = this.formatFormulaOutputFile("interpolant", i);
                this.fmgr.dumpFormulaToFile(itp, dumpFile);
            }
            interpolants.add(itp);
        }
        return interpolants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void verifyInterpolants(List<Formula> interpolants, List<Formula> formulas, InterpolatingTheoremProver<T> prover) throws SolverException, InterruptedException {
        this.stats.interpolantVerificationTimer.start();
        try {
            int n = interpolants.size();
            assert (n == formulas.size() - 1);
            if (!this.checkImplication(formulas.get(0), interpolants.get(0), prover)) {
                throw new SolverException("First interpolant is not implied by first formula");
            }
            for (int i = 1; i <= n - 1; ++i) {
                Formula conjunct = this.fmgr.makeAnd(interpolants.get(i - 1), formulas.get(i));
                if (this.checkImplication(conjunct, interpolants.get(i), prover)) continue;
                throw new SolverException("Interpolant " + interpolants.get(i) + " is not implied by previous part of the path");
            }
            Formula conjunct = this.fmgr.makeAnd(interpolants.get(n - 1), formulas.get(n));
            if (!this.checkImplication(conjunct, this.fmgr.makeFalse(), prover)) {
                throw new SolverException("Last interpolant fails to prove infeasibility of the path");
            }
            ArrayList variablesInFormulas = Lists.newArrayListWithExpectedSize((int)formulas.size());
            for (Formula f : formulas) {
                variablesInFormulas.add(this.fmgr.extractVariables(f));
            }
            for (int i = 0; i < interpolants.size(); ++i) {
                HashSet variablesInA = new HashSet();
                for (int j = 0; j <= i; ++j) {
                    variablesInA.addAll((Collection)variablesInFormulas.get(j));
                }
                HashSet variablesInB = new HashSet();
                for (int j = i + 1; j < formulas.size(); ++j) {
                    variablesInB.addAll((Collection)variablesInFormulas.get(j));
                }
                ImmutableSet allowedVariables = Sets.intersection(variablesInA, variablesInB).immutableCopy();
                Set<String> variablesInInterpolant = this.fmgr.extractVariables(interpolants.get(i));
                variablesInInterpolant.removeAll((Collection<?>)allowedVariables);
                if (variablesInInterpolant.isEmpty()) continue;
                throw new SolverException("Interpolant " + interpolants.get(i) + " contains forbidden variable(s) " + variablesInInterpolant);
            }
        }
        finally {
            this.stats.interpolantVerificationTimer.stop();
        }
    }

    private <T> boolean checkImplication(Formula a, Formula b, InterpolatingTheoremProver<T> prover) throws InterruptedException {
        Formula f = this.fmgr.makeAnd(a, this.fmgr.makeNot(b));
        prover.reset();
        prover.init();
        prover.addFormula(f);
        boolean unsat = prover.isUnsat();
        return unsat;
    }

    private <T> CounterexampleTraceInfo<I> extractPredicates(List<Formula> interpolants) {
        CounterexampleTraceInfo<I> info = new CounterexampleTraceInfo<I>();
        int i = 1;
        for (Formula itp : interpolants) {
            I preds;
            if (itp.isTrue()) {
                this.logger.log(Level.ALL, new Object[]{"For step", i, "got no interpolant."});
                preds = this.getTrueInterpolant();
            } else {
                this.logger.log(Level.ALL, new Object[]{"For step", i, "got:", "interpolant", itp});
                preds = this.convertInterpolant(itp, i);
            }
            info.addPredicatesForRefinement(preds);
            ++i;
        }
        return info;
    }

    protected abstract I convertInterpolant(Formula var1, int var2);

    protected abstract I getTrueInterpolant();

    private <T> CounterexampleTraceInfo<I> getErrorPath(List<Formula> f, InterpolatingTheoremProver<T> pItpProver, Set<ARTElement> elementsOnPath) throws CPATransferException, InterruptedException {
        boolean stillSatisfiable;
        Formula branchingFormula = this.pmgr.buildBranchingFormula(elementsOnPath);
        if (branchingFormula.isTrue()) {
            return new CounterexampleTraceInfo(f, pItpProver.getModel(), Collections.<Integer, Boolean>emptyMap());
        }
        pItpProver.addFormula(branchingFormula);
        boolean bl = stillSatisfiable = !pItpProver.isUnsat();
        if (stillSatisfiable) {
            Model model = pItpProver.getModel();
            return new CounterexampleTraceInfo(f, model, this.pmgr.getBranchingPredicateValuesFromModel(model));
        }
        this.logger.log(Level.WARNING, new Object[]{"Could not get precise error path information because of inconsistent reachingPathsFormula!"});
        this.dumpInterpolationProblem(f);
        File dumpFile = this.formatFormulaOutputFile("formula", f.size());
        this.fmgr.dumpFormulaToFile(branchingFormula, dumpFile);
        return new CounterexampleTraceInfo(f, new Model(this.fmgr), Collections.<Integer, Boolean>emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterexampleTraceInfo<I> checkPath(List<CFAEdge> pPath) throws CPATransferException {
        Formula f = this.pmgr.makeFormulaForPath(pPath).getFormula();
        TheoremProver thmProver = this.solver.getTheoremProver();
        thmProver.init();
        try {
            thmProver.push(f);
            if (thmProver.isUnsat()) {
                CounterexampleTraceInfo counterexampleTraceInfo = new CounterexampleTraceInfo();
                return counterexampleTraceInfo;
            }
            CounterexampleTraceInfo counterexampleTraceInfo = new CounterexampleTraceInfo(Collections.singletonList(f), thmProver.getModel(), (Map<Integer, Boolean>)ImmutableMap.of());
            return counterexampleTraceInfo;
        }
        finally {
            thmProver.reset();
        }
    }

    private void dumpInterpolationProblem(List<Formula> f) {
        int k = 0;
        for (Formula formula : f) {
            File dumpFile = this.formatFormulaOutputFile("formula", k++);
            this.fmgr.dumpFormulaToFile(formula, dumpFile);
        }
    }

    protected File formatFormulaOutputFile(String formula, int index) {
        if (this.dumpInterpolationProblems) {
            return this.fmgr.formatFormulaOutputFile("interpolation", this.stats.cexAnalysisTimer.getNumberOfIntervals(), formula, index);
        }
        return null;
    }

    static class Stats {
        private final Timer cexAnalysisTimer = new Timer();
        private final Timer cexAnalysisSolverTimer = new Timer();
        private final Timer cexAnalysisGetUsefulBlocksTimer = new Timer();
        private final Timer interpolantVerificationTimer = new Timer();

        Stats() {
        }

        void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
            out.println("  Counterexample analysis:        " + this.cexAnalysisTimer + " (Max: " + this.cexAnalysisTimer.printMaxTime() + ", Calls: " + this.cexAnalysisTimer.getNumberOfIntervals() + ")");
            if (this.cexAnalysisGetUsefulBlocksTimer.getMaxTime() != 0L) {
                out.println("    Cex.focusing:                 " + this.cexAnalysisGetUsefulBlocksTimer + " (Max: " + this.cexAnalysisGetUsefulBlocksTimer.printMaxTime() + ")");
            }
            out.println("    Solving time only:            " + this.cexAnalysisSolverTimer + " (Max: " + this.cexAnalysisSolverTimer.printMaxTime() + ", Calls: " + this.cexAnalysisSolverTimer.getNumberOfIntervals() + ")");
            if (this.interpolantVerificationTimer.getNumberOfIntervals() > 0) {
                out.println("    Interpolant verification:     " + this.interpolantVerificationTimer);
            }
        }
    }
}

