/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.ldd;

import edu.cmu.sei.rtss.jldd.swig.JLDD;
import org.sosy_lab.cpachecker.util.predicates.ldd.LDDFactory;

public class LDD {
    private final int lddPtr;
    private final LDDFactory factory;

    LDD(LDDFactory factory, int lddPtr) {
        this.lddPtr = lddPtr;
        this.factory = factory;
    }

    int getLddPtr() {
        return this.lddPtr;
    }

    public boolean equals(Object ldd) {
        if (this == ldd) {
            return true;
        }
        if (ldd instanceof LDD) {
            return this.lddPtr == ((LDD)ldd).lddPtr;
        }
        return false;
    }

    public int hashCode() {
        return this.lddPtr;
    }

    public boolean isOne() {
        return this.equals(this.factory.one());
    }

    public boolean isZero() {
        return this.equals(this.factory.zero());
    }

    public LDD imp(LDD pLdd) {
        return this.negate().or(pLdd);
    }

    public LDD negate() {
        return new LDD(this.factory, JLDD.jldd_not((int)this.lddPtr));
    }

    public LDD or(LDD pLdd) {
        return this.factory.createOr(this, pLdd);
    }

    public LDD and(LDD pLdd) {
        return this.factory.createAnd(this, pLdd);
    }

    public LDD xor(LDD pLdd) {
        return this.factory.createXor(this, pLdd);
    }

    public LDD exists(LDD pLdd) {
        return this.factory.createExists(this, pLdd);
    }

    public LDD pointerComplement() {
        int complementPtr = this.lddPtr | 1;
        return new LDD(this.factory, complementPtr);
    }

    public boolean isPointerComplement() {
        return (this.lddPtr & 1) != 0;
    }

    public LDD pointerNot() {
        int complementPtr = this.lddPtr ^ 1;
        return new LDD(this.factory, complementPtr);
    }

    public LDD conditionalPointerNot(boolean condition) {
        if (condition) {
            return this.pointerNot();
        }
        return this;
    }

    public LDD getE() {
        return new LDD(this.factory, JLDD.jldd_E((int)this.lddPtr));
    }

    public LDD getT() {
        return new LDD(this.factory, JLDD.jldd_T((int)this.lddPtr));
    }

    public LDD high() {
        LDD t = this.getT();
        return t.conditionalPointerNot(t.isPointerComplement());
    }

    public LDD regular() {
        return new LDD(this.factory, JLDD.jldd_regular((int)this.lddPtr));
    }

    public int getVar() {
        return JLDD.jldd_read_node_index((int)JLDD.jldd_regular((int)this.lddPtr));
    }

    public LDD low() {
        LDD e = this.getE();
        return e.conditionalPointerNot(e.isPointerComplement());
    }

    public LDD makeIfThenElse(LDD positive, LDD negative) {
        return this.factory.createIfThenElse(this, positive, negative);
    }
}

