/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat;

import java.util.ArrayDeque;
import java.util.HashSet;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.NativeApi;

public class ArithmeticMathsatFormulaManager
extends MathsatFormulaManager {
    private final boolean useIntegers;
    private final long bitwiseAndUfDecl;
    private final long bitwiseOrUfDecl;
    private final long bitwiseXorUfDecl;
    private final long bitwiseNotUfDecl;
    private final long leftShiftUfDecl;
    private final long rightShiftUfDecl;
    private final long multUfDecl;
    private final long divUfDecl;
    private final long modUfDecl;

    public ArithmeticMathsatFormulaManager(Configuration config, LogManager logger, boolean pUseIntegers) throws InvalidConfigurationException {
        super(config, logger, pUseIntegers ? 2 : 3);
        this.useIntegers = pUseIntegers;
        int msatVarType = pUseIntegers ? 2 : 3;
        int[] msatVarType1 = new int[]{msatVarType};
        int[] msatVarType2 = new int[]{msatVarType, msatVarType};
        this.bitwiseAndUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_&_", msatVarType, msatVarType2);
        this.bitwiseOrUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_|_", msatVarType, msatVarType2);
        this.bitwiseXorUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_^_", msatVarType, msatVarType2);
        this.bitwiseNotUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_~_", msatVarType, msatVarType1);
        this.leftShiftUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_<<_", msatVarType, msatVarType2);
        this.rightShiftUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_>>_", msatVarType, msatVarType2);
        this.multUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_*_", msatVarType, msatVarType2);
        this.divUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_/_", msatVarType, msatVarType2);
        this.modUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "_%_", msatVarType, msatVarType2);
    }

    @Override
    long createEnvironment(boolean pShared, boolean pGhostFilter) {
        long env = super.createEnvironment(pShared, pGhostFilter);
        if (this.useIntegers) {
            NativeApi.msat_add_theory(env, 3);
            int ok = NativeApi.msat_set_option(env, "split_eq", "false");
            assert (ok == 0);
        } else {
            NativeApi.msat_add_theory(env, 4);
        }
        return env;
    }

    @Override
    long interpreteBitvector(long pBv) {
        throw new UnsupportedOperationException("Bitvector not expected");
    }

    @Override
    public Formula makeNegate(Formula f) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_negate(this.msatEnv, ArithmeticMathsatFormulaManager.getTerm(f)));
    }

    @Override
    public Formula makeNumber(int i) {
        return this.makeNumber(Integer.toString(i));
    }

    @Override
    public Formula makeNumber(String i) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_number(this.msatEnv, i));
    }

    @Override
    public Formula makePlus(Formula f1, Formula f2) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_plus(this.msatEnv, ArithmeticMathsatFormulaManager.getTerm(f1), ArithmeticMathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeMinus(Formula f1, Formula f2) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_minus(this.msatEnv, ArithmeticMathsatFormulaManager.getTerm(f1), ArithmeticMathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeDivide(Formula f1, Formula f2) {
        long result;
        long t1 = ArithmeticMathsatFormulaManager.getTerm(f1);
        long t2 = ArithmeticMathsatFormulaManager.getTerm(f2);
        if (NativeApi.msat_term_is_number(t2) != 0) {
            String[] frac;
            String n = NativeApi.msat_term_repr(t2);
            if (n.startsWith("(")) {
                n = n.substring(1, n.length() - 1);
            }
            if ((frac = n.split("/")).length == 1) {
                n = "1/" + n;
            } else {
                assert (frac.length == 2);
                n = frac[1] + "/" + frac[0];
            }
            t2 = NativeApi.msat_make_number(this.msatEnv, n);
            result = NativeApi.msat_make_times(this.msatEnv, t2, t1);
        } else {
            result = this.buildMsatUF(this.divUfDecl, new long[]{t1, t2});
        }
        return ArithmeticMathsatFormulaManager.encapsulate(result);
    }

    @Override
    public Formula makeModulo(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.modUfDecl);
    }

    @Override
    public Formula makeMultiply(Formula f1, Formula f2) {
        long t1 = ArithmeticMathsatFormulaManager.getTerm(f1);
        long t2 = ArithmeticMathsatFormulaManager.getTerm(f2);
        long result = NativeApi.msat_term_is_number(t1) != 0 ? NativeApi.msat_make_times(this.msatEnv, t1, t2) : (NativeApi.msat_term_is_number(t2) != 0 ? NativeApi.msat_make_times(this.msatEnv, t2, t1) : this.buildMsatUF(this.multUfDecl, new long[]{t1, t2}));
        return ArithmeticMathsatFormulaManager.encapsulate(result);
    }

    @Override
    public Formula makeEqual(Formula f1, Formula f2) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_equal(this.msatEnv, ArithmeticMathsatFormulaManager.getTerm(f1), ArithmeticMathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeGt(Formula f1, Formula f2) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_gt(this.msatEnv, ArithmeticMathsatFormulaManager.getTerm(f1), ArithmeticMathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeGeq(Formula f1, Formula f2) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_geq(this.msatEnv, ArithmeticMathsatFormulaManager.getTerm(f1), ArithmeticMathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeLt(Formula f1, Formula f2) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_lt(this.msatEnv, ArithmeticMathsatFormulaManager.getTerm(f1), ArithmeticMathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeLeq(Formula f1, Formula f2) {
        return ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_make_leq(this.msatEnv, ArithmeticMathsatFormulaManager.getTerm(f1), ArithmeticMathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeBitwiseNot(Formula f) {
        long[] args = new long[]{ArithmeticMathsatFormulaManager.getTerm(f)};
        return ArithmeticMathsatFormulaManager.encapsulate(this.buildMsatUF(this.bitwiseNotUfDecl, args));
    }

    @Override
    public Formula makeBitwiseAnd(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.bitwiseAndUfDecl);
    }

    @Override
    public Formula makeBitwiseOr(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.bitwiseOrUfDecl);
    }

    @Override
    public Formula makeBitwiseXor(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.bitwiseXorUfDecl);
    }

    @Override
    public Formula makeShiftLeft(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.leftShiftUfDecl);
    }

    @Override
    public Formula makeShiftRight(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.rightShiftUfDecl);
    }

    private Formula makeUIFforBinaryOperator(Formula f1, Formula f2, long uifDecl) {
        long[] args = new long[]{ArithmeticMathsatFormulaManager.getTerm(f1), ArithmeticMathsatFormulaManager.getTerm(f2)};
        return ArithmeticMathsatFormulaManager.encapsulate(this.buildMsatUF(uifDecl, args));
    }

    @Override
    public Formula getBitwiseAxioms(Formula f) {
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        HashSet<Formula> seen = new HashSet<Formula>();
        HashSet<Formula> allLiterals = new HashSet<Formula>();
        boolean andFound = false;
        toProcess.add(f);
        while (!toProcess.isEmpty()) {
            String r;
            Formula tt = (Formula)toProcess.pollLast();
            long t = ArithmeticMathsatFormulaManager.getTerm(tt);
            if (NativeApi.msat_term_is_number(t) != 0) {
                allLiterals.add(tt);
            }
            if (NativeApi.msat_term_is_uif(t) != 0 && (r = NativeApi.msat_term_repr(t)).startsWith("_&_")) {
                andFound = true;
            }
            int arity = NativeApi.msat_term_arity(t);
            for (int i = 0; i < arity; ++i) {
                Formula c = ArithmeticMathsatFormulaManager.encapsulate(NativeApi.msat_term_get_arg(t, i));
                if (!seen.add(c)) continue;
                toProcess.add(c);
            }
        }
        long result = NativeApi.msat_make_true(this.msatEnv);
        if (andFound) {
            long z = NativeApi.msat_make_number(this.msatEnv, "0");
            for (Formula nn : allLiterals) {
                long n = ArithmeticMathsatFormulaManager.getTerm(nn);
                long u1 = this.buildMsatUF(this.bitwiseAndUfDecl, new long[]{n, z});
                long u2 = this.buildMsatUF(this.bitwiseAndUfDecl, new long[]{z, n});
                long e1 = NativeApi.msat_make_equal(this.msatEnv, u1, z);
                long e2 = NativeApi.msat_make_equal(this.msatEnv, u2, z);
                long a = NativeApi.msat_make_and(this.msatEnv, e1, e2);
                result = NativeApi.msat_make_and(this.msatEnv, result, a);
            }
        }
        return ArithmeticMathsatFormulaManager.encapsulate(result);
    }
}

