/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.NativeApi;

@Options(prefix="cpa.predicate.mathsat")
public class BitwiseMathsatFormulaManager
extends MathsatFormulaManager {
    private final int bitWidth;
    @Option(description="Whether to use signed or unsigned variables if useBitwise is true.")
    private boolean signed = true;
    private static Pattern BITVECTOR_PATTERN = Pattern.compile("^0d\\d+_(\\d+)$");

    public BitwiseMathsatFormulaManager(Configuration config, LogManager logger, int pBitWidth) throws InvalidConfigurationException {
        super(config, logger, 4 + pBitWidth);
        config.inject((Object)this, BitwiseMathsatFormulaManager.class);
        this.bitWidth = pBitWidth;
    }

    @Override
    long createEnvironment(boolean pShared, boolean pGhostFilter) {
        long env = super.createEnvironment(pShared, pGhostFilter);
        NativeApi.msat_add_theory(env, 5);
        return env;
    }

    @Override
    long interpreteBitvector(long pBv) {
        String lTermRepresentation = NativeApi.msat_term_repr(pBv);
        Matcher matcher = BITVECTOR_PATTERN.matcher(lTermRepresentation);
        if (!matcher.matches()) {
            throw new NumberFormatException("Unknown bitvector format: " + lTermRepresentation);
        }
        String term = matcher.group(1);
        long value = Long.valueOf(term);
        if (this.signed && this.bitWidth <= 63 && value >= 1L << this.bitWidth - 1) {
            value -= 1L << this.bitWidth;
        }
        return value;
    }

    @Override
    public Formula makeNumber(int i) {
        return this.makeNumber(Integer.toString(i));
    }

    @Override
    public Formula makeNumber(String i) {
        i = "0d" + this.bitWidth + "_" + i;
        Formula result = BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_number(this.msatEnv, i));
        return result;
    }

    @Override
    public Formula makeNegate(Formula pF) {
        return this.makeMinus(this.makeNumber(0), pF);
    }

    @Override
    public Formula makePlus(Formula pF1, Formula pF2) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_plus(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeMinus(Formula pF1, Formula pF2) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_minus(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeDivide(Formula pF1, Formula pF2) {
        if (this.signed) {
            return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_sdiv(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
        }
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_udiv(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeModulo(Formula pF1, Formula pF2) {
        if (this.signed) {
            return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_smod(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
        }
        throw new UnsupportedOperationException("Unsigned modulo");
    }

    @Override
    public Formula makeMultiply(Formula pF1, Formula pF2) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_times(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeEqual(Formula pF1, Formula pF2) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_equal(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeGt(Formula pF1, Formula pF2) {
        if (this.signed) {
            return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_sgt(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
        }
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_ugt(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeGeq(Formula pF1, Formula pF2) {
        if (this.signed) {
            return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_sgeq(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
        }
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_ugeq(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeLt(Formula pF1, Formula pF2) {
        if (this.signed) {
            return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_slt(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
        }
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_ult(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeLeq(Formula pF1, Formula pF2) {
        if (this.signed) {
            return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_sgeq(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
        }
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_uleq(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeBitwiseNot(Formula pF) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_not(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF)));
    }

    @Override
    public Formula makeBitwiseAnd(Formula pF1, Formula pF2) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_and(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeBitwiseOr(Formula pF1, Formula pF2) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_or(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeBitwiseXor(Formula pF1, Formula pF2) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_xor(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeShiftLeft(Formula pF1, Formula pAmount) {
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_lsl(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pAmount)));
    }

    @Override
    public Formula makeShiftRight(Formula pF1, Formula pAmount) {
        if (this.signed) {
            return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_asr(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pAmount)));
        }
        return BitwiseMathsatFormulaManager.encapsulate(NativeApi.msat_make_bv_lsr(this.msatEnv, BitwiseMathsatFormulaManager.getTerm(pF1), BitwiseMathsatFormulaManager.getTerm(pAmount)));
    }

    @Override
    public Formula getBitwiseAxioms(Formula pF) {
        return this.makeTrue();
    }
}

