/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormulaList;
import org.sosy_lab.cpachecker.util.predicates.mathsat.NativeApi;

class MathsatFormula
implements Formula,
Serializable {
    private static final long serialVersionUID = 7662624283533815801L;
    private final long msatTerm;

    public MathsatFormula(long t) {
        if (NativeApi.MSAT_ERROR_TERM(t)) {
            throw new IllegalArgumentException("Error term is not a valid formula");
        }
        this.msatTerm = t;
    }

    @Override
    public boolean isFalse() {
        return NativeApi.msat_term_is_false(this.msatTerm) != 0;
    }

    @Override
    public boolean isTrue() {
        return NativeApi.msat_term_is_true(this.msatTerm) != 0;
    }

    public String toString() {
        return NativeApi.msat_term_repr(this.msatTerm);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MathsatFormula)) {
            return false;
        }
        return this.msatTerm == ((MathsatFormula)o).msatTerm;
    }

    long getTerm() {
        return this.msatTerm;
    }

    public int hashCode() {
        return (int)this.msatTerm;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerialProxy(this);
    }

    private static class MathsatFormulaStorage
    implements Serializable {
        private static final long serialVersionUID = -3773448463181606622L;
        private transient ArrayList<Formula> formulaeStorage = new ArrayList();

        public void storeFormula(Formula f) {
            this.formulaeStorage.add(f);
        }

        public Formula restoreFormula() {
            Formula result = this.formulaeStorage.get(0);
            this.formulaeStorage.remove(0);
            return result;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            long[] terms = new long[this.formulaeStorage.size()];
            for (int i = 0; i < this.formulaeStorage.size(); ++i) {
                terms[i] = ((MathsatFormula)this.formulaeStorage.get(i)).msatTerm;
            }
            Formula storageFormula = GlobalInfo.getInstance().getFormulaManager().makeUIP("dummy", new MathsatFormulaList(terms));
            String storageFormulaRepresentation = GlobalInfo.getInstance().getFormulaManager().dumpFormula(storageFormula);
            storageFormulaRepresentation = storageFormulaRepresentation.replaceAll("\"", "");
            int index = storageFormulaRepresentation.indexOf("VAR dummy :");
            String pre = storageFormulaRepresentation.substring(0, index);
            String post = storageFormulaRepresentation.substring(storageFormulaRepresentation.indexOf("\n", index) + 1);
            storageFormulaRepresentation = pre + post;
            out.writeInt(this.formulaeStorage.size());
            out.writeObject(storageFormulaRepresentation);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int storageSize = in.readInt();
            GlobalInfo.getInstance().getFormulaManager().declareUIP("dummy", storageSize);
            Formula storageFormula = GlobalInfo.getInstance().getFormulaManager().parse((String)in.readObject());
            Formula[] formulae = GlobalInfo.getInstance().getFormulaManager().getArguments(storageFormula);
            this.formulaeStorage = new ArrayList(storageSize);
            for (Formula f : formulae) {
                this.formulaeStorage.add(f);
            }
        }
    }

    private static class SerialProxy
    implements Serializable {
        private static final long serialVersionUID = 6889568471468710163L;
        private static transient int storageIndex = -1;

        public SerialProxy(Formula pFormula) {
            if (storageIndex == -1) {
                storageIndex = GlobalInfo.getInstance().addHelperStorage(new MathsatFormulaStorage());
            }
            ((MathsatFormulaStorage)GlobalInfo.getInstance().getHelperStorage(storageIndex)).storeFormula(pFormula);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeInt(storageIndex);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            storageIndex = in.readInt();
        }

        private Object readResolve() throws ObjectStreamException {
            return ((MathsatFormulaStorage)GlobalInfo.getInstance().getHelperStorage(storageIndex)).restoreFormula();
        }
    }
}

