/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat.NativeApi;

public class MathsatFormulaList
implements FormulaList,
Serializable {
    private static final long serialVersionUID = -6546625578464890862L;
    private transient long[] terms;

    public MathsatFormulaList(long ... terms) {
        for (long t : terms) {
            if (!NativeApi.MSAT_ERROR_TERM(t)) continue;
            throw new IllegalArgumentException("Error term is not a valid formula");
        }
        this.terms = terms;
    }

    long[] getTerms() {
        return this.terms;
    }

    public String toString() {
        return Arrays.toString(this.terms);
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof MathsatFormulaList)) {
            return false;
        }
        return Arrays.equals(this.terms, ((MathsatFormulaList)pObj).terms);
    }

    public int hashCode() {
        return Arrays.hashCode(this.terms);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.terms.length);
        for (int i = 0; i < this.terms.length; ++i) {
            out.writeObject(new MathsatFormula(this.terms[i]));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int termCount = in.readInt();
        this.terms = new long[termCount];
        for (int i = 0; i < this.terms.length; ++i) {
            this.terms[i] = ((MathsatFormula)in.readObject()).getTerm();
        }
    }
}

