/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormulaList;
import org.sosy_lab.cpachecker.util.predicates.mathsat.NativeApi;

@Options(prefix="cpa.predicate.mathsat")
public abstract class MathsatFormulaManager
implements FormulaManager {
    @Option(description="use a combination of theories (this is incomplete)")
    private boolean useDtc = false;
    @Option(description="Use UIFs (recommended because its more precise)")
    private boolean useUIFs = true;
    final long msatEnv;
    private final long stringLitUfDecl;
    private final int msatVarType;
    private static final String INDEX_SEPARATOR = "@";
    private static final String UIF_VARIABLE = "__uif__";
    private int uifVariableCounter = 0;
    private final Map<Formula, Boolean> arithCache = new HashMap<Formula, Boolean>();
    private final Map<Formula, Formula> uninstantiateCache = new HashMap<Formula, Formula>();
    private final Formula trueFormula;
    private final Formula falseFormula;

    MathsatFormulaManager(Configuration config, LogManager logger, int pVarType) throws InvalidConfigurationException {
        config.inject((Object)this, MathsatFormulaManager.class);
        this.msatVarType = pVarType;
        this.msatEnv = NativeApi.msat_create_env();
        this.trueFormula = MathsatFormulaManager.encapsulate(NativeApi.msat_make_true(this.msatEnv));
        this.falseFormula = MathsatFormulaManager.encapsulate(NativeApi.msat_make_false(this.msatEnv));
        this.stringLitUfDecl = NativeApi.msat_declare_uif(this.msatEnv, "__string__", this.msatVarType, new int[]{2});
    }

    long getMsatEnv() {
        return this.msatEnv;
    }

    long createEnvironment(boolean shared, boolean ghostFilter) {
        long env = shared ? NativeApi.msat_create_shared_env(this.msatEnv) : NativeApi.msat_create_env();
        NativeApi.msat_add_theory(env, 0);
        if (this.useDtc) {
            NativeApi.msat_set_theory_combination(env, 2);
        }
        NativeApi.msat_set_option(env, "sl", "0");
        if (ghostFilter) {
            NativeApi.msat_set_option(env, "ghost_filter", "true");
        }
        return env;
    }

    static long getTerm(Formula f) {
        return ((MathsatFormula)f).getTerm();
    }

    static long[] getTerm(FormulaList f) {
        return ((MathsatFormulaList)f).getTerms();
    }

    static Formula encapsulate(long t) {
        return new MathsatFormula(t);
    }

    private static FormulaList encapsulate(long[] t) {
        return new MathsatFormulaList(t);
    }

    private static String makeName(String name, int idx) {
        return name + INDEX_SEPARATOR + idx;
    }

    static Pair<String, Integer> parseName(String var) {
        String[] s = var.split(INDEX_SEPARATOR);
        if (s.length != 2) {
            throw new IllegalArgumentException("Not an instantiated variable: " + var);
        }
        return Pair.of((Object)s[0], (Object)Integer.parseInt(s[1]));
    }

    abstract long interpreteBitvector(long var1);

    @Override
    public boolean isBoolean(Formula f) {
        return NativeApi.msat_term_get_type(MathsatFormulaManager.getTerm(f)) == 0;
    }

    @Override
    public Formula makeTrue() {
        return this.trueFormula;
    }

    @Override
    public Formula makeFalse() {
        return this.falseFormula;
    }

    @Override
    public Formula makeNot(Formula f) {
        return MathsatFormulaManager.encapsulate(NativeApi.msat_make_not(this.msatEnv, MathsatFormulaManager.getTerm(f)));
    }

    @Override
    public Formula makeAnd(Formula f1, Formula f2) {
        return MathsatFormulaManager.encapsulate(NativeApi.msat_make_and(this.msatEnv, MathsatFormulaManager.getTerm(f1), MathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeOr(Formula f1, Formula f2) {
        return MathsatFormulaManager.encapsulate(NativeApi.msat_make_or(this.msatEnv, MathsatFormulaManager.getTerm(f1), MathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeEquivalence(Formula f1, Formula f2) {
        return MathsatFormulaManager.encapsulate(NativeApi.msat_make_iff(this.msatEnv, MathsatFormulaManager.getTerm(f1), MathsatFormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeIfThenElse(Formula condition, Formula f1, Formula f2) {
        return MathsatFormulaManager.encapsulate(NativeApi.msat_make_ite(this.msatEnv, MathsatFormulaManager.getTerm(condition), MathsatFormulaManager.getTerm(f1), MathsatFormulaManager.getTerm(f2)));
    }

    private long buildMsatUF(String name, long[] args, boolean predicate) {
        if (!this.useUIFs) {
            return this.buildMsatUfReplacement();
        }
        int[] tp = new int[args.length];
        Arrays.fill(tp, predicate ? 0 : this.msatVarType);
        long decl = NativeApi.msat_declare_uif(this.msatEnv, name, predicate ? 0 : this.msatVarType, tp);
        if (NativeApi.MSAT_ERROR_DECL(decl)) {
            return NativeApi.MSAT_MAKE_ERROR_TERM();
        }
        return this.buildMsatUF(decl, args);
    }

    protected long buildMsatUF(long func, long[] args) {
        if (this.useUIFs) {
            return NativeApi.msat_make_uif(this.msatEnv, func, args);
        }
        return this.buildMsatUfReplacement();
    }

    private long buildMsatUfReplacement() {
        String var = MathsatFormulaManager.makeName(UIF_VARIABLE, ++this.uifVariableCounter);
        long decl = NativeApi.msat_declare_variable(this.msatEnv, var, this.msatVarType);
        return NativeApi.msat_make_variable(this.msatEnv, decl);
    }

    @Override
    public Formula makeUIP(String name, FormulaList args) {
        return MathsatFormulaManager.encapsulate(this.buildMsatUF(name, MathsatFormulaManager.getTerm(args), true));
    }

    @Override
    public Formula makeUIF(String name, FormulaList args) {
        return MathsatFormulaManager.encapsulate(this.buildMsatUF(name, MathsatFormulaManager.getTerm(args), false));
    }

    @Override
    public Formula makeUIF(String name, FormulaList args, int idx) {
        return MathsatFormulaManager.encapsulate(this.buildMsatUF(MathsatFormulaManager.makeName(name, idx), MathsatFormulaManager.getTerm(args), false));
    }

    @Override
    public Formula makeString(int i) {
        long n = NativeApi.msat_make_number(this.msatEnv, Integer.toString(i));
        return MathsatFormulaManager.encapsulate(this.buildMsatUF(this.stringLitUfDecl, new long[]{n}));
    }

    private long buildMsatVariable(String var, int type) {
        long decl = NativeApi.msat_declare_variable(this.msatEnv, var, type);
        return NativeApi.msat_make_variable(this.msatEnv, decl);
    }

    @Override
    public Formula makeVariable(String var, int idx) {
        return this.makeVariable(MathsatFormulaManager.makeName(var, idx));
    }

    @Override
    public Formula makeVariable(String var) {
        return MathsatFormulaManager.encapsulate(this.buildMsatVariable(var, this.msatVarType));
    }

    @Override
    public Formula makePredicateVariable(String var, int idx) {
        String name = MathsatFormulaManager.makeName("PRED" + var, idx);
        long decl = NativeApi.msat_declare_variable(this.msatEnv, name, 0);
        return MathsatFormulaManager.encapsulate(NativeApi.msat_make_variable(this.msatEnv, decl));
    }

    @Override
    public Formula makeAssignment(Formula f1, Formula f2) {
        return this.makeEqual(f1, f2);
    }

    @Override
    public FormulaList makeList(Formula pF) {
        return new MathsatFormulaList(MathsatFormulaManager.getTerm(pF));
    }

    @Override
    public FormulaList makeList(Formula pF1, Formula pF2) {
        return new MathsatFormulaList(MathsatFormulaManager.getTerm(pF1), MathsatFormulaManager.getTerm(pF2));
    }

    @Override
    public FormulaList makeList(List<Formula> pFs) {
        long[] t = new long[pFs.size()];
        for (int i = 0; i < t.length; ++i) {
            t[i] = MathsatFormulaManager.getTerm(pFs.get(i));
        }
        return MathsatFormulaManager.encapsulate(t);
    }

    @Override
    public Formula createPredicateVariable(Formula atom) {
        long t = MathsatFormulaManager.getTerm(atom);
        String repr = NativeApi.msat_term_is_atom(t) != 0 ? NativeApi.msat_term_repr(t) : "#" + NativeApi.msat_term_id(t);
        long d = NativeApi.msat_declare_variable(this.msatEnv, "\"PRED" + repr + "\"", 0);
        long var = NativeApi.msat_make_variable(this.msatEnv, d);
        return MathsatFormulaManager.encapsulate(var);
    }

    @Override
    public String dumpFormula(Formula f) {
        return NativeApi.msat_to_msat(this.msatEnv, MathsatFormulaManager.getTerm(f));
    }

    @Override
    public Formula parseInfix(String s) {
        long f = NativeApi.msat_from_string(this.msatEnv, s);
        Preconditions.checkArgument((!NativeApi.MSAT_ERROR_TERM(f) ? 1 : 0) != 0, (String)"Could not parse formula %s as Mathsat formula.", (Object[])new Object[]{s});
        return MathsatFormulaManager.encapsulate(f);
    }

    @Override
    public Formula parse(String s) {
        long f = NativeApi.msat_from_msat(this.msatEnv, s);
        Preconditions.checkArgument((!NativeApi.MSAT_ERROR_TERM(f) ? 1 : 0) != 0, (String)"Could not parse formula %s as Mathsat formula.", (Object[])new Object[]{s});
        return MathsatFormulaManager.encapsulate(f);
    }

    @Override
    public Formula instantiate(Formula f, SSAMap ssa) {
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        HashMap<Formula, Formula> cache = new HashMap<Formula, Formula>();
        toProcess.push(f);
        while (!toProcess.isEmpty()) {
            long newt;
            Formula tt = (Formula)toProcess.peek();
            if (cache.containsKey(tt)) {
                toProcess.pop();
                continue;
            }
            long t = MathsatFormulaManager.getTerm(tt);
            if (NativeApi.msat_term_is_variable(t) != 0) {
                toProcess.pop();
                String name = NativeApi.msat_term_repr(t);
                int idx = ssa.getIndex(name);
                if (idx > 0) {
                    long newt2 = this.buildMsatVariable(MathsatFormulaManager.makeName(name, idx), NativeApi.msat_term_get_type(t));
                    cache.put(tt, MathsatFormulaManager.encapsulate(newt2));
                    continue;
                }
                cache.put(tt, tt);
                continue;
            }
            boolean childrenDone = true;
            long[] newargs = new long[NativeApi.msat_term_arity(t)];
            for (int i = 0; i < newargs.length; ++i) {
                Formula c = MathsatFormulaManager.encapsulate(NativeApi.msat_term_get_arg(t, i));
                Formula newC = (Formula)cache.get(c);
                if (newC != null) {
                    newargs[i] = MathsatFormulaManager.getTerm(newC);
                    continue;
                }
                toProcess.push(c);
                childrenDone = false;
            }
            if (!childrenDone) continue;
            toProcess.pop();
            if (NativeApi.msat_term_is_uif(t) != 0) {
                int idx;
                String name = NativeApi.msat_decl_get_name(NativeApi.msat_term_get_decl(t));
                assert (name != null);
                newt = this.ufCanBeLvalue(name) ? ((idx = ssa.getIndex(name, MathsatFormulaManager.encapsulate(newargs))) > 0 ? this.buildMsatUF(MathsatFormulaManager.makeName(name, idx), newargs, false) : NativeApi.msat_replace_args(this.msatEnv, t, newargs)) : NativeApi.msat_replace_args(this.msatEnv, t, newargs);
            } else {
                newt = NativeApi.msat_replace_args(this.msatEnv, t, newargs);
            }
            cache.put(tt, MathsatFormulaManager.encapsulate(newt));
        }
        Formula result = (Formula)cache.get(f);
        assert (result != null);
        return result;
    }

    private boolean ufCanBeLvalue(String name) {
        return name.startsWith(".{") || name.startsWith("->{");
    }

    @Override
    public Formula uninstantiate(Formula f) {
        Map<Formula, Formula> cache = this.uninstantiateCache;
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        toProcess.push(f);
        while (!toProcess.isEmpty()) {
            long newt;
            Formula tt = (Formula)toProcess.peek();
            if (cache.containsKey(tt)) {
                toProcess.pop();
                continue;
            }
            long t = MathsatFormulaManager.getTerm(tt);
            if (NativeApi.msat_term_is_variable(t) != 0) {
                String name = (String)MathsatFormulaManager.parseName(NativeApi.msat_term_repr(t)).getFirst();
                long newt2 = this.buildMsatVariable(name, NativeApi.msat_term_get_type(t));
                cache.put(tt, MathsatFormulaManager.encapsulate(newt2));
                continue;
            }
            boolean childrenDone = true;
            long[] newargs = new long[NativeApi.msat_term_arity(t)];
            for (int i = 0; i < newargs.length; ++i) {
                Formula c = MathsatFormulaManager.encapsulate(NativeApi.msat_term_get_arg(t, i));
                Formula newC = cache.get(c);
                if (newC != null) {
                    newargs[i] = MathsatFormulaManager.getTerm(newC);
                    continue;
                }
                toProcess.push(c);
                childrenDone = false;
            }
            if (!childrenDone) continue;
            toProcess.pop();
            if (NativeApi.msat_term_is_uif(t) != 0) {
                String name = NativeApi.msat_decl_get_name(NativeApi.msat_term_get_decl(t));
                assert (name != null);
                if (this.ufCanBeLvalue(name)) {
                    name = (String)MathsatFormulaManager.parseName(name).getFirst();
                    newt = this.buildMsatUF(name, newargs, false);
                } else {
                    newt = NativeApi.msat_replace_args(this.msatEnv, t, newargs);
                }
            } else {
                newt = NativeApi.msat_replace_args(this.msatEnv, t, newargs);
            }
            cache.put(tt, MathsatFormulaManager.encapsulate(newt));
        }
        Formula result = cache.get(f);
        assert (result != null);
        return result;
    }

    @Override
    public Collection<Formula> extractAtoms(Formula f, boolean splitArithEqualities, boolean conjunctionsOnly) {
        HashSet<Formula> cache = new HashSet<Formula>();
        ArrayList<Formula> atoms = new ArrayList<Formula>();
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        toProcess.push(f);
        while (!toProcess.isEmpty()) {
            Formula tt = (Formula)toProcess.pop();
            long t = MathsatFormulaManager.getTerm(tt);
            assert (!cache.contains(tt));
            cache.add(tt);
            if (NativeApi.msat_term_is_true(t) != 0 || NativeApi.msat_term_is_false(t) != 0) continue;
            if (NativeApi.msat_term_is_atom(t) != 0) {
                tt = this.uninstantiate(tt);
                t = MathsatFormulaManager.getTerm(tt);
                if (splitArithEqualities && NativeApi.msat_term_is_equal(t) != 0 && this.isPurelyArithmetic(tt)) {
                    long a1 = NativeApi.msat_term_get_arg(t, 0);
                    long a2 = NativeApi.msat_term_get_arg(t, 1);
                    long t1 = NativeApi.msat_make_leq(this.msatEnv, a1, a2);
                    Formula tt1 = MathsatFormulaManager.encapsulate(t1);
                    cache.add(tt1);
                    atoms.add(tt1);
                    atoms.add(tt);
                    continue;
                }
                atoms.add(tt);
                continue;
            }
            if (conjunctionsOnly && NativeApi.msat_term_is_not(t) == 0 && NativeApi.msat_term_is_and(t) == 0) {
                atoms.add(this.uninstantiate(tt));
                continue;
            }
            for (int i = 0; i < NativeApi.msat_term_arity(t); ++i) {
                Formula c = MathsatFormulaManager.encapsulate(NativeApi.msat_term_get_arg(t, i));
                if (cache.contains(c)) continue;
                toProcess.push(c);
            }
        }
        return atoms;
    }

    @Override
    public Set<String> extractVariables(Formula f) {
        HashSet<Formula> seen = new HashSet<Formula>();
        HashSet<String> vars = new HashSet<String>();
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        toProcess.push(f);
        while (!toProcess.isEmpty()) {
            long t = MathsatFormulaManager.getTerm((Formula)toProcess.pop());
            if (NativeApi.msat_term_is_true(t) != 0 || NativeApi.msat_term_is_false(t) != 0) continue;
            if (NativeApi.msat_term_is_variable(t) != 0) {
                vars.add(NativeApi.msat_term_repr(t));
                continue;
            }
            for (int i = 0; i < NativeApi.msat_term_arity(t); ++i) {
                Formula c = MathsatFormulaManager.encapsulate(NativeApi.msat_term_get_arg(t, i));
                if (!seen.add(c)) continue;
                toProcess.push(c);
            }
        }
        return vars;
    }

    private boolean isPurelyArithmetic(Formula f) {
        Boolean result = this.arithCache.get(f);
        if (result != null) {
            return result;
        }
        long t = MathsatFormulaManager.getTerm(f);
        boolean res = true;
        if (NativeApi.msat_term_is_uif(t) != 0) {
            res = false;
        } else {
            int arity = NativeApi.msat_term_arity(t);
            for (int i = 0; i < arity && (res |= this.isPurelyArithmetic(MathsatFormulaManager.encapsulate(NativeApi.msat_term_get_arg(t, i)))); ++i) {
            }
        }
        this.arithCache.put(f, res);
        return res;
    }

    @Override
    public boolean checkSyntacticEntails(Formula leftFormula, Formula rightFormula) {
        long leftTerm = MathsatFormulaManager.getTerm(leftFormula);
        ArrayDeque<Long> toProcess = new ArrayDeque<Long>();
        HashSet<Long> seen = new HashSet<Long>();
        toProcess.push(MathsatFormulaManager.getTerm(rightFormula));
        while (!toProcess.isEmpty()) {
            long rightSubTerm = (Long)toProcess.pop();
            if (rightSubTerm == leftTerm) {
                return true;
            }
            if (NativeApi.msat_term_is_variable(rightSubTerm) != 0) continue;
            int args = NativeApi.msat_term_arity(rightSubTerm);
            for (int i = 0; i < args; ++i) {
                long arg = NativeApi.msat_term_get_arg(rightSubTerm, i);
                if (seen.contains(arg)) continue;
                toProcess.add(arg);
                seen.add(arg);
            }
        }
        return false;
    }

    @Override
    public Formula[] getArguments(Formula f) {
        long t = MathsatFormulaManager.getTerm(f);
        int arity = NativeApi.msat_term_arity(t);
        Formula[] result = new Formula[arity];
        for (int i = 0; i < arity; ++i) {
            result[i] = MathsatFormulaManager.encapsulate(NativeApi.msat_term_get_arg(t, i));
        }
        return result;
    }

    @Override
    public void declareUIP(String name, int argCount) {
        int[] tp = new int[argCount];
        Arrays.fill(tp, 0);
        NativeApi.msat_declare_uif(this.msatEnv, name, 0, tp);
    }

    @Override
    public String getVersion() {
        return "MathSAT 4";
    }
}

