/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingTheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatModel;
import org.sosy_lab.cpachecker.util.predicates.mathsat.NativeApi;

public class MathsatInterpolatingProver
implements InterpolatingTheoremProver<Integer> {
    private final MathsatFormulaManager mgr;
    private long env;
    private final boolean useSharedEnv;

    public MathsatInterpolatingProver(MathsatFormulaManager pMgr, boolean shared) {
        this.mgr = pMgr;
        this.env = 0L;
        this.useSharedEnv = shared;
    }

    @Override
    public void init() {
        Preconditions.checkState((this.env == 0L ? 1 : 0) != 0);
        this.env = this.mgr.createEnvironment(this.useSharedEnv, false);
        int ok = NativeApi.msat_init_interpolation(this.env);
        assert (ok == 0);
    }

    @Override
    public Integer addFormula(Formula f) {
        Preconditions.checkState((this.env != 0L ? 1 : 0) != 0);
        long t = ((MathsatFormula)f).getTerm();
        if (!this.useSharedEnv) {
            t = NativeApi.msat_make_copy_from(this.env, t, this.mgr.getMsatEnv());
        }
        int group = NativeApi.msat_create_itp_group(this.env);
        NativeApi.msat_set_itp_group(this.env, group);
        NativeApi.msat_assert_formula(this.env, t);
        return group;
    }

    @Override
    public boolean isUnsat() {
        Preconditions.checkState((this.env != 0L ? 1 : 0) != 0);
        int res = NativeApi.msat_solve(this.env);
        assert (res != -1);
        return res == 0;
    }

    @Override
    public Formula getInterpolant(List<Integer> formulasOfA) {
        Preconditions.checkState((this.env != 0L ? 1 : 0) != 0);
        int[] groupsOfA = new int[formulasOfA.size()];
        int i = 0;
        for (Integer f : formulasOfA) {
            groupsOfA[i++] = f;
        }
        long itp = NativeApi.msat_get_interpolant(this.env, groupsOfA);
        assert (!NativeApi.MSAT_ERROR_TERM(itp));
        if (!this.useSharedEnv) {
            itp = NativeApi.msat_make_copy_from(this.mgr.getMsatEnv(), itp, this.env);
        }
        return new MathsatFormula(itp);
    }

    @Override
    public void reset() {
        Preconditions.checkState((this.env != 0L ? 1 : 0) != 0);
        NativeApi.msat_destroy_env(this.env);
        this.env = 0L;
    }

    @Override
    public Model getModel() {
        Preconditions.checkState((this.env != 0L ? 1 : 0) != 0);
        return MathsatModel.createMathsatModel(this.env, this.mgr);
    }
}

