/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.mathsat.ArithmeticMathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.NativeApi;

public class MathsatModel {
    private static Model.TermType toMathsatType(int pTypeId) {
        switch (pTypeId) {
            case 0: {
                return Model.TermType.Boolean;
            }
            case 1: {
                return Model.TermType.Uninterpreted;
            }
            case 2: {
                return Model.TermType.Integer;
            }
            case 3: {
                return Model.TermType.Real;
            }
        }
        if (pTypeId <= 4) {
            throw new IllegalArgumentException("Given parameter is not a mathsat type!");
        }
        return Model.TermType.Bitvector;
    }

    private static Model.Variable toVariable(long pVariableId) {
        if (NativeApi.msat_term_is_variable(pVariableId) == 0) {
            throw new IllegalArgumentException("Given mathsat id doesn't correspond to a variable! (" + NativeApi.msat_term_repr(pVariableId) + ")");
        }
        long lDeclarationId = NativeApi.msat_term_get_decl(pVariableId);
        String lName = NativeApi.msat_decl_get_name(lDeclarationId);
        Model.TermType lType = MathsatModel.toMathsatType(NativeApi.msat_decl_get_return_type(lDeclarationId));
        Pair<String, Integer> lSplitName = ArithmeticMathsatFormulaManager.parseName(lName);
        return new Model.Variable((String)lSplitName.getFirst(), (Integer)lSplitName.getSecond(), lType);
    }

    private static Model.Function toFunction(long pFunctionId) {
        if (NativeApi.msat_term_is_variable(pFunctionId) != 0) {
            throw new IllegalArgumentException("Given mathsat id is a variable! (" + NativeApi.msat_term_repr(pFunctionId) + ")");
        }
        long lDeclarationId = NativeApi.msat_term_get_decl(pFunctionId);
        String lName = NativeApi.msat_decl_get_name(lDeclarationId);
        Model.TermType lType = MathsatModel.toMathsatType(NativeApi.msat_decl_get_return_type(lDeclarationId));
        int lArity = NativeApi.msat_decl_get_arity(lDeclarationId);
        Object[] lArguments = new Object[lArity];
        for (int lArgumentIndex = 0; lArgumentIndex < lArity; ++lArgumentIndex) {
            Double lValue;
            long lArgument = NativeApi.msat_term_get_arg(pFunctionId, lArgumentIndex);
            String lTermRepresentation = NativeApi.msat_term_repr(lArgument);
            try {
                lValue = Double.valueOf(lTermRepresentation);
            }
            catch (NumberFormatException e) {
                String[] lNumbers = lTermRepresentation.split("/");
                if (lNumbers.length != 2) {
                    throw new NumberFormatException("Unknown number format: " + lTermRepresentation);
                }
                double lNumerator = Double.valueOf(lNumbers[0]);
                double lDenominator = Double.valueOf(lNumbers[1]);
                lValue = lNumerator / lDenominator;
            }
            lArguments[lArgumentIndex] = lValue;
        }
        return new Model.Function(lName, lType, lArguments);
    }

    private static Model.AssignableTerm toAssignable(long pTermId) {
        long lDeclarationId = NativeApi.msat_term_get_decl(pTermId);
        if (NativeApi.MSAT_ERROR_DECL(lDeclarationId)) {
            throw new IllegalArgumentException("No declaration available!");
        }
        if (NativeApi.msat_term_is_variable(pTermId) == 0) {
            return MathsatModel.toFunction(pTermId);
        }
        return MathsatModel.toVariable(pTermId);
    }

    static Model createMathsatModel(long lMathsatEnvironmentID, MathsatFormulaManager fmgr) {
        ImmutableMap.Builder model = ImmutableMap.builder();
        long modelFormula = NativeApi.msat_make_true(lMathsatEnvironmentID);
        long lModelIterator = NativeApi.msat_create_model_iterator(lMathsatEnvironmentID);
        if (NativeApi.MSAT_ERROR_MODEL_ITERATOR(lModelIterator)) {
            throw new RuntimeException("Erroneous model iterator! (" + lModelIterator + ")");
        }
        while (NativeApi.msat_model_iterator_has_next(lModelIterator) != 0) {
            Comparable<Boolean> lValue;
            long[] lModelElement = NativeApi.msat_model_iterator_next(lModelIterator);
            long lKeyTerm = lModelElement[0];
            long lValueTerm = lModelElement[1];
            long equivalence = NativeApi.msat_make_equal(lMathsatEnvironmentID, lKeyTerm, lValueTerm);
            modelFormula = NativeApi.msat_make_and(lMathsatEnvironmentID, modelFormula, equivalence);
            Model.AssignableTerm lAssignable = MathsatModel.toAssignable(lKeyTerm);
            if (NativeApi.msat_term_is_number(lValueTerm) == 0 && NativeApi.msat_term_is_boolean_var(lValueTerm) == 0) {
                throw new IllegalArgumentException("Mathsat term is not a number!");
            }
            String lTermRepresentation = NativeApi.msat_term_repr(lValueTerm);
            switch (lAssignable.getType()) {
                case Boolean: {
                    lValue = Boolean.valueOf(lTermRepresentation);
                    break;
                }
                case Real: {
                    try {
                        lValue = Double.valueOf(lTermRepresentation);
                    }
                    catch (NumberFormatException e) {
                        String[] lNumbers = lTermRepresentation.split("/");
                        if (lNumbers.length != 2) {
                            throw new NumberFormatException("Unknown number format: " + lTermRepresentation);
                        }
                        double lNumerator = Double.valueOf(lNumbers[0]);
                        double lDenominator = Double.valueOf(lNumbers[1]);
                        lValue = lNumerator / lDenominator;
                    }
                    break;
                }
                case Integer: {
                    lValue = Long.valueOf(lTermRepresentation);
                    break;
                }
                case Bitvector: {
                    lValue = fmgr.interpreteBitvector(lValueTerm);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Mathsat term with unhandled type " + (Object)((Object)lAssignable.getType()));
                }
            }
            model.put((Object)lAssignable, (Object)lValue);
        }
        NativeApi.msat_destroy_model_iterator(lModelIterator);
        return new Model((Map<Model.AssignableTerm, Object>)model.build(), ArithmeticMathsatFormulaManager.encapsulate(modelFormula));
    }
}

