/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat.MathsatTheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat.NativeApi;
import yices.YicesLite;

public class YicesTheoremProver
implements TheoremProver {
    private final Map<Long, String> msatVarToYicesVar = new HashMap<Long, String>();
    private final Map<Long, String> msatToYicesCache = new HashMap<Long, String>();
    private final Map<String, Long> yicesPredToMsat = new HashMap<String, Long>();
    private int curVarIndex = 1;
    private final int yicesContext;
    private final YicesLite yicesManager = new YicesLite();
    private final MathsatFormulaManager smgr;
    private final Deque<Collection<String>> declStack;
    private final Set<String> globalDecls;
    private int curLevel = 0;

    public YicesTheoremProver(MathsatFormulaManager mgr, LogManager logger) {
        this.yicesContext = this.yicesManager.yicesl_mk_context();
        this.yicesManager.yicesl_set_verbosity((short)0);
        this.yicesManager.yicesl_set_output_file("/dev/null");
        logger.log(Level.FINEST, new Object[]{"Using Yices version", this.yicesManager.yicesl_version()});
        this.smgr = mgr;
        this.declStack = new ArrayDeque<Collection<String>>();
        this.globalDecls = new HashSet<String>();
    }

    private Pair<Collection<String>, String> toYices(MathsatFormula f) {
        ArrayDeque<Long> toProcess = new ArrayDeque<Long>();
        ArrayList<String> decls = new ArrayList<String>();
        toProcess.push(f.getTerm());
        while (!toProcess.isEmpty()) {
            long term = (Long)toProcess.peek();
            if (this.msatToYicesCache.containsKey(term)) {
                toProcess.pop();
                continue;
            }
            boolean childrenDone = true;
            Object[] children = new String[NativeApi.msat_term_arity(term)];
            for (int i = 0; i < NativeApi.msat_term_arity(term); ++i) {
                long c = NativeApi.msat_term_get_arg(term, i);
                if (this.msatToYicesCache.containsKey(c)) {
                    children[i] = this.msatToYicesCache.get(c);
                    continue;
                }
                childrenDone = false;
                toProcess.push(c);
            }
            if (!childrenDone) continue;
            toProcess.pop();
            if (NativeApi.msat_term_is_variable(term) != 0) {
                long d = NativeApi.msat_term_get_decl(term);
                String yicesVar = null;
                if (!this.msatVarToYicesVar.containsKey(d)) {
                    yicesVar = "v" + this.curVarIndex++;
                    String decl = null;
                    decl = NativeApi.msat_term_is_boolean_var(term) != 0 ? "(define " + yicesVar + "::bool)" : "(define " + yicesVar + "::int)";
                    this.msatVarToYicesVar.put(d, yicesVar);
                    decls.add(decl);
                } else {
                    yicesVar = this.msatVarToYicesVar.get(d);
                }
                this.msatToYicesCache.put(term, yicesVar);
                continue;
            }
            if (NativeApi.msat_term_is_uif(term) != 0) {
                long d = NativeApi.msat_term_get_decl(term);
                String yicesFun = null;
                if (!this.msatVarToYicesVar.containsKey(d)) {
                    yicesFun = "f" + this.curVarIndex++;
                    StringBuilder tp = new StringBuilder();
                    tp.append("(->");
                    int arity = NativeApi.msat_term_arity(term);
                    for (int i = 0; i < arity; ++i) {
                        tp.append(" int");
                    }
                    tp.append(" int)");
                    String decl = "(define " + yicesFun + "::" + tp + ")";
                    this.msatVarToYicesVar.put(d, yicesFun);
                    decls.add(decl);
                } else {
                    yicesFun = this.msatVarToYicesVar.get(d);
                }
                String s = "(" + yicesFun + " " + Joiner.on((char)' ').join(children) + ")";
                this.msatToYicesCache.put(term, s);
                continue;
            }
            if (NativeApi.msat_term_is_number(term) != 0) {
                this.msatToYicesCache.put(term, NativeApi.msat_term_repr(term));
                continue;
            }
            if (NativeApi.msat_term_is_true(term) != 0) {
                this.msatToYicesCache.put(term, "true");
                continue;
            }
            if (NativeApi.msat_term_is_false(term) != 0) {
                this.msatToYicesCache.put(term, "false");
                continue;
            }
            String op = null;
            if (NativeApi.msat_term_is_bool_ite(term) != 0 || NativeApi.msat_term_is_term_ite(term) != 0) {
                op = "ite";
            } else if (NativeApi.msat_term_is_and(term) != 0) {
                op = "and";
            } else if (NativeApi.msat_term_is_or(term) != 0) {
                op = "or";
            } else if (NativeApi.msat_term_is_not(term) != 0) {
                op = "not";
            } else if (NativeApi.msat_term_is_implies(term) != 0) {
                op = "=>";
            } else if (NativeApi.msat_term_is_iff(term) != 0) {
                op = "=";
            } else if (NativeApi.msat_term_is_equal(term) != 0) {
                op = "=";
            } else if (NativeApi.msat_term_is_lt(term) != 0) {
                op = "<";
            } else if (NativeApi.msat_term_is_leq(term) != 0) {
                op = "<=";
            } else if (NativeApi.msat_term_is_gt(term) != 0) {
                op = ">";
            } else if (NativeApi.msat_term_is_geq(term) != 0) {
                op = ">=";
            } else if (NativeApi.msat_term_is_plus(term) != 0) {
                op = "+";
            } else if (NativeApi.msat_term_is_minus(term) != 0) {
                op = "-";
            } else if (NativeApi.msat_term_is_times(term) != 0) {
                op = "*";
            } else if (NativeApi.msat_term_is_negate(term) != 0) {
                op = "-";
            } else {
                throw new IllegalArgumentException("UNRECOGNIZED TERM: " + NativeApi.msat_term_repr(term));
            }
            String s = "(" + op;
            for (Object c : children) {
                s = s + " " + (String)c;
            }
            s = s + ")";
            this.msatToYicesCache.put(term, s);
        }
        return Pair.of(decls, (Object)this.msatToYicesCache.get(f.getTerm()));
    }

    private Pair<Collection<String>, String> toYices(Formula f) {
        return this.toYices((MathsatFormula)f);
    }

    private int yicesCommand(String cmd, boolean ignoreError) {
        int ret = this.yicesManager.yicesl_read(this.yicesContext, cmd);
        if (ret == 0 && !ignoreError) {
            throw new IllegalStateException("YICES ERROR: " + this.yicesManager.yicesl_get_last_error_message());
        }
        assert (ignoreError || ret != 0);
        return ret;
    }

    private int yicesCommand(String cmd) {
        return this.yicesCommand(cmd, false);
    }

    private boolean yicesInconsistent() {
        return this.yicesManager.yicesl_inconsistent(this.yicesContext) != 0;
    }

    private List<MathsatFormula> parseMsatPredicates(Set<String> yicesPreds, Scanner s) {
        String l;
        String status;
        if (s.hasNextLine() && !(status = s.nextLine()).startsWith("sat")) {
            return null;
        }
        ArrayList<MathsatFormula> model = new ArrayList<MathsatFormula>();
        Pattern mp = Pattern.compile("^\\(= ([a-z0-9]+) (true|false)\\) *$");
        while (s.hasNextLine() && !(l = s.nextLine()).isEmpty()) {
            Matcher match = mp.matcher(l);
            if (!match.matches()) continue;
            String name = match.group(1);
            String value = match.group(2);
            if (!yicesPreds.contains(name)) continue;
            MathsatFormula msatPred = new MathsatFormula(this.yicesPredToMsat.get(name));
            if (value.equals("false")) {
                msatPred = (MathsatFormula)this.smgr.makeNot(msatPred);
            }
            model.add(msatPred);
        }
        return model;
    }

    private Set<String> toYicesPreds(Collection<Formula> important) {
        HashSet<String> ret = new HashSet<String>(important.size());
        for (Formula f : important) {
            long pred = ((MathsatFormula)f).getTerm();
            assert (NativeApi.msat_term_is_boolean_var(pred) != 0);
            long d = NativeApi.msat_term_get_decl(pred);
            assert (this.msatVarToYicesVar.containsKey(d));
            String name = this.msatVarToYicesVar.get(d);
            ret.add(name);
            this.yicesPredToMsat.put(name, pred);
        }
        return ret;
    }

    @Override
    public TheoremProver.AllSatResult allSat(Formula f, Collection<Formula> important, AbstractionManager.RegionCreator rmgr, Timer timer) {
        MathsatTheoremProver.MathsatAllSatCallback callback = new MathsatTheoremProver.MathsatAllSatCallback(rmgr, timer);
        Pair<Collection<String>, String> yicesFormula = this.toYices(f);
        Set<String> yicesPreds = this.toYicesPreds(important);
        for (String decl : (Collection)yicesFormula.getFirst()) {
            this.yicesManager.yicesl_read(this.yicesContext, decl);
        }
        this.yicesCommand("(push)");
        File tmpForModel = null;
        Scanner modelScanner = null;
        try {
            tmpForModel = File.createTempFile("cpachecker", "yices_allsat");
            modelScanner = new Scanner(tmpForModel);
        }
        catch (IOException e1) {
            throw new IllegalStateException(e1);
        }
        String filename = tmpForModel.getAbsolutePath();
        this.yicesManager.yicesl_set_output_file(filename);
        this.yicesCommand("(set-evidence! true)");
        this.yicesCommand("(assert " + (String)yicesFormula.getSecond() + ")");
        while (true) {
            this.yicesCommand("(check)");
            List<MathsatFormula> model = this.parseMsatPredicates(yicesPreds, modelScanner);
            if (model == null) break;
            if (model.size() == 0) {
                callback.setInfiniteNumberOfModels();
                break;
            }
            long[] amodel = new long[model.size()];
            for (int i = 0; i < model.size(); ++i) {
                amodel[i] = model.get(i).getTerm();
            }
            callback.callback(amodel);
            StringBuilder buf = new StringBuilder();
            for (MathsatFormula m : model) {
                String yv;
                long d;
                long t = m.getTerm();
                if (NativeApi.msat_term_is_not(t) != 0) {
                    t = NativeApi.msat_term_get_arg(t, 0);
                    assert (NativeApi.msat_term_is_boolean_var(t) != 0);
                    d = NativeApi.msat_term_get_decl(t);
                    yv = this.msatVarToYicesVar.get(d);
                    assert (yv != null);
                    buf.append(yv + " ");
                    continue;
                }
                assert (NativeApi.msat_term_is_boolean_var(t) != 0);
                d = NativeApi.msat_term_get_decl(t);
                yv = this.msatVarToYicesVar.get(d);
                assert (yv != null);
                buf.append("(not " + yv + ") ");
            }
            if (model.size() == 1) {
                this.yicesCommand("(assert " + buf + ")");
                continue;
            }
            this.yicesCommand("(assert (or " + buf + "))");
        }
        this.yicesManager.yicesl_set_output_file("/dev/null");
        this.yicesCommand("(pop)");
        this.yicesCommand("(set-evidence! false)");
        modelScanner.close();
        tmpForModel.delete();
        return callback;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isUnsat() {
        return this.yicesInconsistent();
    }

    @Override
    public void pop() {
        this.yicesCommand("(pop)");
        --this.curLevel;
        assert (this.curLevel >= 0);
        if (!this.declStack.isEmpty()) {
            Collection<String> decls = this.declStack.pop();
            for (String d : decls) {
                if (this.globalDecls.contains(d)) continue;
                this.yicesCommand(d, true);
            }
            if (!this.declStack.isEmpty()) {
                this.declStack.peek().addAll(decls);
            } else {
                this.globalDecls.addAll(decls);
            }
        }
    }

    @Override
    public void push(Formula f) {
        this.yicesCommand("(push)");
        ++this.curLevel;
        Pair<Collection<String>, String> p = this.toYices(f);
        for (String d : (Collection)p.getFirst()) {
            this.yicesCommand(d);
        }
        this.declStack.push((Collection<String>)p.getFirst());
        this.yicesCommand("(assert " + (String)p.getSecond() + ")");
    }

    @Override
    public void reset() {
    }

    @Override
    public Model getModel() {
        return new Model(this.smgr);
    }
}

