/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import java.util.ArrayDeque;
import java.util.HashSet;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

public class ArithmeticMathsat5FormulaManager
extends Mathsat5FormulaManager {
    private final long bitwiseAndUfDecl;
    private final long bitwiseOrUfDecl;
    private final long bitwiseXorUfDecl;
    private final long bitwiseNotUfDecl;
    private final long leftShiftUfDecl;
    private final long rightShiftUfDecl;
    private final long multUfDecl;
    private final long divUfDecl;
    private final long modUfDecl;

    public ArithmeticMathsat5FormulaManager(Configuration config, LogManager logger, final boolean pUseIntegers) throws InvalidConfigurationException {
        super(config, logger, new Mathsat5FormulaManager.MsatType(){

            @Override
            public long getVariableType(long pMsatEnv) {
                return pUseIntegers ? Mathsat5NativeApi.msat_get_integer_type(pMsatEnv) : Mathsat5NativeApi.msat_get_rational_type(pMsatEnv);
            }
        });
        long functionType2 = Mathsat5NativeApi.msat_get_function_type(this.msatEnv, new long[]{this.msatVarType, this.msatVarType}, 2, this.msatVarType);
        long functionType1 = Mathsat5NativeApi.msat_get_function_type(this.msatEnv, new long[]{this.msatVarType}, 1, this.msatVarType);
        this.bitwiseAndUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_&_", functionType2);
        this.bitwiseOrUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_|_", functionType2);
        this.bitwiseXorUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_^_", functionType2);
        this.bitwiseNotUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_~_", functionType1);
        this.leftShiftUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_<<_", functionType2);
        this.rightShiftUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_>>_", functionType2);
        this.multUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_*_", functionType2);
        this.divUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_/_", functionType2);
        this.modUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "_%_", functionType2);
    }

    @Override
    long createEnvironment(long cfg, boolean pShared, boolean pGhostFilter) {
        long env = super.createEnvironment(cfg, pShared, pGhostFilter);
        return env;
    }

    @Override
    long interpreteBitvector(long pBv) {
        throw new UnsupportedOperationException("Bitvector not expected");
    }

    @Override
    public Formula makeNegate(Formula f) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_times(this.msatEnv, ArithmeticMathsat5FormulaManager.getTerm(f), Mathsat5NativeApi.msat_make_number(this.msatEnv, "-1")));
    }

    @Override
    public Formula makeNumber(int i) {
        return this.makeNumber(Integer.toString(i));
    }

    @Override
    public Formula makeNumber(String i) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_number(this.msatEnv, i));
    }

    @Override
    public Formula makePlus(Formula f1, Formula f2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_plus(this.msatEnv, ArithmeticMathsat5FormulaManager.getTerm(f1), ArithmeticMathsat5FormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeMinus(Formula f1, Formula f2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_plus(this.msatEnv, ArithmeticMathsat5FormulaManager.getTerm(f1), ArithmeticMathsat5FormulaManager.getTerm(this.makeNegate(f2))));
    }

    @Override
    public Formula makeDivide(Formula f1, Formula f2) {
        long result;
        long t1 = ArithmeticMathsat5FormulaManager.getTerm(f1);
        long t2 = ArithmeticMathsat5FormulaManager.getTerm(f2);
        if (Mathsat5NativeApi.msat_term_is_number(this.msatEnv, t2)) {
            String[] frac;
            String n = Mathsat5NativeApi.msat_term_repr(t2);
            if (n.startsWith("(")) {
                n = n.substring(1, n.length() - 1);
            }
            if ((frac = n.split("/")).length == 1) {
                n = "1/" + n;
            } else {
                assert (frac.length == 2);
                n = frac[1] + "/" + frac[0];
            }
            t2 = Mathsat5NativeApi.msat_make_number(this.msatEnv, n);
            result = Mathsat5NativeApi.msat_make_times(this.msatEnv, t2, t1);
        } else {
            result = this.buildMsatUF(this.divUfDecl, new long[]{t1, t2});
        }
        return this.encapsulate(result);
    }

    @Override
    public Formula makeModulo(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.modUfDecl);
    }

    @Override
    public Formula makeMultiply(Formula f1, Formula f2) {
        long t1 = ArithmeticMathsat5FormulaManager.getTerm(f1);
        long t2 = ArithmeticMathsat5FormulaManager.getTerm(f2);
        long result = Mathsat5NativeApi.msat_term_is_number(this.msatEnv, t1) ? Mathsat5NativeApi.msat_make_times(this.msatEnv, t1, t2) : (Mathsat5NativeApi.msat_term_is_number(this.msatEnv, t2) ? Mathsat5NativeApi.msat_make_times(this.msatEnv, t2, t1) : this.buildMsatUF(this.multUfDecl, new long[]{t1, t2}));
        return this.encapsulate(result);
    }

    @Override
    public Formula makeEqual(Formula f1, Formula f2) {
        long t = Mathsat5NativeApi.msat_make_equal(this.msatEnv, ArithmeticMathsat5FormulaManager.getTerm(f1), ArithmeticMathsat5FormulaManager.getTerm(f2));
        return this.encapsulate(t);
    }

    @Override
    public Formula makeGt(Formula f1, Formula f2) {
        long t = Mathsat5NativeApi.msat_make_not(this.msatEnv, Mathsat5NativeApi.msat_make_leq(this.msatEnv, ArithmeticMathsat5FormulaManager.getTerm(f1), ArithmeticMathsat5FormulaManager.getTerm(f2)));
        return this.encapsulate(t);
    }

    @Override
    public Formula makeGeq(Formula f1, Formula f2) {
        long t = Mathsat5NativeApi.msat_make_leq(this.msatEnv, ArithmeticMathsat5FormulaManager.getTerm(f2), ArithmeticMathsat5FormulaManager.getTerm(f1));
        return this.encapsulate(t);
    }

    @Override
    public Formula makeLt(Formula f1, Formula f2) {
        long t = Mathsat5NativeApi.msat_make_not(this.msatEnv, Mathsat5NativeApi.msat_make_leq(this.msatEnv, ArithmeticMathsat5FormulaManager.getTerm(f2), ArithmeticMathsat5FormulaManager.getTerm(f1)));
        return this.encapsulate(t);
    }

    @Override
    public Formula makeLeq(Formula f1, Formula f2) {
        long t = Mathsat5NativeApi.msat_make_leq(this.msatEnv, ArithmeticMathsat5FormulaManager.getTerm(f1), ArithmeticMathsat5FormulaManager.getTerm(f2));
        return this.encapsulate(t);
    }

    @Override
    public Formula makeBitwiseNot(Formula f) {
        long[] args = new long[]{ArithmeticMathsat5FormulaManager.getTerm(f)};
        return this.encapsulate(this.buildMsatUF(this.bitwiseNotUfDecl, args));
    }

    @Override
    public Formula makeBitwiseAnd(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.bitwiseAndUfDecl);
    }

    @Override
    public Formula makeBitwiseOr(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.bitwiseOrUfDecl);
    }

    @Override
    public Formula makeBitwiseXor(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.bitwiseXorUfDecl);
    }

    @Override
    public Formula makeShiftLeft(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.leftShiftUfDecl);
    }

    @Override
    public Formula makeShiftRight(Formula f1, Formula f2) {
        return this.makeUIFforBinaryOperator(f1, f2, this.rightShiftUfDecl);
    }

    private Formula makeUIFforBinaryOperator(Formula f1, Formula f2, long uifDecl) {
        long[] args = new long[]{ArithmeticMathsat5FormulaManager.getTerm(f1), ArithmeticMathsat5FormulaManager.getTerm(f2)};
        return this.encapsulate(this.buildMsatUF(uifDecl, args));
    }

    @Override
    public Formula getBitwiseAxioms(Formula f) {
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        HashSet<Formula> seen = new HashSet<Formula>();
        HashSet<Formula> allLiterals = new HashSet<Formula>();
        boolean andFound = false;
        toProcess.add(f);
        while (!toProcess.isEmpty()) {
            String r;
            Formula tt = (Formula)toProcess.pollLast();
            long t = ArithmeticMathsat5FormulaManager.getTerm(tt);
            if (Mathsat5NativeApi.msat_term_is_number(this.msatEnv, t)) {
                allLiterals.add(tt);
            }
            if (Mathsat5NativeApi.msat_term_is_uf(this.msatEnv, t) && (r = Mathsat5NativeApi.msat_term_repr(t)).startsWith("_&_")) {
                andFound = true;
            }
            int arity = Mathsat5NativeApi.msat_term_arity(t);
            for (int i = 0; i < arity; ++i) {
                Formula c = this.encapsulate(Mathsat5NativeApi.msat_term_get_arg(t, i));
                if (!seen.add(c)) continue;
                toProcess.add(c);
            }
        }
        long result = Mathsat5NativeApi.msat_make_true(this.msatEnv);
        if (andFound) {
            long z = Mathsat5NativeApi.msat_make_number(this.msatEnv, "0");
            for (Formula nn : allLiterals) {
                long n = ArithmeticMathsat5FormulaManager.getTerm(nn);
                long u1 = this.buildMsatUF(this.bitwiseAndUfDecl, new long[]{n, z});
                long u2 = this.buildMsatUF(this.bitwiseAndUfDecl, new long[]{z, n});
                long e1 = Mathsat5NativeApi.msat_make_equal(this.msatEnv, u1, z);
                long e2 = Mathsat5NativeApi.msat_make_equal(this.msatEnv, u2, z);
                long a = Mathsat5NativeApi.msat_make_and(this.msatEnv, e1, e2);
                result = Mathsat5NativeApi.msat_make_and(this.msatEnv, result, a);
            }
        }
        return this.encapsulate(result);
    }
}

