/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

@Options(prefix="cpa.predicate.mathsat")
public class BitwiseMathsat5FormulaManager
extends Mathsat5FormulaManager {
    private final int bitWidth;
    @Option(description="Whether to use signed or unsigned variables if useBitwise is true.")
    private boolean signed = true;
    private static Pattern BITVECTOR_PATTERN = Pattern.compile("^0d\\d+_(\\d+)$");

    public BitwiseMathsat5FormulaManager(Configuration config, LogManager logger, final int pBitWidth) throws InvalidConfigurationException {
        super(config, logger, new Mathsat5FormulaManager.MsatType(){

            @Override
            public long getVariableType(long pMsatEnv) {
                return Mathsat5NativeApi.msat_get_bv_type(pMsatEnv, pBitWidth);
            }
        });
        config.inject((Object)this, BitwiseMathsat5FormulaManager.class);
        this.bitWidth = pBitWidth;
    }

    @Override
    long createEnvironment(long cfg, boolean pShared, boolean pGhostFilter) {
        long env = super.createEnvironment(cfg, pShared, pGhostFilter);
        return env;
    }

    @Override
    long interpreteBitvector(long pBv) {
        String lTermRepresentation = Mathsat5NativeApi.msat_term_repr(pBv);
        Matcher matcher = BITVECTOR_PATTERN.matcher(lTermRepresentation);
        if (!matcher.matches()) {
            throw new NumberFormatException("Unknown bitvector format: " + lTermRepresentation);
        }
        String term = matcher.group(1);
        long value = Long.valueOf(term);
        if (this.signed && this.bitWidth <= 63 && value >= 1L << this.bitWidth - 1) {
            value -= 1L << this.bitWidth;
        }
        return value;
    }

    @Override
    public Formula makeNumber(int i) {
        return this.makeNumber(Integer.toString(i));
    }

    @Override
    public Formula makeNumber(String i) {
        i = "0d" + this.bitWidth + "_" + i;
        long t = Mathsat5NativeApi.msat_make_number(this.msatEnv, i);
        return this.encapsulate(t);
    }

    @Override
    public Formula makeNegate(Formula pF) {
        return this.makeMinus(this.makeNumber(0), pF);
    }

    @Override
    public Formula makePlus(Formula pF1, Formula pF2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_plus(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeMinus(Formula pF1, Formula pF2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_minus(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeDivide(Formula pF1, Formula pF2) {
        if (this.signed) {
            return this.encapsulate(Mathsat5NativeApi.msat_make_bv_sdiv(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
        }
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_udiv(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeModulo(Formula pF1, Formula pF2) {
        if (this.signed) {
            return this.encapsulate(Mathsat5NativeApi.msat_make_bv_srem(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
        }
        throw new UnsupportedOperationException("Unsigned modulo");
    }

    @Override
    public Formula makeMultiply(Formula pF1, Formula pF2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_times(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeEqual(Formula pF1, Formula pF2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_equal(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeGt(Formula pF1, Formula pF2) {
        if (this.signed) {
            return this.encapsulate(Mathsat5NativeApi.msat_make_bv_sleq(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF2), BitwiseMathsat5FormulaManager.getTerm(pF1)));
        }
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_uleq(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF2), BitwiseMathsat5FormulaManager.getTerm(pF1)));
    }

    @Override
    public Formula makeGeq(Formula pF1, Formula pF2) {
        if (this.signed) {
            return this.encapsulate(Mathsat5NativeApi.msat_make_bv_slt(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF2), BitwiseMathsat5FormulaManager.getTerm(pF1)));
        }
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_ult(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF2), BitwiseMathsat5FormulaManager.getTerm(pF1)));
    }

    @Override
    public Formula makeLt(Formula pF1, Formula pF2) {
        if (this.signed) {
            return this.encapsulate(Mathsat5NativeApi.msat_make_bv_slt(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
        }
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_ult(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeLeq(Formula pF1, Formula pF2) {
        if (this.signed) {
            return this.encapsulate(Mathsat5NativeApi.msat_make_bv_sleq(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
        }
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_uleq(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeBitwiseNot(Formula pF) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_not(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF)));
    }

    @Override
    public Formula makeBitwiseAnd(Formula pF1, Formula pF2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_and(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeBitwiseOr(Formula pF1, Formula pF2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_or(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeBitwiseXor(Formula pF1, Formula pF2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_xor(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pF2)));
    }

    @Override
    public Formula makeShiftLeft(Formula pF1, Formula pAmount) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_lshl(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pAmount)));
    }

    @Override
    public Formula makeShiftRight(Formula pF1, Formula pAmount) {
        if (this.signed) {
            return this.encapsulate(Mathsat5NativeApi.msat_make_bv_ashr(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pAmount)));
        }
        return this.encapsulate(Mathsat5NativeApi.msat_make_bv_lshr(this.msatEnv, BitwiseMathsat5FormulaManager.getTerm(pF1), BitwiseMathsat5FormulaManager.getTerm(pAmount)));
    }

    @Override
    public Formula getBitwiseAxioms(Formula pF) {
        return this.makeTrue();
    }
}

