/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Formula;

public class Mathsat5FormulaList
implements FormulaList,
Serializable {
    private static final long serialVersionUID = -6546625578464890862L;
    private transient long[] terms;

    public Mathsat5FormulaList(long ... terms) {
        for (long t : terms) {
            assert (t != 0L);
        }
        this.terms = terms;
    }

    long[] getTerms() {
        return this.terms;
    }

    public String toString() {
        return Arrays.toString(this.terms);
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof Mathsat5FormulaList)) {
            return false;
        }
        return Arrays.equals(this.terms, ((Mathsat5FormulaList)pObj).terms);
    }

    public int hashCode() {
        return Arrays.hashCode(this.terms);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.terms.length);
        for (int i = 0; i < this.terms.length; ++i) {
            out.writeObject(new Mathsat5Formula(0L, this.terms[i]));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int termCount = in.readInt();
        this.terms = new long[termCount];
        for (int i = 0; i < this.terms.length; ++i) {
            this.terms[i] = ((Mathsat5Formula)in.readObject()).getTerm();
        }
    }
}

