/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaList;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

@Options(prefix="cpa.predicate.mathsat")
public abstract class Mathsat5FormulaManager
implements FormulaManager {
    @Option(description="Use UIFs (recommended because its more precise)")
    private boolean useUIFs = true;
    final long msatEnv;
    private final long stringLitUfDecl;
    final long msatVarType;
    private static final String INDEX_SEPARATOR = "@";
    private static final String UIF_VARIABLE = "__uif__";
    private int uifVariableCounter = 0;
    private final Map<Formula, Boolean> arithCache = new HashMap<Formula, Boolean>();
    private final Map<Formula, Formula> uninstantiateCache = new HashMap<Formula, Formula>();
    private final Formula trueFormula;
    private final Formula falseFormula;

    Mathsat5FormulaManager(Configuration config, LogManager logger, MsatType pVarType) throws InvalidConfigurationException {
        config.inject((Object)this, Mathsat5FormulaManager.class);
        long msatConf = Mathsat5NativeApi.msat_create_config();
        this.msatEnv = Mathsat5NativeApi.msat_create_env(msatConf);
        this.msatVarType = pVarType.getVariableType(this.msatEnv);
        this.trueFormula = this.encapsulate(Mathsat5NativeApi.msat_make_true(this.msatEnv));
        this.falseFormula = this.encapsulate(Mathsat5NativeApi.msat_make_false(this.msatEnv));
        long integer_type = Mathsat5NativeApi.msat_get_integer_type(this.msatEnv);
        long stringLitUfDeclType = Mathsat5NativeApi.msat_get_function_type(this.msatEnv, new long[]{integer_type}, 1, this.msatVarType);
        this.stringLitUfDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "__string__", stringLitUfDeclType);
    }

    long getMsatEnv() {
        return this.msatEnv;
    }

    long createEnvironment(long cfg, boolean shared, boolean ghostFilter) {
        if (ghostFilter) {
            Mathsat5NativeApi.msat_set_option(cfg, "ghost_filtering", "true");
        }
        long env = shared ? Mathsat5NativeApi.msat_create_shared_env(cfg, this.msatEnv) : Mathsat5NativeApi.msat_create_env(cfg);
        return env;
    }

    static long getTerm(Formula f) {
        return ((Mathsat5Formula)f).getTerm();
    }

    static long[] getTerm(FormulaList f) {
        return ((Mathsat5FormulaList)f).getTerms();
    }

    protected Formula encapsulate(long t) {
        return new Mathsat5Formula(this.msatEnv, t);
    }

    private static FormulaList encapsulate(long[] t) {
        return new Mathsat5FormulaList(t);
    }

    private static String makeName(String name, int idx) {
        return name + INDEX_SEPARATOR + idx;
    }

    static Pair<String, Integer> parseName(String var) {
        String[] s = var.split(INDEX_SEPARATOR);
        if (s.length != 2) {
            throw new IllegalArgumentException("Not an instantiated variable: " + var);
        }
        return Pair.of((Object)s[0], (Object)Integer.parseInt(s[1]));
    }

    abstract long interpreteBitvector(long var1);

    @Override
    public boolean isBoolean(Formula f) {
        long a = Mathsat5NativeApi.msat_term_get_type(Mathsat5FormulaManager.getTerm(f));
        return Mathsat5NativeApi.msat_is_bool_type(this.msatEnv, a);
    }

    @Override
    public Formula makeTrue() {
        return this.trueFormula;
    }

    @Override
    public Formula makeFalse() {
        return this.falseFormula;
    }

    @Override
    public Formula makeNot(Formula f) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_not(this.msatEnv, Mathsat5FormulaManager.getTerm(f)));
    }

    @Override
    public Formula makeAnd(Formula f1, Formula f2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_and(this.msatEnv, Mathsat5FormulaManager.getTerm(f1), Mathsat5FormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeOr(Formula f1, Formula f2) {
        return this.encapsulate(Mathsat5NativeApi.msat_make_or(this.msatEnv, Mathsat5FormulaManager.getTerm(f1), Mathsat5FormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeEquivalence(Formula f1, Formula f2) {
        long f1Type = Mathsat5NativeApi.msat_term_get_type(Mathsat5FormulaManager.getTerm(f1));
        long f2Type = Mathsat5NativeApi.msat_term_get_type(Mathsat5FormulaManager.getTerm(f2));
        if (Mathsat5NativeApi.msat_is_bool_type(this.msatEnv, f1Type) && Mathsat5NativeApi.msat_is_bool_type(this.msatEnv, f2Type)) {
            return this.encapsulate(Mathsat5NativeApi.msat_make_iff(this.msatEnv, Mathsat5FormulaManager.getTerm(f1), Mathsat5FormulaManager.getTerm(f2)));
        }
        return this.encapsulate(Mathsat5NativeApi.msat_make_equal(this.msatEnv, Mathsat5FormulaManager.getTerm(f1), Mathsat5FormulaManager.getTerm(f2)));
    }

    @Override
    public Formula makeIfThenElse(Formula condition, Formula f1, Formula f2) {
        long f1Type = Mathsat5NativeApi.msat_term_get_type(Mathsat5FormulaManager.getTerm(f1));
        long f2Type = Mathsat5NativeApi.msat_term_get_type(Mathsat5FormulaManager.getTerm(f2));
        long t = !Mathsat5NativeApi.msat_is_bool_type(this.msatEnv, f1Type) || !Mathsat5NativeApi.msat_is_bool_type(this.msatEnv, f2Type) ? Mathsat5NativeApi.msat_make_term_ite(this.msatEnv, Mathsat5FormulaManager.getTerm(condition), Mathsat5FormulaManager.getTerm(f1), Mathsat5FormulaManager.getTerm(f2)) : Mathsat5NativeApi.msat_make_and(this.msatEnv, Mathsat5NativeApi.msat_make_or(this.msatEnv, Mathsat5NativeApi.msat_make_not(this.msatEnv, Mathsat5FormulaManager.getTerm(condition)), Mathsat5FormulaManager.getTerm(f1)), Mathsat5NativeApi.msat_make_or(this.msatEnv, Mathsat5FormulaManager.getTerm(condition), Mathsat5FormulaManager.getTerm(f2)));
        return this.encapsulate(t);
    }

    private long declareUF(String name, long types, int argCount) {
        long[] tp = new long[argCount];
        Arrays.fill(tp, types);
        long funcType = Mathsat5NativeApi.msat_get_function_type(this.msatEnv, tp, tp.length, types);
        return Mathsat5NativeApi.msat_declare_function(this.msatEnv, name, funcType);
    }

    private long buildMsatUF(String name, long[] args, boolean predicate) {
        long type;
        Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0);
        long l = type = predicate ? Mathsat5NativeApi.msat_get_bool_type(this.msatEnv) : this.msatVarType;
        if (!this.useUIFs) {
            return this.buildMsatUfReplacement(type);
        }
        if (args.length > 0) {
            long decl = this.declareUF(name, type, args.length);
            return this.buildMsatUF(decl, args);
        }
        type = Mathsat5NativeApi.msat_get_simple_type(this.msatEnv, name);
        long decl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, name, type);
        return Mathsat5NativeApi.msat_make_constant(this.msatEnv, decl);
    }

    protected long buildMsatUF(long func, long[] args) {
        if (this.useUIFs) {
            return Mathsat5NativeApi.msat_make_uf(this.msatEnv, func, args);
        }
        return this.buildMsatUfReplacement(this.msatVarType);
    }

    private long buildMsatUfReplacement(long type) {
        String var = Mathsat5FormulaManager.makeName(UIF_VARIABLE, ++this.uifVariableCounter);
        long decl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, var, this.msatVarType);
        long t = Mathsat5NativeApi.msat_make_constant(this.msatEnv, decl);
        return t;
    }

    @Override
    public Formula makeUIP(String name, FormulaList args) {
        return this.encapsulate(this.buildMsatUF(name, Mathsat5FormulaManager.getTerm(args), true));
    }

    @Override
    public Formula makeUIF(String name, FormulaList args) {
        return this.encapsulate(this.buildMsatUF(name, Mathsat5FormulaManager.getTerm(args), false));
    }

    @Override
    public Formula makeUIF(String name, FormulaList args, int idx) {
        return this.encapsulate(this.buildMsatUF(Mathsat5FormulaManager.makeName(name, idx), Mathsat5FormulaManager.getTerm(args), false));
    }

    @Override
    public Formula makeString(int i) {
        long n = Mathsat5NativeApi.msat_make_number(this.msatEnv, Integer.toString(i));
        return this.encapsulate(this.buildMsatUF(this.stringLitUfDecl, new long[]{n}));
    }

    private long buildMsatVariable(String var, long type) {
        long decl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, var, type);
        long t = Mathsat5NativeApi.msat_make_constant(this.msatEnv, decl);
        return t;
    }

    @Override
    public Formula makeVariable(String var, int idx) {
        return this.makeVariable(Mathsat5FormulaManager.makeName(var, idx));
    }

    @Override
    public Formula makeVariable(String var) {
        return this.encapsulate(this.buildMsatVariable(var, this.msatVarType));
    }

    @Override
    public Formula makePredicateVariable(String var, int idx) {
        String name = Mathsat5FormulaManager.makeName("PRED" + var, idx);
        long bool_type = Mathsat5NativeApi.msat_get_bool_type(this.msatEnv);
        long decl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, name, bool_type);
        long t = Mathsat5NativeApi.msat_make_constant(this.msatEnv, decl);
        return this.encapsulate(t);
    }

    @Override
    public Formula makeAssignment(Formula f1, Formula f2) {
        return this.makeEqual(f1, f2);
    }

    @Override
    public FormulaList makeList(Formula pF) {
        return new Mathsat5FormulaList(Mathsat5FormulaManager.getTerm(pF));
    }

    @Override
    public FormulaList makeList(Formula pF1, Formula pF2) {
        return new Mathsat5FormulaList(Mathsat5FormulaManager.getTerm(pF1), Mathsat5FormulaManager.getTerm(pF2));
    }

    @Override
    public FormulaList makeList(List<Formula> pFs) {
        long[] t = new long[pFs.size()];
        for (int i = 0; i < t.length; ++i) {
            t[i] = Mathsat5FormulaManager.getTerm(pFs.get(i));
        }
        return Mathsat5FormulaManager.encapsulate(t);
    }

    @Override
    public Formula createPredicateVariable(Formula atom) {
        long t = Mathsat5FormulaManager.getTerm(atom);
        String repr = Mathsat5NativeApi.msat_term_is_atom(this.msatEnv, t) ? Mathsat5NativeApi.msat_term_repr(t) : "#" + Mathsat5NativeApi.msat_term_id(t);
        long bool_type = Mathsat5NativeApi.msat_get_bool_type(this.msatEnv);
        long d = Mathsat5NativeApi.msat_declare_function(this.msatEnv, "\"PRED" + repr + "\"", bool_type);
        long var = Mathsat5NativeApi.msat_make_constant(this.msatEnv, d);
        return this.encapsulate(var);
    }

    @Override
    public String dumpFormula(Formula f) {
        return Mathsat5NativeApi.msat_to_smtlib2(this.msatEnv, Mathsat5FormulaManager.getTerm(f));
    }

    @Override
    public Formula parseInfix(String s) {
        long f = Mathsat5NativeApi.msat_from_string(this.msatEnv, s);
        return this.encapsulate(f);
    }

    @Override
    public Formula parse(String s) {
        long f = Mathsat5NativeApi.msat_from_smtlib2(this.msatEnv, s);
        return this.encapsulate(f);
    }

    @Override
    public Formula instantiate(Formula f, SSAMap ssa) {
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        HashMap<Formula, Formula> cache = new HashMap<Formula, Formula>();
        toProcess.push(f);
        while (!toProcess.isEmpty()) {
            long newt;
            Formula tt = (Formula)toProcess.peek();
            if (cache.containsKey(tt)) {
                toProcess.pop();
                continue;
            }
            long t = Mathsat5FormulaManager.getTerm(tt);
            if (Mathsat5NativeApi.msat_term_is_constant(this.msatEnv, t)) {
                toProcess.pop();
                String name = Mathsat5NativeApi.msat_term_repr(t);
                int idx = ssa.getIndex(name);
                if (idx > 0) {
                    long newt2 = this.buildMsatVariable(Mathsat5FormulaManager.makeName(name, idx), Mathsat5NativeApi.msat_term_get_type(t));
                    cache.put(tt, this.encapsulate(newt2));
                    continue;
                }
                cache.put(tt, tt);
                continue;
            }
            boolean childrenDone = true;
            long[] newargs = new long[Mathsat5NativeApi.msat_term_arity(t)];
            for (int i = 0; i < newargs.length; ++i) {
                Formula c = this.encapsulate(Mathsat5NativeApi.msat_term_get_arg(t, i));
                Formula newC = (Formula)cache.get(c);
                if (newC != null) {
                    newargs[i] = Mathsat5FormulaManager.getTerm(newC);
                    continue;
                }
                toProcess.push(c);
                childrenDone = false;
            }
            if (!childrenDone) continue;
            toProcess.pop();
            if (Mathsat5NativeApi.msat_term_is_uf(this.msatEnv, t)) {
                String name = Mathsat5NativeApi.msat_decl_get_name(Mathsat5NativeApi.msat_term_get_decl(t));
                assert (name != null);
                if (this.ufCanBeLvalue(name)) {
                    int idx = ssa.getIndex(name, Mathsat5FormulaManager.encapsulate(newargs));
                    if (idx > 0) {
                        newt = this.buildMsatUF(Mathsat5FormulaManager.makeName(name, idx), newargs, false);
                    } else {
                        long tDecl = Mathsat5NativeApi.msat_term_get_decl(t);
                        newt = Mathsat5NativeApi.msat_make_term(this.msatEnv, tDecl, newargs);
                    }
                } else {
                    long tDecl = Mathsat5NativeApi.msat_term_get_decl(t);
                    newt = Mathsat5NativeApi.msat_make_term(this.msatEnv, tDecl, newargs);
                }
            } else {
                long tDecl = Mathsat5NativeApi.msat_term_get_decl(t);
                newt = newargs.length > 0 ? Mathsat5NativeApi.msat_make_term(this.msatEnv, tDecl, newargs) : Mathsat5NativeApi.msat_make_constant(this.msatEnv, tDecl);
            }
            cache.put(tt, this.encapsulate(newt));
        }
        Formula result = (Formula)cache.get(f);
        assert (result != null);
        return result;
    }

    private boolean ufCanBeLvalue(String name) {
        return name.startsWith(".{") || name.startsWith("->{");
    }

    @Override
    public Formula uninstantiate(Formula f) {
        Map<Formula, Formula> cache = this.uninstantiateCache;
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        toProcess.push(f);
        while (!toProcess.isEmpty()) {
            long newt;
            Formula tt = (Formula)toProcess.peek();
            if (cache.containsKey(tt)) {
                toProcess.pop();
                continue;
            }
            long t = Mathsat5FormulaManager.getTerm(tt);
            if (Mathsat5NativeApi.msat_term_is_constant(this.msatEnv, t)) {
                String name = (String)Mathsat5FormulaManager.parseName(Mathsat5NativeApi.msat_term_repr(t)).getFirst();
                long newt2 = this.buildMsatVariable(name, Mathsat5NativeApi.msat_term_get_type(t));
                cache.put(tt, this.encapsulate(newt2));
                continue;
            }
            boolean childrenDone = true;
            long[] newargs = new long[Mathsat5NativeApi.msat_term_arity(t)];
            for (int i = 0; i < newargs.length; ++i) {
                Formula c = this.encapsulate(Mathsat5NativeApi.msat_term_get_arg(t, i));
                Formula newC = cache.get(c);
                if (newC != null) {
                    newargs[i] = Mathsat5FormulaManager.getTerm(newC);
                    continue;
                }
                toProcess.push(c);
                childrenDone = false;
            }
            if (!childrenDone) continue;
            toProcess.pop();
            if (Mathsat5NativeApi.msat_term_is_uf(this.msatEnv, t)) {
                String name = Mathsat5NativeApi.msat_decl_get_name(Mathsat5NativeApi.msat_term_get_decl(t));
                assert (name != null);
                if (this.ufCanBeLvalue(name)) {
                    name = (String)Mathsat5FormulaManager.parseName(name).getFirst();
                    newt = this.buildMsatUF(name, newargs, false);
                } else {
                    long tDecl = Mathsat5NativeApi.msat_term_get_decl(t);
                    newt = Mathsat5NativeApi.msat_make_term(this.msatEnv, tDecl, newargs);
                }
            } else {
                long tDecl = Mathsat5NativeApi.msat_term_get_decl(t);
                newt = Mathsat5NativeApi.msat_make_term(this.msatEnv, tDecl, newargs);
            }
            cache.put(tt, this.encapsulate(newt));
        }
        Formula result = cache.get(f);
        assert (result != null);
        return result;
    }

    @Override
    public Collection<Formula> extractAtoms(Formula f, boolean splitArithEqualities, boolean conjunctionsOnly) {
        HashSet<Formula> handled = new HashSet<Formula>();
        ArrayList<Formula> atoms = new ArrayList<Formula>();
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        toProcess.push(f);
        handled.add(f);
        while (!toProcess.isEmpty()) {
            Formula tt = (Formula)toProcess.pop();
            long t = Mathsat5FormulaManager.getTerm(tt);
            assert (handled.contains(tt));
            if (Mathsat5NativeApi.msat_term_is_true(this.msatEnv, t) || Mathsat5NativeApi.msat_term_is_false(this.msatEnv, t)) continue;
            if (Mathsat5NativeApi.msat_term_is_atom(this.msatEnv, t)) {
                tt = this.uninstantiate(tt);
                t = Mathsat5FormulaManager.getTerm(tt);
                if (splitArithEqualities && Mathsat5NativeApi.msat_term_is_equal(this.msatEnv, t) && this.isPurelyArithmetic(tt)) {
                    long a1 = Mathsat5NativeApi.msat_term_get_arg(t, 0);
                    long a2 = Mathsat5NativeApi.msat_term_get_arg(t, 1);
                    long t1 = Mathsat5NativeApi.msat_make_leq(this.msatEnv, a1, a2);
                    Formula tt1 = this.encapsulate(t1);
                    handled.add(tt1);
                    atoms.add(tt1);
                    atoms.add(tt);
                    continue;
                }
                atoms.add(tt);
                continue;
            }
            if (conjunctionsOnly && !Mathsat5NativeApi.msat_term_is_not(this.msatEnv, t) && !Mathsat5NativeApi.msat_term_is_and(this.msatEnv, t)) {
                atoms.add(this.uninstantiate(tt));
                continue;
            }
            for (int i = 0; i < Mathsat5NativeApi.msat_term_arity(t); ++i) {
                long newt = Mathsat5NativeApi.msat_term_get_arg(t, i);
                Formula c = this.encapsulate(newt);
                if (!handled.add(c)) continue;
                toProcess.push(c);
            }
        }
        return atoms;
    }

    @Override
    public Set<String> extractVariables(Formula f) {
        HashSet<Formula> seen = new HashSet<Formula>();
        HashSet<String> vars = new HashSet<String>();
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        toProcess.push(f);
        while (!toProcess.isEmpty()) {
            long t = Mathsat5FormulaManager.getTerm((Formula)toProcess.pop());
            if (Mathsat5NativeApi.msat_term_is_true(this.msatEnv, t) || Mathsat5NativeApi.msat_term_is_false(this.msatEnv, t)) continue;
            if (Mathsat5NativeApi.msat_term_is_constant(this.msatEnv, t)) {
                vars.add(Mathsat5NativeApi.msat_term_repr(t));
                continue;
            }
            for (int i = 0; i < Mathsat5NativeApi.msat_term_arity(t); ++i) {
                long newt = Mathsat5NativeApi.msat_term_get_arg(t, i);
                Formula c = this.encapsulate(newt);
                if (!seen.add(c)) continue;
                toProcess.push(c);
            }
        }
        return vars;
    }

    private boolean isPurelyArithmetic(Formula f) {
        Boolean result = this.arithCache.get(f);
        if (result != null) {
            return result;
        }
        long t = Mathsat5FormulaManager.getTerm(f);
        boolean res = true;
        if (Mathsat5NativeApi.msat_term_is_uf(this.msatEnv, t)) {
            res = false;
        } else {
            int arity = Mathsat5NativeApi.msat_term_arity(t);
            for (int i = 0; i < arity && (res |= this.isPurelyArithmetic(this.encapsulate(Mathsat5NativeApi.msat_term_get_arg(t, i)))); ++i) {
            }
        }
        this.arithCache.put(f, res);
        return res;
    }

    @Override
    public boolean checkSyntacticEntails(Formula leftFormula, Formula rightFormula) {
        long leftTerm = Mathsat5FormulaManager.getTerm(leftFormula);
        ArrayDeque<Long> toProcess = new ArrayDeque<Long>();
        HashSet<Long> seen = new HashSet<Long>();
        toProcess.push(Mathsat5FormulaManager.getTerm(rightFormula));
        while (!toProcess.isEmpty()) {
            long rightSubTerm = (Long)toProcess.pop();
            if (rightSubTerm == leftTerm) {
                return true;
            }
            if (Mathsat5NativeApi.msat_term_is_constant(this.msatEnv, rightSubTerm)) continue;
            int args = Mathsat5NativeApi.msat_term_arity(rightSubTerm);
            for (int i = 0; i < args; ++i) {
                long arg = Mathsat5NativeApi.msat_term_get_arg(rightSubTerm, i);
                if (seen.contains(arg)) continue;
                toProcess.add(arg);
                seen.add(arg);
            }
        }
        return false;
    }

    @Override
    public Formula[] getArguments(Formula f) {
        long t = Mathsat5FormulaManager.getTerm(f);
        int arity = Mathsat5NativeApi.msat_term_arity(t);
        Formula[] result = new Formula[arity];
        for (int i = 0; i < arity; ++i) {
            result[i] = this.encapsulate(Mathsat5NativeApi.msat_term_get_arg(t, i));
        }
        return result;
    }

    @Override
    public void declareUIP(String name, int argCount) {
        this.declareUF(name, Mathsat5NativeApi.msat_get_bool_type(this.msatEnv), argCount);
    }

    @Override
    public String getVersion() {
        return Mathsat5NativeApi.msat_get_version();
    }

    protected static interface MsatType {
        public long getVariableType(long var1);
    }
}

