/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingTheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Model;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

public class Mathsat5InterpolatingProver
implements InterpolatingTheoremProver<Integer> {
    private final Mathsat5FormulaManager mgr;
    private long interpolEnv;
    private long cfg;
    private final boolean useSharedEnv;

    public Mathsat5InterpolatingProver(Mathsat5FormulaManager pMgr, boolean shared) {
        this.mgr = pMgr;
        this.interpolEnv = 0L;
        this.useSharedEnv = shared;
    }

    @Override
    public void init() {
        Preconditions.checkState((this.interpolEnv == 0L ? 1 : 0) != 0);
        this.cfg = Mathsat5NativeApi.msat_create_config();
        Mathsat5NativeApi.msat_set_option(this.cfg, "interpolation", "true");
        Mathsat5NativeApi.msat_set_option(this.cfg, "model_generation", "true");
        this.interpolEnv = this.mgr.createEnvironment(this.cfg, this.useSharedEnv, false);
    }

    @Override
    public Integer addFormula(Formula f) {
        Preconditions.checkState((this.interpolEnv != 0L ? 1 : 0) != 0);
        long t = ((Mathsat5Formula)f).getTerm();
        if (!this.useSharedEnv) {
            t = Mathsat5NativeApi.msat_make_copy_from(this.interpolEnv, t, this.mgr.getMsatEnv());
        }
        int group = Mathsat5NativeApi.msat_create_itp_group(this.interpolEnv);
        Mathsat5NativeApi.msat_set_itp_group(this.interpolEnv, group);
        Mathsat5NativeApi.msat_assert_formula(this.interpolEnv, t);
        return group;
    }

    @Override
    public boolean isUnsat() {
        Preconditions.checkState((this.interpolEnv != 0L ? 1 : 0) != 0);
        int res = Mathsat5NativeApi.msat_solve(this.interpolEnv);
        assert (res != -1);
        return res == 0;
    }

    @Override
    public Formula getInterpolant(List<Integer> formulasOfA) {
        Preconditions.checkState((this.interpolEnv != 0L ? 1 : 0) != 0);
        int[] groupsOfA = new int[formulasOfA.size()];
        int i = 0;
        for (Integer f : formulasOfA) {
            groupsOfA[i++] = f;
        }
        long itp = Mathsat5NativeApi.msat_get_interpolant(this.interpolEnv, groupsOfA);
        if (!this.useSharedEnv) {
            itp = Mathsat5NativeApi.msat_make_copy_from(this.mgr.getMsatEnv(), itp, this.interpolEnv);
        }
        return new Mathsat5Formula(this.mgr.getMsatEnv(), itp);
    }

    @Override
    public void reset() {
        Preconditions.checkState((this.interpolEnv != 0L ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_destroy_env(this.interpolEnv);
        this.interpolEnv = 0L;
    }

    @Override
    public Model getModel() {
        Preconditions.checkState((this.interpolEnv != 0L ? 1 : 0) != 0);
        return Mathsat5Model.createMathsatModel(this.interpolEnv, this.mgr);
    }
}

