/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.collect.ImmutableMap;
import java.lang.constant.Constable;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.ArithmeticMathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

public class Mathsat5Model {
    private static Model.TermType toMathsatType(long e, long mType) {
        if (Mathsat5NativeApi.msat_is_bool_type(e, mType)) {
            return Model.TermType.Boolean;
        }
        if (Mathsat5NativeApi.msat_is_integer_type(e, mType)) {
            return Model.TermType.Integer;
        }
        if (Mathsat5NativeApi.msat_is_rational_type(e, mType)) {
            return Model.TermType.Real;
        }
        if (Mathsat5NativeApi.msat_is_bv_type(e, mType)) {
            return Model.TermType.Bitvector;
        }
        throw new IllegalArgumentException("Given parameter is not a mathsat type!");
    }

    private static Model.Variable toVariable(long env, long pVariableId) {
        if (!Mathsat5NativeApi.msat_term_is_constant(env, pVariableId)) {
            throw new IllegalArgumentException("Given mathsat id doesn't correspond to a variable! (" + Mathsat5NativeApi.msat_term_repr(pVariableId) + ")");
        }
        long lDeclarationId = Mathsat5NativeApi.msat_term_get_decl(pVariableId);
        String lName = Mathsat5NativeApi.msat_decl_get_name(lDeclarationId);
        Model.TermType lType = Mathsat5Model.toMathsatType(env, Mathsat5NativeApi.msat_decl_get_return_type(lDeclarationId));
        Pair<String, Integer> lSplitName = ArithmeticMathsat5FormulaManager.parseName(lName);
        return new Model.Variable((String)lSplitName.getFirst(), (Integer)lSplitName.getSecond(), lType);
    }

    private static Model.Function toFunction(long env, long pFunctionId) {
        if (Mathsat5NativeApi.msat_term_is_constant(env, pFunctionId)) {
            throw new IllegalArgumentException("Given mathsat id is a variable! (" + Mathsat5NativeApi.msat_term_repr(pFunctionId) + ")");
        }
        long lDeclarationId = Mathsat5NativeApi.msat_term_get_decl(pFunctionId);
        String lName = Mathsat5NativeApi.msat_decl_get_name(lDeclarationId);
        Model.TermType lType = Mathsat5Model.toMathsatType(env, Mathsat5NativeApi.msat_decl_get_return_type(lDeclarationId));
        int lArity = Mathsat5NativeApi.msat_decl_get_arity(lDeclarationId);
        Object[] lArguments = new Object[lArity];
        for (int lArgumentIndex = 0; lArgumentIndex < lArity; ++lArgumentIndex) {
            Double lValue;
            long lArgument = Mathsat5NativeApi.msat_term_get_arg(pFunctionId, lArgumentIndex);
            String lTermRepresentation = Mathsat5NativeApi.msat_term_repr(lArgument);
            try {
                lValue = Double.valueOf(lTermRepresentation);
            }
            catch (NumberFormatException e) {
                String[] lNumbers = lTermRepresentation.split("/");
                if (lNumbers.length != 2) {
                    throw new NumberFormatException("Unknown number format: " + lTermRepresentation);
                }
                double lNumerator = Double.valueOf(lNumbers[0]);
                double lDenominator = Double.valueOf(lNumbers[1]);
                lValue = lNumerator / lDenominator;
            }
            lArguments[lArgumentIndex] = lValue;
        }
        return new Model.Function(lName, lType, lArguments);
    }

    private static Model.AssignableTerm toAssignable(long env, long pTermId) {
        if (!Mathsat5NativeApi.msat_term_is_constant(env, pTermId)) {
            return Mathsat5Model.toFunction(env, pTermId);
        }
        return Mathsat5Model.toVariable(env, pTermId);
    }

    static Model createMathsatModel(long lMathsatEnvironmentID, Mathsat5FormulaManager fmgr) {
        ImmutableMap.Builder model = ImmutableMap.builder();
        long modelFormula = Mathsat5NativeApi.msat_make_true(lMathsatEnvironmentID);
        Mathsat5NativeApi.ModelIterator lModelIterator = Mathsat5NativeApi.msat_create_ModelIterator(lMathsatEnvironmentID);
        while (lModelIterator.hasNext()) {
            Constable lValue;
            long[] lModelElement = lModelIterator.next();
            long lKeyTerm = lModelElement[0];
            long lValueTerm = lModelElement[1];
            long equivalence = Mathsat5NativeApi.msat_is_bool_type(lMathsatEnvironmentID, Mathsat5NativeApi.msat_term_get_type(lKeyTerm)) && Mathsat5NativeApi.msat_is_bool_type(lMathsatEnvironmentID, Mathsat5NativeApi.msat_term_get_type(lValueTerm)) ? Mathsat5NativeApi.msat_make_iff(lMathsatEnvironmentID, lKeyTerm, lValueTerm) : Mathsat5NativeApi.msat_make_equal(lMathsatEnvironmentID, lKeyTerm, lValueTerm);
            modelFormula = Mathsat5NativeApi.msat_make_and(lMathsatEnvironmentID, modelFormula, equivalence);
            Model.AssignableTerm lAssignable = Mathsat5Model.toAssignable(lMathsatEnvironmentID, lKeyTerm);
            if (!(Mathsat5NativeApi.msat_term_is_number(lMathsatEnvironmentID, lValueTerm) || Mathsat5NativeApi.msat_term_is_boolean_constant(lMathsatEnvironmentID, lValueTerm) || Mathsat5NativeApi.msat_term_is_false(lMathsatEnvironmentID, lValueTerm) || Mathsat5NativeApi.msat_term_is_true(lMathsatEnvironmentID, lValueTerm))) {
                throw new IllegalArgumentException("Mathsat term is not a number!");
            }
            String lTermRepresentation = Mathsat5NativeApi.msat_term_repr(lValueTerm);
            switch (lAssignable.getType()) {
                case Boolean: {
                    if (lTermRepresentation.equals("`true`")) {
                        lValue = Boolean.valueOf(true);
                        break;
                    }
                    if (lTermRepresentation.equals("`false`")) {
                        lValue = Boolean.valueOf(false);
                        break;
                    }
                    throw new IllegalArgumentException("Mathsat unhandled boolean value " + lTermRepresentation);
                }
                case Real: {
                    try {
                        lValue = Double.valueOf(lTermRepresentation);
                    }
                    catch (NumberFormatException e) {
                        String[] lNumbers = lTermRepresentation.split("/");
                        if (lNumbers.length != 2) {
                            throw new NumberFormatException("Unknown number format: " + lTermRepresentation);
                        }
                        double lNumerator = Double.valueOf(lNumbers[0]);
                        double lDenominator = Double.valueOf(lNumbers[1]);
                        lValue = lNumerator / lDenominator;
                    }
                    break;
                }
                case Integer: {
                    lValue = Long.valueOf(lTermRepresentation);
                    break;
                }
                case Bitvector: {
                    lValue = fmgr.interpreteBitvector(lValueTerm);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Mathsat term with unhandled type " + (Object)((Object)lAssignable.getType()));
                }
            }
            model.put((Object)lAssignable, (Object)lValue);
        }
        lModelIterator.free();
        return new Model((Map<Model.AssignableTerm, Object>)model.build(), new Mathsat5Formula(lMathsatEnvironmentID, modelFormula));
    }
}

