/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.TheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Model;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

public class Mathsat5TheoremProver
implements TheoremProver {
    private final Mathsat5FormulaManager mgr;
    private long curEnv;
    private long cfg;

    public Mathsat5TheoremProver(Mathsat5FormulaManager pMgr) {
        this.mgr = pMgr;
        this.curEnv = 0L;
    }

    @Override
    public boolean isUnsat() {
        int res = Mathsat5NativeApi.msat_solve(this.curEnv);
        assert (res != -1);
        return res == 0;
    }

    @Override
    public Model getModel() {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        return Mathsat5Model.createMathsatModel(this.curEnv, this.mgr);
    }

    @Override
    public void pop() {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_pop_backtrack_point(this.curEnv);
    }

    @Override
    public void push(Formula f) {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_push_backtrack_point(this.curEnv);
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, Mathsat5FormulaManager.getTerm(f));
    }

    @Override
    public void init() {
        Preconditions.checkState((this.curEnv == 0L ? 1 : 0) != 0);
        this.cfg = Mathsat5NativeApi.msat_create_config();
        Mathsat5NativeApi.msat_set_option(this.cfg, "model_generation", "true");
        this.curEnv = this.mgr.createEnvironment(this.cfg, true, true);
    }

    @Override
    public void reset() {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_destroy_env(this.curEnv);
        this.curEnv = 0L;
    }

    @Override
    public TheoremProver.AllSatResult allSat(Formula f, Collection<Formula> important, AbstractionManager.RegionCreator rmgr, Timer timer) {
        Preconditions.checkNotNull((Object)rmgr);
        Preconditions.checkNotNull((Object)timer);
        if (important.isEmpty()) {
            throw new RuntimeException("Error occurred during Mathsat allsat: all-sat should not be called with empty 'important'-Collection");
        }
        long allsatEnv = this.mgr.createEnvironment(this.cfg, true, true);
        long formula = Mathsat5FormulaManager.getTerm(f);
        long[] imp = new long[important.size()];
        int i = 0;
        for (Formula impF : important) {
            imp[i++] = Mathsat5FormulaManager.getTerm(impF);
        }
        MathsatAllSatCallback callback = new MathsatAllSatCallback(rmgr, timer, allsatEnv);
        Mathsat5NativeApi.msat_assert_formula(allsatEnv, formula);
        int numModels = Mathsat5NativeApi.msat_all_sat(allsatEnv, imp, callback);
        if (numModels == -1) {
            throw new RuntimeException("Error occurred during Mathsat allsat: " + Mathsat5NativeApi.msat_last_error_message(allsatEnv));
        }
        if (numModels == -2) {
            callback.setInfiniteNumberOfModels();
        } else assert (numModels == callback.count);
        Mathsat5NativeApi.msat_destroy_env(allsatEnv);
        return callback;
    }

    static class MathsatAllSatCallback
    implements Mathsat5NativeApi.AllSatModelCallback,
    TheoremProver.AllSatResult {
        private final AbstractionManager.RegionCreator rmgr;
        private final Timer totalTime;
        private int count = 0;
        private Region formula;
        private final Deque<Region> cubes = new ArrayDeque<Region>();
        private long env;

        public MathsatAllSatCallback(AbstractionManager.RegionCreator rmgr, Timer timer, long env) {
            this.rmgr = rmgr;
            this.formula = rmgr.makeFalse();
            this.totalTime = timer;
            this.env = env;
        }

        public void setInfiniteNumberOfModels() {
            this.count = Integer.MAX_VALUE;
            this.cubes.clear();
            this.formula = this.rmgr.makeTrue();
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public Region getResult() {
            if (this.cubes.size() > 0) {
                this.buildBalancedOr();
            }
            return this.formula;
        }

        private void buildBalancedOr() {
            this.cubes.add(this.formula);
            while (this.cubes.size() > 1) {
                Region b1 = this.cubes.remove();
                Region b2 = this.cubes.remove();
                this.cubes.add(this.rmgr.makeOr(b1, b2));
            }
            assert (this.cubes.size() == 1);
            this.formula = this.cubes.remove();
        }

        @Override
        public void callback(long[] model) {
            this.totalTime.start();
            ArrayDeque<Region> curCube = new ArrayDeque<Region>(model.length + 1);
            Region m = this.rmgr.makeTrue();
            for (long t : model) {
                Region v;
                if (Mathsat5NativeApi.msat_term_is_not(this.env, t)) {
                    t = Mathsat5NativeApi.msat_term_get_arg(t, 0);
                    v = this.rmgr.getPredicate(new Mathsat5Formula(this.env, t));
                    v = this.rmgr.makeNot(v);
                } else {
                    v = this.rmgr.getPredicate(new Mathsat5Formula(this.env, t));
                }
                curCube.add(v);
            }
            curCube.add(m);
            while (curCube.size() > 1) {
                Region v1 = (Region)curCube.remove();
                Region v2 = (Region)curCube.remove();
                curCube.add(this.rmgr.makeAnd(v1, v2));
            }
            assert (curCube.size() == 1);
            m = (Region)curCube.remove();
            this.cubes.add(m);
            ++this.count;
            this.totalTime.stop();
        }
    }
}

