/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.simpleformulas;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.Term;

public class Predicate {
    private final Comparison mComparison;
    private final Term mLeftTerm;
    private final Term mRightTerm;
    private final String mString;

    public Predicate(Term pLeftTerm, Comparison pComparison, Term pRightTerm) {
        this.mLeftTerm = (Term)Preconditions.checkNotNull((Object)pLeftTerm);
        this.mComparison = (Comparison)((Object)Preconditions.checkNotNull((Object)((Object)pComparison)));
        this.mRightTerm = (Term)Preconditions.checkNotNull((Object)pRightTerm);
        this.mString = this.mLeftTerm.toString() + " " + this.mComparison.operatorSymbol() + " " + this.mRightTerm.toString();
    }

    public Predicate negate() {
        Comparison lComparison = null;
        switch (this.mComparison) {
            case GREATER_OR_EQUAL: {
                lComparison = Comparison.LESS;
                break;
            }
            case GREATER: {
                lComparison = Comparison.LESS_OR_EQUAL;
                break;
            }
            case EQUAL: {
                lComparison = Comparison.NOT_EQUAL;
                break;
            }
            case LESS_OR_EQUAL: {
                lComparison = Comparison.GREATER;
                break;
            }
            case LESS: {
                lComparison = Comparison.GREATER_OR_EQUAL;
                break;
            }
            case NOT_EQUAL: {
                lComparison = Comparison.EQUAL;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new Predicate(this.mLeftTerm, lComparison, this.mRightTerm);
    }

    public Comparison getComparison() {
        return this.mComparison;
    }

    public Term getLeftTerm() {
        return this.mLeftTerm;
    }

    public Term getRightTerm() {
        return this.mRightTerm;
    }

    public String toString() {
        return this.mString;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass() == this.getClass()) {
            Predicate lOther = (Predicate)pOther;
            return this.mLeftTerm.equals(lOther.mLeftTerm) && this.mRightTerm.equals(lOther.mRightTerm) && this.mComparison.equals((Object)lOther.mComparison);
        }
        return false;
    }

    public int hashCode() {
        return 3045820 + this.mLeftTerm.hashCode() + this.mComparison.hashCode() + this.mRightTerm.hashCode();
    }

    public static enum Comparison {
        GREATER_OR_EQUAL(">="),
        GREATER(">"),
        EQUAL("=="),
        LESS_OR_EQUAL("<="),
        LESS("<"),
        NOT_EQUAL("!=");

        private final String symbol;

        private Comparison(String pSymbol) {
            this.symbol = pSymbol;
        }

        public String operatorSymbol() {
            return this.symbol;
        }
    }
}

