/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.simpleformulas.translators.c;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.Constant;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.Predicate;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.TermVisitor;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.Variable;

public class PredicateTranslator {
    private static Map<Predicate, String> mCache = new HashMap<Predicate, String>();

    public static String translate(Predicate pPredicate) {
        if (mCache.containsKey(pPredicate)) {
            return mCache.get(pPredicate);
        }
        HashSet lVariables = new HashSet();
        Visitor lVisitor = new Visitor();
        lVariables.addAll(pPredicate.getLeftTerm().accept(lVisitor));
        lVariables.addAll(pPredicate.getRightTerm().accept(lVisitor));
        StringBuffer lResult = new StringBuffer();
        lResult.append("void predicate(");
        boolean isFirst = true;
        for (String lVariable : lVariables) {
            if (isFirst) {
                isFirst = false;
            } else {
                lResult.append(", ");
            }
            lResult.append("int ");
            lResult.append(lVariable);
        }
        lResult.append(") { (");
        lResult.append(pPredicate.toString());
        lResult.append("); }");
        mCache.put(pPredicate, lResult.toString());
        return lResult.toString();
    }

    private static class Visitor
    implements TermVisitor<Set<String>> {
        private Visitor() {
        }

        @Override
        public Set<String> visit(Constant pConstant) {
            return Collections.emptySet();
        }

        @Override
        public Set<String> visit(Variable pVariable) {
            return Collections.singleton(pVariable.toString());
        }
    }
}

