/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sei.rtss.jldd.test;

import edu.cmu.sei.rtss.jldd.LDDBuilder;
import edu.cmu.sei.rtss.jldd.swig.JLDD;
import edu.cmu.sei.rtss.jldd.swig.theory_t;
import edu.toronto.cs.expr.BoolOp;
import edu.toronto.cs.expr.ComparisonOp;
import edu.toronto.cs.expr.Expr;
import edu.toronto.cs.expr.ExprFactory;
import edu.toronto.cs.expr.ExprFactoryImpl;
import edu.toronto.cs.expr.NumericOp;
import junit.framework.TestCase;

public class LDDBuilderTestCase
extends TestCase {
    public void test1() {
        ExprFactoryImpl ef = new ExprFactoryImpl();
        Expr x = ef.var("x");
        Expr y = ef.var("y");
        Expr z = ef.var("z");
        Expr i0 = ef.intExpr(0L);
        Expr ni1 = ef.intExpr(-1L);
        Expr i1 = ef.intExpr(1L);
        theory_t theory = JLDD.tvpi_create_theory(6L);
        int tdd = JLDD.jldd_init(theory);
        LDDBuilder lb = new LDDBuilder(tdd, (ExprFactory)ef);
        Expr e1 = ComparisonOp.leq((Expr)NumericOp.plus((Expr)x, (Expr)y), (Expr)i0);
        int ldd1 = lb.eval(e1);
        JLDD.jldd_ref(ldd1);
        System.out.println("Expr1 is : " + e1);
        JLDD.Ldd_PrintMinterm(tdd, ldd1);
        System.out.println(lb.toExpr(ldd1));
        Expr e2 = ComparisonOp.leq((Expr)NumericOp.plus((Expr)x, (Expr)NumericOp.mult((Expr)ni1, (Expr)z)), (Expr)i1);
        int ldd2 = lb.eval(e2);
        JLDD.jldd_ref(ldd2);
        System.out.println("Expr2 is : " + e2);
        JLDD.Ldd_PrintMinterm(tdd, ldd2);
        System.out.println(lb.toExpr(ldd2));
        Expr e3 = ComparisonOp.leq((Expr)NumericOp.plus((Expr)x, (Expr)NumericOp.mult((Expr)z, (Expr)ni1)), (Expr)i1);
        int ldd3 = lb.eval(e3);
        JLDD.jldd_ref(ldd3);
        System.out.println("Expr3 is : " + e3);
        JLDD.Ldd_PrintMinterm(tdd, ldd3);
        System.out.println(lb.toExpr(ldd3));
        LDDBuilderTestCase.assertTrue((ldd2 == ldd3 ? 1 : 0) != 0);
        Expr e4 = BoolOp.lor((Expr)e1, (Expr)e2);
        int ldd4 = lb.eval(e4);
        JLDD.jldd_ref(ldd4);
        System.out.println("Expr 4 is: " + e4);
        JLDD.Ldd_PrintMinterm(tdd, ldd4);
        System.out.println(lb.toExpr(ldd4));
        Expr e5 = BoolOp.forall((Expr)z, (Expr)e4);
        int ldd5 = lb.eval(e5);
        System.out.println("Expr 5 is: " + e5);
        JLDD.Ldd_PrintMinterm(tdd, ldd5);
        System.out.println(lb.toExpr(ldd5));
        JLDD.jldd_quit(tdd);
        JLDD.tvpi_destroy_theory(theory);
    }

    static {
        System.loadLibrary("JLDD");
    }
}

