/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.sosy_lab.common.LogManager;

public class AbstractMBean {
    private static final MBeanServer mbs = AbstractMBean.getMBeanServer();
    private ObjectName oname = null;
    private final LogManager logger;

    private static MBeanServer getMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public AbstractMBean(String name, LogManager logger) {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)logger);
        if (mbs != null) {
            try {
                this.oname = new ObjectName((String)Preconditions.checkNotNull((Object)name));
            }
            catch (MalformedObjectNameException e) {
                logger.logException(Level.WARNING, e, "Invalid object name specified for management interface");
            }
        }
    }

    public void register() {
        if (mbs != null && this.oname != null) {
            try {
                if (mbs.isRegistered(this.oname)) {
                    mbs.unregisterMBean(this.oname);
                    assert (!mbs.isRegistered(this.oname));
                }
                mbs.registerMBean(this, this.oname);
            }
            catch (JMException e) {
                this.logger.logException(Level.WARNING, e, "Error during registration of management interface");
                this.oname = null;
            }
            catch (SecurityException e) {
                this.logger.logException(Level.WARNING, e, "Error during registration of management interface");
                this.oname = null;
            }
        } else {
            this.logger.log(Level.WARNING, "Cannot register management interface");
        }
    }

    public void unregister() {
        if (mbs != null && this.oname != null) {
            try {
                mbs.unregisterMBean(this.oname);
            }
            catch (JMException e) {
                this.logger.logException(Level.WARNING, e, "Error during unregistration of management interface");
            }
            catch (SecurityException e) {
                this.logger.logException(Level.WARNING, e, "Error during unregistration of management interface");
            }
        }
    }
}

