/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;

public final class Files {
    private Files() {
    }

    public static File createTempFile(String prefix, String suffix, String content) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        if (!Strings.isNullOrEmpty((String)content)) {
            try {
                com.google.common.io.Files.write((CharSequence)content, (File)file, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                file.delete();
                throw e;
            }
        }
        return file;
    }

    public static void writeFile(File file, Object content) throws IOException {
        com.google.common.io.Files.createParentDirs((File)file);
        com.google.common.io.Files.write((CharSequence)content.toString(), (File)file, (Charset)Charset.defaultCharset());
    }

    public static void appendToFile(File file, Object content) throws IOException {
        com.google.common.io.Files.append((CharSequence)content.toString(), (File)file, (Charset)Charset.defaultCharset());
    }

    public static void checkReadableFile(File file) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)file);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist!");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " is not a normal file!");
        }
        if (!file.canRead()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " is not readable!");
        }
    }
}

