/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.Timer;

public class NestedTimer {
    private volatile long outerStartTime = 0L;
    private long innerSumTime = 0L;
    private long outerSumTime = 0L;
    private volatile Timer innerTimer = null;
    private long innerMaxTime = 0L;
    private long outerMaxTime = 0L;
    private long totalMaxTime = 0L;
    private int totalNumberOfIntervals = 0;

    public final void startOuter() {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0);
        assert (this.innerTimer == null);
        this.outerStartTime = System.currentTimeMillis();
        this.innerTimer = new Timer();
        ++this.totalNumberOfIntervals;
    }

    public final void startBoth() {
        this.startOuter();
        this.innerTimer = new Timer(this.outerStartTime);
    }

    public final long stopOuter() {
        Preconditions.checkState((boolean)this.isOuterRunning());
        return this.stopOuter0(System.currentTimeMillis());
    }

    private long stopOuter0(long endTime) {
        long totalIntervallTime = endTime - this.outerStartTime;
        this.totalMaxTime = Math.max(totalIntervallTime, this.totalMaxTime);
        long currentInnerSumTime = this.innerTimer.getSumTime();
        long outerIntervallTime = totalIntervallTime - currentInnerSumTime;
        this.outerSumTime += outerIntervallTime;
        this.outerMaxTime = Math.max(outerIntervallTime, this.outerMaxTime);
        this.innerSumTime += currentInnerSumTime;
        this.innerMaxTime = Math.max(currentInnerSumTime, this.innerMaxTime);
        this.outerStartTime = 0L;
        this.innerTimer = null;
        return outerIntervallTime;
    }

    public final long stopBoth() {
        Preconditions.checkState((boolean)this.innerTimer.isRunning());
        assert (this.isRunning());
        long endTime = System.currentTimeMillis();
        long totalIntervallTime = endTime - this.outerStartTime;
        this.innerTimer.stop(endTime);
        this.stopOuter0(endTime);
        return totalIntervallTime;
    }

    private long getCurrentOuterIntervalTime() {
        if (!this.isRunning()) {
            return 0L;
        }
        return this.getCurrentTotalIntervalTime() - this.innerTimer.getSumTime();
    }

    private long getCurrentTotalIntervalTime() {
        if (!this.isRunning()) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long currentTotal = currentTime - this.outerStartTime;
        return currentTotal;
    }

    public Timer getInnerTimer() {
        Preconditions.checkState((boolean)this.isRunning());
        return this.innerTimer;
    }

    public final long getOuterSumTime() {
        return this.outerSumTime + this.getCurrentOuterIntervalTime();
    }

    public final long getInnerSumTime() {
        long result = this.innerSumTime;
        if (this.isRunning()) {
            result += this.innerTimer.getSumTime();
        }
        return result;
    }

    public final long getTotalSumTime() {
        return this.outerSumTime + this.innerSumTime + this.getCurrentTotalIntervalTime();
    }

    public final long getOuterMaxTime() {
        return this.outerMaxTime;
    }

    public final long getInnerMaxTime() {
        return this.innerMaxTime;
    }

    public final long getTotalMaxTime() {
        return this.totalMaxTime;
    }

    public final int getNumberOfIntervals() {
        return this.totalNumberOfIntervals;
    }

    public final long getOuterAvgTime() {
        return this.getOuterSumTime() / (long)this.totalNumberOfIntervals;
    }

    public final long getInnerAvgTime() {
        return this.getInnerSumTime() / (long)this.totalNumberOfIntervals;
    }

    public final long getTotalAvgTime() {
        return this.getTotalSumTime() / (long)this.totalNumberOfIntervals;
    }

    public final String printOuterSumTime() {
        return NestedTimer.formatTime(this.getOuterSumTime());
    }

    public final String printInnerSumTime() {
        return NestedTimer.formatTime(this.getInnerSumTime());
    }

    public final String printTotalSumTime() {
        return NestedTimer.formatTime(this.getTotalSumTime());
    }

    public final String printOuterMaxTime() {
        return NestedTimer.formatTime(this.getOuterMaxTime());
    }

    public final String printInnerMaxTime() {
        return NestedTimer.formatTime(this.getInnerMaxTime());
    }

    public final String printTotalMaxTime() {
        return NestedTimer.formatTime(this.getTotalMaxTime());
    }

    public final String printOuterAvgTime() {
        return NestedTimer.formatTime(this.getOuterAvgTime());
    }

    public final String printInnerAvgTime() {
        return NestedTimer.formatTime(this.getInnerAvgTime());
    }

    public final String printTotalAvgTime() {
        return NestedTimer.formatTime(this.getTotalAvgTime());
    }

    public final String toString() {
        return NestedTimer.formatTime(this.getTotalSumTime());
    }

    public static String formatTime(long time) {
        return String.format("%5d.%03ds", time / 1000L, time % 1000L);
    }

    public boolean isOuterRunning() {
        return this.isRunning() && !this.innerTimer.isRunning();
    }

    public boolean isRunning() {
        return this.outerStartTime != 0L;
    }
}

