/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;

public class TimeAccumulator {
    private long[] mMilliseconds;
    private long mStartTime;
    private boolean mActive;

    public TimeAccumulator(int pNumberOfSlots) {
        Preconditions.checkArgument((pNumberOfSlots > 0 ? 1 : 0) != 0);
        this.mMilliseconds = new long[pNumberOfSlots];
        for (int lIndex = 0; lIndex < pNumberOfSlots; ++lIndex) {
            this.mMilliseconds[lIndex] = 0L;
        }
        this.mActive = false;
    }

    public TimeAccumulator() {
        this(1);
    }

    public void proceed() {
        Preconditions.checkState((!this.mActive ? 1 : 0) != 0);
        this.mActive = true;
        this.mStartTime = System.currentTimeMillis();
    }

    public void pause(int pSlot) {
        Preconditions.checkArgument((pSlot >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((pSlot < this.mMilliseconds.length ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.mActive);
        int n = pSlot;
        this.mMilliseconds[n] = this.mMilliseconds[n] + (System.currentTimeMillis() - this.mStartTime);
        this.mActive = false;
    }

    public void pause() {
        this.pause(0);
    }

    public double getSeconds(int pSlot) {
        Preconditions.checkArgument((pSlot >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((pSlot < this.mMilliseconds.length ? 1 : 0) != 0);
        Preconditions.checkState((!this.mActive ? 1 : 0) != 0);
        return (double)this.mMilliseconds[pSlot] / 1000.0;
    }

    public double getSeconds() {
        return this.getSeconds(0);
    }
}

