/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;

public class Timer {
    private volatile long startTime = 0L;
    private long sumTime = 0L;
    private long maxTime = 0L;
    private int numberOfIntervals = 0;
    private long lastIntervalLength = 0L;

    public Timer() {
    }

    Timer(long startTime) {
        Preconditions.checkState((startTime > 0L ? 1 : 0) != 0);
        this.startTime = startTime;
    }

    public final void start() {
        if (this.isRunning()) {
            this.stop();
        }
        this.startTime = System.currentTimeMillis();
        ++this.numberOfIntervals;
    }

    public final long stop() {
        return this.stop(System.currentTimeMillis());
    }

    final long stop(long endTime) {
        if (this.isRunning()) {
            this.lastIntervalLength = endTime - this.startTime;
            this.sumTime += this.lastIntervalLength;
            this.maxTime = Math.max(this.lastIntervalLength, this.maxTime);
            this.startTime = 0L;
            return this.lastIntervalLength;
        }
        return 0L;
    }

    public final long getSumTime() {
        if (this.isRunning()) {
            return this.sumTime + System.currentTimeMillis() - this.startTime;
        }
        return this.sumTime;
    }

    public final long getMaxTime() {
        return this.maxTime;
    }

    public final int getNumberOfIntervals() {
        return this.numberOfIntervals;
    }

    public final long getLengthOfLasterInterval() {
        return this.lastIntervalLength;
    }

    public final long getAvgTime() {
        return this.getSumTime() / (long)this.numberOfIntervals;
    }

    public final String printMaxTime() {
        return Timer.formatTime(this.getMaxTime());
    }

    public final String printAvgTime() {
        return Timer.formatTime(this.getAvgTime());
    }

    public final String toString() {
        return Timer.formatTime(this.getSumTime());
    }

    public static String formatTime(long time) {
        return String.format("%5d.%03ds", time / 1000L, time % 1000L);
    }

    public boolean isRunning() {
        return this.startTime != 0L;
    }
}

